/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.queued;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassConstants;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.queued.AddOperation;
import org.datanucleus.store.types.queued.QueuedOperation;
import org.datanucleus.store.types.queued.RemoveCollectionOperation;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCOOperationQueue {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected List<QueuedOperation> queuedOperations = new ArrayList<QueuedOperation>();

    public void enqueue(QueuedOperation oper) {
        this.queuedOperations.add(oper);
    }

    public void clear() {
        this.queuedOperations.clear();
    }

    public List<QueuedOperation> getOperations() {
        return Collections.unmodifiableList(this.queuedOperations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAll(Store store, ObjectProvider op) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023005", (Object)op.getObjectAsPrintable(), (Object)store.getOwnerMemberMetaData().getFullFieldName()));
        }
        ArrayList<QueuedOperation> flushOperations = new ArrayList<QueuedOperation>();
        SCOOperationQueue sCOOperationQueue = this;
        synchronized (sCOOperationQueue) {
            ListIterator<QueuedOperation> operIter = this.queuedOperations.listIterator();
            while (operIter.hasNext()) {
                QueuedOperation oper = operIter.next();
                if (oper.getStore() != store) continue;
                flushOperations.add(oper);
                operIter.remove();
            }
        }
        ListIterator<QueuedOperation> flushOperIter = flushOperations.listIterator();
        while (flushOperIter.hasNext()) {
            QueuedOperation oper = (QueuedOperation)flushOperIter.next();
            if (this.isAddFollowedByRemoveOnSameSCO(store, op, oper, flushOperIter)) {
                flushOperIter.next();
                continue;
            }
            if (this.isRemoveFollowedByAddOnSameSCO(store, op, oper, flushOperIter)) {
                flushOperIter.next();
                continue;
            }
            oper.perform();
        }
    }

    protected boolean isAddFollowedByRemoveOnSameSCO(Store store, ObjectProvider op, QueuedOperation currentOper, ListIterator<QueuedOperation> listIter) {
        if (AddOperation.class.isInstance(currentOper)) {
            boolean addThenRemove = false;
            if (listIter.hasNext()) {
                Object value;
                QueuedOperation operNext = listIter.next();
                if (RemoveCollectionOperation.class.isInstance(operNext) && (value = ((AddOperation)AddOperation.class.cast(currentOper)).getValue()) == ((RemoveCollectionOperation)RemoveCollectionOperation.class.cast(operNext)).getValue()) {
                    addThenRemove = true;
                    NucleusLogger.PERSISTENCE.info("Member " + store.getOwnerMemberMetaData().getFullFieldName() + " of " + StringUtils.toJVMIDString(op.getObject()) + " had an add then a remove of element " + StringUtils.toJVMIDString(value) + " - operations ignored");
                }
                listIter.previous();
            }
            return addThenRemove;
        }
        return false;
    }

    protected boolean isRemoveFollowedByAddOnSameSCO(Store store, ObjectProvider op, QueuedOperation currentOper, ListIterator<QueuedOperation> listIter) {
        if (RemoveCollectionOperation.class.isInstance(currentOper)) {
            boolean removeThenAdd = false;
            if (listIter.hasNext()) {
                Object value;
                QueuedOperation opNext = listIter.next();
                if (AddOperation.class.isInstance(opNext) && (value = ((RemoveCollectionOperation)RemoveCollectionOperation.class.cast(currentOper)).getValue()) == ((AddOperation)AddOperation.class.cast(opNext)).getValue()) {
                    removeThenAdd = true;
                    NucleusLogger.PERSISTENCE.info("Member" + store.getOwnerMemberMetaData().getFullFieldName() + " of " + StringUtils.toJVMIDString(op.getObject()) + " had a remove then add of element " + StringUtils.toJVMIDString(value) + " - operations ignored");
                }
                if (!removeThenAdd) {
                    listIter.previous();
                }
            }
            return removeThenAdd;
        }
        return false;
    }
}

