/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.codehaus.classworlds.ClassPathHacker;
import org.codehaus.classworlds.ConfigurationException;
import org.codehaus.classworlds.ConfigurationHandler;
import org.codehaus.classworlds.ConfigurationParser;

public class InnerLauncher
implements ConfigurationHandler {
    protected static final String CLASSWORLDS_CONF = "classworlds.conf";
    protected static final String UBERJAR_CONF_DIR = "WORLDS-INF/conf/";
    protected ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();
    private String mainClassName;

    public void setSystemClassLoader(ClassLoader loader) {
        this.systemClassLoader = loader;
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public static void main(String[] args) throws Exception {
        String classworldsConf = System.getProperty(CLASSWORLDS_CONF);
        InnerLauncher launcher = new InnerLauncher();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        launcher.setSystemClassLoader(cl);
        InputStream is = classworldsConf != null ? new FileInputStream(classworldsConf) : ("true".equals(System.getProperty("classworlds.bootstrapped")) ? cl.getResourceAsStream("WORLDS-INF/conf/classworlds.conf") : cl.getResourceAsStream(CLASSWORLDS_CONF));
        if (is == null) {
            throw new Exception("classworlds configuration not specified nor found in the classpath");
        }
        launcher.configure(is);
        launcher.launch(args);
    }

    private void launch(String[] args) throws Exception {
        Class<?> mainClass = Class.forName(this.mainClassName);
        Method mainMethod = this.getMainMethod(mainClass);
        Object ret = mainMethod.invoke(mainClass, new Object[]{args});
    }

    protected Method getMainMethod(Class<?> mainClass) throws ClassNotFoundException, NoSuchMethodException {
        Method m = mainClass.getMethod("main", String[].class);
        int modifiers = m.getModifiers();
        if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && (m.getReturnType() == Integer.TYPE || m.getReturnType() == Void.TYPE)) {
            return m;
        }
        throw new NoSuchMethodException("public static void main(String[] args) in " + mainClass);
    }

    public void configure(InputStream is) throws IOException, ConfigurationException {
        ConfigurationParser configurator = new ConfigurationParser(this, System.getProperties());
        configurator.parse(is);
    }

    @Override
    public void setAppMain(String mainClassName, String mainRealmName) {
        this.mainClassName = mainClassName;
    }

    @Override
    public void addLoadFile(File file) {
        ClassPathHacker.addFile(file);
    }

    @Override
    public void addLoadURL(URL url) {
        ClassPathHacker.addURL(url);
    }
}

