package org.codehaus.classworlds;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;

public class InnerLauncher implements ConfigurationHandler{
    protected static final String CLASSWORLDS_CONF = "classworlds.conf";

    protected static final String UBERJAR_CONF_DIR = "WORLDS-INF/conf/";
    protected ClassLoader systemClassLoader;
    private String mainClassName;
    
    public InnerLauncher()
    {
        this.systemClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void setSystemClassLoader( ClassLoader loader )
    {
        this.systemClassLoader = loader;
    }

    public ClassLoader getSystemClassLoader()
    {
        return this.systemClassLoader;
    }
    
	public static void main(String[] args) throws Exception {
		
		String classworldsConf = System.getProperty( CLASSWORLDS_CONF );

        InputStream is;

        InnerLauncher launcher = new InnerLauncher();

        ClassLoader cl = Thread.currentThread().getContextClassLoader();

        launcher.setSystemClassLoader( cl );

        if ( classworldsConf != null )
        {
            is = new FileInputStream( classworldsConf );
        }
        else
        {
            if ( "true".equals( System.getProperty( "classworlds.bootstrapped" ) ) )
            {
                is = cl.getResourceAsStream( UBERJAR_CONF_DIR + CLASSWORLDS_CONF );
            }
            else
            {
                is = cl.getResourceAsStream( CLASSWORLDS_CONF );
            }
        }

        if ( is == null )
        {
            throw new Exception( "classworlds configuration not specified nor found in the classpath" );
        }

        launcher.configure( is );

        launcher.launch( args );
    }

	private void launch(String[] args) throws Exception {
		Class<?> mainClass = Class.forName(this.mainClassName);
        Method mainMethod = getMainMethod(mainClass);
        Object ret = mainMethod.invoke( mainClass, new Object[]{args} );
	}

    protected Method getMainMethod(Class<?> mainClass)
            throws ClassNotFoundException, NoSuchMethodException
        {
            Method m = mainClass.getMethod( "main", new Class[]{String[].class} );

            int modifiers = m.getModifiers();

            if ( Modifier.isStatic( modifiers ) && Modifier.isPublic( modifiers ) )
            {
                if ( m.getReturnType() == Integer.TYPE || m.getReturnType() == Void.TYPE )
                {
                    return m;
                }
            }

            throw new NoSuchMethodException( "public static void main(String[] args) in " + mainClass );
        }


	public void configure( InputStream is )
        throws IOException, ConfigurationException
    {
		ConfigurationParser configurator = new ConfigurationParser(this, System.getProperties() );
        configurator.parse( is );
    }

	public void setAppMain(String mainClassName, String mainRealmName) {
		this.mainClassName = mainClassName;
	}

	public void addLoadFile(File file) {
		ClassPathHacker.addFile(file);
	}

	public void addLoadURL(URL url) {
		ClassPathHacker.addURL(url);
	}

}
