package org.codehaus.classworlds;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassPathHacker {

	private static final Class[] parameters = new Class[] { URL.class };

	public static void addFile(String s) {
		File f = new File(s);
		addFile(f);
	}

	public static void addFile(File f) {
		try {
			addURL(f.toURL());
		} catch (MalformedURLException e) {
			throw new ClassLoaderModifyException("Error, could not add file="+f.getAbsolutePath()+" to system classloader",e);
		}
	}

	public static void addURL(URL u) {

		URLClassLoader sysloader = (URLClassLoader) ClassLoader.getSystemClassLoader();
		Class sysclass = URLClassLoader.class;

		try {
			Method method = sysclass.getDeclaredMethod("addURL", parameters);
			method.setAccessible(true);
			method.invoke(sysloader, new Object[] { u });
		} catch (Throwable t) {
			throw new ClassLoaderModifyException("Error, could not add URL="+u+" to system classloader",t);
		}

	}

}