/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds.launcher;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import org.codehaus.plexus.classworlds.launcher.Configurator;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class Launcher {
    protected static final String CLASSWORLDS_CONF = "classworlds.conf";
    protected static final String UBERJAR_CONF_DIR = "WORLDS-INF/conf/";
    protected ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();
    protected String mainClassName;
    protected String mainRealmName;
    protected ClassWorld world;
    private int exitCode = 0;

    public void setSystemClassLoader(ClassLoader loader) {
        this.systemClassLoader = loader;
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setAppMain(String mainClassName, String mainRealmName) {
        this.mainClassName = mainClassName;
        this.mainRealmName = mainRealmName;
    }

    public String getMainRealmName() {
        return this.mainRealmName;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setWorld(ClassWorld world) {
        this.world = world;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    public void configure(InputStream is) throws IOException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        Configurator configurator = new Configurator(this);
        configurator.configure(is);
    }

    public Class getMainClass() throws ClassNotFoundException, NoSuchRealmException {
        return this.getMainRealm().loadClass(this.getMainClassName());
    }

    public ClassRealm getMainRealm() throws NoSuchRealmException {
        return this.getWorld().getRealm(this.getMainRealmName());
    }

    protected Method getEnhancedMainMethod() throws ClassNotFoundException, NoSuchMethodException, NoSuchRealmException {
        Class cwClass = this.getMainRealm().loadClass(ClassWorld.class.getName());
        Method m = this.getMainClass().getMethod("main", String[].class, cwClass);
        int modifiers = m.getModifiers();
        if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && (m.getReturnType() == Integer.TYPE || m.getReturnType() == Void.TYPE)) {
            return m;
        }
        throw new NoSuchMethodException("public static void main(String[] args, ClassWorld world)");
    }

    protected Method getMainMethod() throws ClassNotFoundException, NoSuchMethodException, NoSuchRealmException {
        Method m = this.getMainClass().getMethod("main", String[].class);
        int modifiers = m.getModifiers();
        if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && (m.getReturnType() == Integer.TYPE || m.getReturnType() == Void.TYPE)) {
            return m;
        }
        throw new NoSuchMethodException("public static void main(String[] args) in " + this.getMainClass());
    }

    public void launch(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        try {
            this.launchEnhanced(args);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.launchStandard(args);
            return;
        }
    }

    protected void launchEnhanced(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        ClassRealm mainRealm = this.getMainRealm();
        Class mainClass = this.getMainClass();
        Method mainMethod = this.getEnhancedMainMethod();
        ClassRealm cl = mainRealm;
        Thread.currentThread().setContextClassLoader(cl);
        Object ret = mainMethod.invoke((Object)mainClass, args, this.getWorld());
        if (ret instanceof Integer) {
            this.exitCode = (Integer)ret;
        }
    }

    protected void launchStandard(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        ClassRealm mainRealm = this.getMainRealm();
        Class mainClass = this.getMainClass();
        Method mainMethod = this.getMainMethod();
        Thread.currentThread().setContextClassLoader(mainRealm);
        Object ret = mainMethod.invoke((Object)mainClass, new Object[]{args});
        if (ret instanceof Integer) {
            this.exitCode = (Integer)ret;
        }
    }

    public static void main(String[] args) {
        try {
            int exitCode = Launcher.mainWithExitCode(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    public static int mainWithExitCode(String[] args) throws Exception {
        String classworldsConf = System.getProperty(CLASSWORLDS_CONF);
        Launcher launcher = new Launcher();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        launcher.setSystemClassLoader(cl);
        InputStream is = classworldsConf != null ? new FileInputStream(classworldsConf) : ("true".equals(System.getProperty("classworlds.bootstrapped")) ? cl.getResourceAsStream("WORLDS-INF/conf/classworlds.conf") : cl.getResourceAsStream(CLASSWORLDS_CONF));
        if (is == null) {
            throw new Exception("classworlds configuration not specified nor found in the classpath");
        }
        launcher.configure(is);
        try {
            launcher.launch(args);
        }
        catch (InvocationTargetException e) {
            ClassRealm realm = launcher.getWorld().getRealm(launcher.getMainRealmName());
            URL[] constituents = realm.getURLs();
            System.out.println("---------------------------------------------------");
            for (int i = 0; i < constituents.length; ++i) {
                System.out.println("constituent[" + i + "]: " + constituents[i]);
            }
            System.out.println("---------------------------------------------------");
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw e;
        }
        return launcher.getExitCode();
    }
}

