/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.codehaus.classworlds.SignalUtil;

public class Launcher
extends org.codehaus.plexus.classworlds.launcher.Launcher {
    public static void main(String[] args) {
        String appName = ManagementFactory.getRuntimeMXBean().getName();
        final String pid = appName.substring(0, appName.indexOf("@"));
        String pidPath = System.getProperty("project.pid.path", System.getProperty("project.home", "."));
        final File pidFile = new File(pidPath, System.getProperty("project.name", "") + ".pid");
        final File lockFile = new File(pidPath, ".lock");
        final SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            final FileOutputStream lockFos = new FileOutputStream(lockFile);
            final FileLock lock = lockFos.getChannel().tryLock();
            if (lock == null) {
                if (pidFile.exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(pidFile));
                    String oldPid = reader.readLine();
                    reader.close();
                    System.out.println(pidFile.getName() + "  is locked. please shutdown the old process=" + oldPid);
                } else {
                    System.out.println(pidFile.getName() + "  is locked. please shutdown the old process");
                }
                lockFos.close();
                System.exit(0);
                return;
            }
            final FileOutputStream fos = new FileOutputStream(pidFile);
            final OutputStreamWriter writer = new OutputStreamWriter(fos);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (lock != null) {
                        try {
                            lock.release();
                            lockFos.close();
                            writer.close();
                            fos.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    lockFile.delete();
                    pidFile.delete();
                    System.out.println(" " + formate.format(new Date()) + " [INFO] Project Name=" + System.getProperty("project.name", "") + ", PID=" + pid + " , System shutdown ....");
                }
            });
            writer.write(pid);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println(" " + formate.format(new Date()) + " [INFO] Project Name=" + System.getProperty("project.name", "") + ", PID=" + pid + " , starting...");
        SignalUtil.Handler IGNORE = new SignalUtil.Handler(){

            public void signalReceived(SignalUtil.Number number) {
                System.out.println(" " + formate.format(new Date()) + " [INFO] ignore signal:" + number.name());
            }
        };
        HashMap<String, SignalUtil.Number> signalMap = new HashMap<String, SignalUtil.Number>();
        for (SignalUtil.Number number : SignalUtil.Number.values()) {
            signalMap.put(number.name(), number);
            signalMap.put(number._signo + "", number);
        }
        String ignores = System.getProperty("ignore.signals");
        if (ignores != null && ignores.trim().length() > 0) {
            StringTokenizer tokens = new StringTokenizer(ignores, ",");
            while (tokens.hasMoreTokens()) {
                SignalUtil.Number number;
                String token = tokens.nextToken().trim();
                number = (SignalUtil.Number)((Object)signalMap.get(token));
                if (number == null) continue;
                try {
                    SignalUtil.register(number, IGNORE);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        try {
            Launcher.mainWithExitCode(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static int mainWithExitCode(String[] args) throws Exception {
        return org.codehaus.plexus.classworlds.launcher.Launcher.mainWithExitCode(args);
    }
}

