/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class ConfigurationParser {
    public static final String MAIN_PREFIX = "main is";
    public static final String SET_PREFIX = "set";
    public static final String IMPORT_PREFIX = "import";
    public static final String LOAD_PREFIX = "load";
    public static final String OPTIONALLY_PREFIX = "optionally";
    private ConfigurationHandler handler;
    private Properties systemProperties;

    public ConfigurationParser(ConfigurationHandler handler, Properties systemProperties) {
        this.handler = handler;
        this.systemProperties = systemProperties;
    }

    public void parse(InputStream is) throws IOException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = null;
        int lineNo = 0;
        boolean mainSet = false;
        String curRealm = null;
        while ((line = reader.readLine()) != null) {
            ++lineNo;
            if (this.canIgnore(line = line.trim())) continue;
            if (line.startsWith(MAIN_PREFIX)) {
                if (mainSet) {
                    throw new ConfigurationException("Duplicate main configuration", lineNo, line);
                }
                String conf = line.substring(MAIN_PREFIX.length()).trim();
                int fromLoc = conf.indexOf("from");
                if (fromLoc < 0) {
                    throw new ConfigurationException("Missing from clause", lineNo, line);
                }
                String mainClassName = conf.substring(0, fromLoc).trim();
                String mainRealmName = conf.substring(fromLoc + 4).trim();
                this.handler.setAppMain(mainClassName, mainRealmName);
                mainSet = true;
                continue;
            }
            if (line.startsWith(SET_PREFIX)) {
                File propertiesFile;
                String value;
                String conf = line.substring(SET_PREFIX.length()).trim();
                int usingLoc = conf.indexOf(" using") + 1;
                String property = null;
                String propertiesFileName = null;
                if (usingLoc > 0) {
                    property = conf.substring(0, usingLoc).trim();
                    conf = propertiesFileName = this.filter(conf.substring(usingLoc + 5).trim());
                }
                String defaultValue = null;
                int defaultLoc = conf.indexOf(" default") + 1;
                if (defaultLoc > 0) {
                    defaultValue = conf.substring(defaultLoc + 7).trim();
                    if (property == null) {
                        property = conf.substring(0, defaultLoc).trim();
                    } else {
                        propertiesFileName = conf.substring(0, defaultLoc).trim();
                    }
                }
                if ((value = this.systemProperties.getProperty(property)) != null) continue;
                if (propertiesFileName != null && (propertiesFile = new File(propertiesFileName)).exists()) {
                    Properties properties = new Properties();
                    try {
                        properties.load(new FileInputStream(propertiesFileName));
                        value = properties.getProperty(property);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (value == null && defaultValue != null) {
                    value = defaultValue;
                }
                if (value == null) continue;
                value = this.filter(value);
                this.systemProperties.setProperty(property, value);
                continue;
            }
            if (line.startsWith("[")) {
                int rbrack = line.indexOf("]");
                if (rbrack < 0) {
                    throw new ConfigurationException("Invalid realm specifier", lineNo, line);
                }
                String realmName = line.substring(1, rbrack);
                this.handler.addRealm(realmName);
                curRealm = realmName;
                continue;
            }
            if (line.startsWith(IMPORT_PREFIX)) {
                if (curRealm == null) {
                    throw new ConfigurationException("Unhandled import", lineNo, line);
                }
                String conf = line.substring(IMPORT_PREFIX.length()).trim();
                int fromLoc = conf.indexOf("from");
                if (fromLoc < 0) {
                    throw new ConfigurationException("Missing from clause", lineNo, line);
                }
                String importSpec = conf.substring(0, fromLoc).trim();
                String relamName = conf.substring(fromLoc + 4).trim();
                this.handler.addImportFrom(relamName, importSpec);
                continue;
            }
            if (line.startsWith(LOAD_PREFIX)) {
                String constituent = line.substring(LOAD_PREFIX.length()).trim();
                if ((constituent = this.filter(constituent)).indexOf("*") >= 0) {
                    this.loadGlob(constituent, false);
                    continue;
                }
                File file = new File(constituent);
                if (file.exists()) {
                    this.handler.addLoadFile(file);
                    continue;
                }
                try {
                    this.handler.addLoadURL(new URL(constituent));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new FileNotFoundException(constituent);
                }
            }
            if (line.startsWith(OPTIONALLY_PREFIX)) {
                String constituent = line.substring(OPTIONALLY_PREFIX.length()).trim();
                if ((constituent = this.filter(constituent)).indexOf("*") >= 0) {
                    this.loadGlob(constituent, true);
                    continue;
                }
                File file = new File(constituent);
                if (file.exists()) {
                    this.handler.addLoadFile(file);
                    continue;
                }
                try {
                    this.handler.addLoadURL(new URL(constituent));
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            throw new ConfigurationException("Unhandled configuration", lineNo, line);
        }
        reader.close();
    }

    protected void loadGlob(String line, boolean optionally) throws MalformedURLException, FileNotFoundException, ConfigurationException {
        File globFile = new File(line);
        File dir = globFile.getParentFile();
        if (!dir.exists()) {
            if (optionally) {
                return;
            }
            throw new FileNotFoundException(dir.toString());
        }
        String localName = globFile.getName();
        int starLoc = localName.indexOf("*");
        final String prefix = localName.substring(0, starLoc);
        final String suffix = localName.substring(starLoc + 1);
        File[] matches = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.startsWith(prefix)) {
                    return false;
                }
                return name.endsWith(suffix);
            }
        });
        int i = 0;
        while (i < matches.length) {
            this.handler.addLoadFile(matches[i]);
            ++i;
        }
    }

    protected String filter(String text) throws ConfigurationException {
        String result = "";
        int cur = 0;
        int textLen = text.length();
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        String propValue = null;
        while (cur < textLen) {
            propStart = text.indexOf("${", cur);
            if (propStart < 0) break;
            result = String.valueOf(result) + text.substring(cur, propStart);
            propStop = text.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
            }
            propName = text.substring(propStart + 2, propStop);
            propValue = this.systemProperties.getProperty(propName);
            if (propName.equals("basedir") && (propValue == null || propValue.equals(""))) {
                propValue = new File("").getAbsolutePath();
            }
            if (propValue == null) {
                throw new ConfigurationException("No such property: " + propName);
            }
            result = String.valueOf(result) + propValue;
            cur = propStop + 1;
        }
        result = String.valueOf(result) + text.substring(cur);
        return result;
    }

    private boolean canIgnore(String line) {
        return line.length() == 0 || line.startsWith("#");
    }
}

