/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.codehaus.classworlds.SignalUtil;

public class Launcher
extends org.codehaus.plexus.classworlds.launcher.Launcher {
    public static void main(String[] args) {
        String appName = ManagementFactory.getRuntimeMXBean().getName();
        final String pid = appName.substring(0, appName.indexOf("@"));
        final File file = new File(System.getProperty("project.home", "."), String.valueOf(System.getProperty("project.name", "")) + ".pid");
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(pid);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        final SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(" " + formate.format(new Date()) + " [INFO] Project Name=" + System.getProperty("project.name", "") + ", PID=" + pid + " , starting...");
        SignalUtil.Handler IGNORE = new SignalUtil.Handler(){

            public void signalReceived(SignalUtil.Number number) {
                System.out.println(" " + formate.format(new Date()) + " [INFO] ignore signal:" + number.name());
            }
        };
        HashMap<String, SignalUtil.Number> signalMap = new HashMap<String, SignalUtil.Number>();
        SignalUtil.Number[] numberArray = SignalUtil.Number.values();
        int n = numberArray.length;
        int n2 = 0;
        while (n2 < n) {
            SignalUtil.Number number = numberArray[n2];
            signalMap.put(number.name(), number);
            signalMap.put(String.valueOf(number._signo), number);
            ++n2;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                file.delete();
                System.out.println(" " + formate.format(new Date()) + " [INFO] Project Name=" + System.getProperty("project.name", "") + ", PID=" + pid + " , System shutdown ....");
            }
        });
        String ignores = System.getProperty("ignore.signals");
        if (ignores != null && ignores.trim().length() > 0) {
            StringTokenizer tokens = new StringTokenizer(ignores, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                SignalUtil.Number number = (SignalUtil.Number)((Object)signalMap.get(token));
                if (number == null) continue;
                try {
                    SignalUtil.register(number, IGNORE);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        try {
            Launcher.mainWithExitCode(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static int mainWithExitCode(String[] args) throws Exception {
        return org.codehaus.plexus.classworlds.launcher.Launcher.mainWithExitCode(args);
    }
}

