/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.swt;

import com.jogamp.common.util.RunnableTask;
import com.jogamp.common.util.TaskBase;
import com.jogamp.newt.util.EDTUtil;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import org.eclipse.swt.widgets.Display;

public class SWTEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private final Object edtLock = new Object();
    private final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
    private final String name;
    private final Runnable dispatchMessages;
    private final Display swtDisplay;
    private NEDT nedt = null;
    private int start_iter = 0;
    private static long pollPeriod = 10L;

    public SWTEDTUtil(final com.jogamp.newt.Display display, Display display2) {
        this.name = Thread.currentThread().getName() + "-SWTDisplay-" + display.getFQName() + "-EDT-";
        this.dispatchMessages = new Runnable(){

            @Override
            public void run() {
                ((DisplayImpl)display).dispatchMessages();
            }
        };
        this.swtDisplay = display2;
        this.nedt = new NEDT(this.threadGroup, this.name);
        this.nedt.setDaemon(true);
    }

    public final Display getDisplay() {
        return this.swtDisplay;
    }

    @Override
    public long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public void setPollPeriod(long l) {
        pollPeriod = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws IllegalStateException {
        boolean bl = this.swtDisplay.isDisposed();
        Object object = this.edtLock;
        synchronized (object) {
            if (this.nedt.isRunning()) {
                String string;
                Thread thread;
                Thread thread2 = Thread.currentThread();
                if (!bl) {
                    thread = this.swtDisplay.getThread();
                    string = thread.getName();
                } else {
                    thread = null;
                    string = null;
                }
                boolean bl2 = thread == thread2;
                throw new IllegalStateException("EDT still running and not subject to stop. Curr " + thread2.getName() + ", NEDT " + this.nedt.getName() + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop + ", SWT-EDT " + string + ", on SWT-EDT " + bl2);
            }
            if (DEBUG) {
                System.err.println(Thread.currentThread() + ": SWT-EDT reset - edt: " + this.nedt + ", swtDisposed (skipping) " + bl);
            }
            if (!bl) {
                if (this.nedt.getState() != Thread.State.NEW) {
                    this.nedt = new NEDT(this.threadGroup, this.name);
                    this.nedt.setDaemon(true);
                }
                this.startImpl();
            }
        }
        if (!bl && !this.nedt.isRunning()) {
            throw new RuntimeException("EDT could not be started: " + this.nedt);
        }
    }

    private final void startImpl() {
        if (this.nedt.isAlive()) {
            throw new RuntimeException("SWT-EDT Thread.isAlive(): true, isRunning: " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop + ", edt: " + this.nedt);
        }
        ++this.start_iter;
        this.nedt.setName(this.name + this.start_iter);
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": SWT-EDT START - edt: " + this.nedt);
        }
        this.nedt.start();
    }

    @Override
    public boolean isCurrentThreadEDT() {
        return !this.swtDisplay.isDisposed() && this.swtDisplay.getThread() == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadNEDT() {
        return this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadEDTorNEDT() {
        Thread thread = Thread.currentThread();
        return !this.swtDisplay.isDisposed() && thread == this.swtDisplay.getThread() || thread == this.nedt;
    }

    @Override
    public boolean isRunning() {
        return this.nedt.isRunning();
    }

    @Override
    public final boolean invokeStop(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, true);
    }

    @Override
    public final boolean invoke(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean invokeImpl(boolean bl, Runnable runnable, boolean bl2) {
        Object object;
        Throwable throwable = null;
        TaskBase taskBase = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            Object object3 = this.edtLock;
            synchronized (object3) {
                if (this.nedt.shouldStop) {
                    if (DEBUG) {
                        System.err.println(Thread.currentThread() + ": Warning: SWT-EDT about (1) to stop, won't enqueue new task: " + this.nedt + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop);
                        Thread.dumpStack();
                    }
                    return false;
                }
                if (this.swtDisplay.isDisposed()) {
                    bl2 = true;
                }
                if (this.isCurrentThreadEDT()) {
                    if (null != runnable) {
                        runnable.run();
                    }
                    bl = false;
                    if (bl2) {
                        this.nedt.shouldStop = true;
                    }
                } else {
                    if (!this.nedt.isRunning && !this.swtDisplay.isDisposed()) {
                        if (null != runnable) {
                            if (bl2) {
                                System.err.println(Thread.currentThread() + ": Warning: SWT-EDT is about (3) to stop and stopped already, dropping task. NEDT " + this.nedt);
                            } else {
                                System.err.println(Thread.currentThread() + ": Warning: SWT-EDT is not running, dropping task. NEDT " + this.nedt);
                            }
                            if (DEBUG) {
                                Thread.dumpStack();
                            }
                        }
                        return false;
                    }
                    if (bl2) {
                        if (this.nedt.isRunning) {
                            if (DEBUG) {
                                System.err.println(Thread.currentThread() + ": SWT-EDT signal STOP (on edt: " + this.isCurrentThreadEDT() + ") - " + this.nedt + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop);
                            }
                            Object object4 = this.nedt.sync;
                            synchronized (object4) {
                                this.nedt.shouldStop = true;
                                this.nedt.sync.notifyAll();
                            }
                        }
                        if (this.swtDisplay.isDisposed()) {
                            System.err.println(Thread.currentThread() + ": Warning: SWT-EDT is about (3) to stop and stopped already, dropping task. " + this.nedt);
                            if (DEBUG) {
                                Thread.dumpStack();
                            }
                            return false;
                        }
                    }
                    if (null != runnable) {
                        taskBase = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
                        this.swtDisplay.asyncExec((Runnable)taskBase);
                    }
                }
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = taskBase.getThrowable();
                }
                if (null != throwable) {
                    if (throwable instanceof NativeWindowException) {
                        throw (NativeWindowException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilIdle() {
        NEDT nEDT;
        Object object = this.edtLock;
        synchronized (object) {
            nEDT = this.nedt;
        }
        object = Thread.currentThread();
        if (!nEDT.isRunning || nEDT == object || this.swtDisplay.isDisposed() || this.swtDisplay.getThread() == object) {
            return false;
        }
        try {
            this.swtDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            boolean bl;
            Thread thread = Thread.currentThread();
            Thread thread2 = !this.swtDisplay.isDisposed() ? this.swtDisplay.getThread() : null;
            boolean bl2 = bl = thread2 == thread;
            if (this.nedt.isRunning && this.nedt != thread && !bl) {
                while (this.nedt.isRunning) {
                    try {
                        this.edtLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }
    }

    class NEDT
    extends Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        Object sync;

        public NEDT(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.sync = new Object();
        }

        public final boolean isRunning() {
            return this.isRunning && !this.shouldStop;
        }

        @Override
        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object;
            if (DEBUG) {
                System.err.println(this.getName() + ": SWT-EDT run() START " + this.getName());
            }
            RuntimeException runtimeException = null;
            try {
                do {
                    if (!this.shouldStop) {
                        if (!SWTEDTUtil.this.swtDisplay.isDisposed()) {
                            SWTEDTUtil.this.swtDisplay.syncExec(SWTEDTUtil.this.dispatchMessages);
                        } else {
                            SWTEDTUtil.this.dispatchMessages.run();
                        }
                    }
                    object = this.sync;
                    synchronized (object) {
                        if (!this.shouldStop) {
                            try {
                                this.sync.wait(pollPeriod);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                } while (!this.shouldStop);
            }
            catch (Throwable throwable) {
                this.shouldStop = true;
                if (throwable instanceof RuntimeException) {
                    runtimeException = (RuntimeException)throwable;
                }
                runtimeException = new RuntimeException("Within SWT-EDT", throwable);
            }
            finally {
                if (DEBUG) {
                    System.err.println(this.getName() + ": SWT-EDT run() END " + this.getName() + ", " + runtimeException);
                }
                object = SWTEDTUtil.this.edtLock;
                synchronized (object) {
                    this.isRunning = false;
                    SWTEDTUtil.this.edtLock.notifyAll();
                }
                if (DEBUG) {
                    System.err.println(this.getName() + ": SWT-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                }
                if (null != runtimeException) {
                    throw runtimeException;
                }
            }
        }
    }
}

