/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Rectangle;
import javax.media.nativewindow.util.SurfaceSize;
import jogamp.newt.MonitorDeviceImpl;
import jogamp.newt.ScreenImpl;

public class MonitorModeProps {
    public static final int NUM_RESOLUTION_PROPERTIES = 2;
    public static final int NUM_SURFACE_SIZE_PROPERTIES = 1;
    public static final int NUM_SIZEANDRATE_PROPERTIES = 2;
    public static final int NUM_MONITOR_MODE_PROPERTIES = 2;
    public static final int NUM_MONITOR_MODE_PROPERTIES_ALL = 8;
    public static final int IDX_MONITOR_MODE_BPP = 3;
    public static final int IDX_MONITOR_MODE_ROT = 7;
    public static final int MIN_MONITOR_DEVICE_PROPERTIES = 15;
    public static final int IDX_MONITOR_DEVICE_VIEWPORT = 4;

    private static DimensionImmutable streamInResolution(int[] nArray, int n) {
        Dimension dimension = new Dimension(nArray[n++], nArray[n++]);
        return dimension;
    }

    private static SurfaceSize streamInSurfaceSize(DimensionImmutable dimensionImmutable, int[] nArray, int n) {
        return new SurfaceSize(dimensionImmutable, nArray[n]);
    }

    private static MonitorMode.SizeAndRRate streamInSizeAndRRate(SurfaceSize surfaceSize, int[] nArray, int n) {
        float f = (float)nArray[n++] / 100.0f;
        int n2 = nArray[n++];
        return new MonitorMode.SizeAndRRate(surfaceSize, f, n2);
    }

    private static MonitorMode streamInMonitorMode0(MonitorMode.SizeAndRRate sizeAndRRate, int[] nArray, int n) {
        int n2 = nArray[n++];
        int n3 = nArray[n++];
        return new MonitorMode(n2, sizeAndRRate, n3);
    }

    public static MonitorMode streamInMonitorMode(int[] nArray, Cache cache, int[] nArray2, int n) {
        int n2 = nArray2[n];
        if (8 != n2) {
            throw new RuntimeException("property count should be 8, but is " + n2 + ", len " + (nArray2.length - n));
        }
        if (8 > nArray2.length - n) {
            throw new RuntimeException("properties array too short, should be >= 8, is " + (nArray2.length - n));
        }
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInResolution(nArray2, ++n);
        n += 2;
        if (null != cache) {
            dimensionImmutable = cache.resolutions.getOrAdd(dimensionImmutable);
        }
        SurfaceSize surfaceSize = MonitorModeProps.streamInSurfaceSize(dimensionImmutable, nArray2, n);
        ++n;
        if (null != cache) {
            surfaceSize = cache.surfaceSizes.getOrAdd(surfaceSize);
        }
        MonitorMode.SizeAndRRate sizeAndRRate = MonitorModeProps.streamInSizeAndRRate(surfaceSize, nArray2, n);
        n += 2;
        if (null != cache) {
            sizeAndRRate = cache.sizeAndRates.getOrAdd(sizeAndRRate);
        }
        MonitorMode monitorMode = MonitorModeProps.streamInMonitorMode0(sizeAndRRate, nArray2, n);
        if (null != cache) {
            monitorMode = cache.monitorModes.getOrAdd(monitorMode);
        }
        if (null != nArray && null != cache) {
            int n3 = cache.monitorModes.indexOf(monitorMode);
            if (0 > n3) {
                throw new InternalError("Invalid index of current unified mode " + monitorMode);
            }
            nArray[0] = n3;
        }
        return monitorMode;
    }

    public static int[] streamOutMonitorMode(MonitorMode monitorMode) {
        int[] nArray = new int[8];
        int n = 0;
        nArray[n++] = 8;
        nArray[n++] = monitorMode.getSurfaceSize().getResolution().getWidth();
        nArray[n++] = monitorMode.getSurfaceSize().getResolution().getHeight();
        nArray[n++] = monitorMode.getSurfaceSize().getBitsPerPixel();
        nArray[n++] = (int)(monitorMode.getRefreshRate() * 100.0f);
        nArray[n++] = monitorMode.getFlags();
        nArray[n++] = monitorMode.getId();
        nArray[n++] = monitorMode.getRotation();
        if (8 != n) {
            throw new InternalError("wrong number of attributes: got " + n + " != should " + 8);
        }
        return nArray;
    }

    public static MonitorDevice streamInMonitorDevice(int[] nArray, Cache cache, ScreenImpl screenImpl, int[] nArray2, int n) {
        int n2;
        int n3 = nArray2[n];
        if (15 > n3) {
            throw new RuntimeException("property count should be >= 15, but is " + n3 + ", len " + (nArray2.length - n));
        }
        if (15 > nArray2.length - n) {
            throw new RuntimeException("properties array too short (min), should be >= 15, is " + (nArray2.length - n));
        }
        if (n3 > nArray2.length - n) {
            throw new RuntimeException("properties array too short (count), should be >= " + n3 + ", is " + (nArray2.length - n));
        }
        int n4 = n + n3;
        ArrayList<MonitorMode> arrayList = cache.monitorModes.getData();
        int n5 = ++n;
        int n6 = nArray2[n5];
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInResolution(nArray2, ++n);
        n += 2;
        Rectangle rectangle = new Rectangle(nArray2[n++], nArray2[n++], nArray2[n++], nArray2[n++]);
        Rectangle rectangle2 = new Rectangle(nArray2[n++], nArray2[n++], nArray2[n++], nArray2[n++]);
        int n7 = nArray2[n++];
        int n8 = nArray2[n++];
        MonitorMode monitorMode = MonitorModeProps.getByNativeIdAndRotation(arrayList, n7, n8);
        ArrayHashSet<MonitorMode> arrayHashSet = new ArrayHashSet<MonitorMode>();
        while (n < n4) {
            n8 = nArray2[n++];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                MonitorMode monitorMode2 = (MonitorMode)arrayList.get(n2);
                if (monitorMode2.getId() != n8) continue;
                arrayHashSet.add(monitorMode2);
            }
        }
        MonitorDevice monitorDevice = new MonitorDeviceImpl(screenImpl, n6, dimensionImmutable, rectangle, rectangle2, monitorMode, arrayHashSet);
        if (null != cache) {
            monitorDevice = cache.monitorDevices.getOrAdd(monitorDevice);
        }
        if (null != nArray) {
            n2 = cache.monitorDevices.indexOf(monitorDevice);
            if (0 > n2) {
                throw new InternalError("Invalid index of current unified mode " + monitorDevice);
            }
            nArray[0] = n2;
        }
        return monitorDevice;
    }

    private static MonitorMode getByNativeIdAndRotation(List<MonitorMode> list, int n, int n2) {
        if (null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                if (monitorMode.getId() != n || monitorMode.getRotation() != n2) continue;
                return monitorMode;
            }
        }
        return null;
    }

    public static MonitorDevice streamInMonitorDevice(int[] nArray, Cache cache, ScreenImpl screenImpl, ArrayHashSet<MonitorMode> arrayHashSet, MonitorMode monitorMode, int[] nArray2, int n) {
        int n2 = nArray2[n];
        if (12 != n2) {
            throw new RuntimeException("property count should be == 12, but is " + n2 + ", len " + (nArray2.length - n));
        }
        if (12 > nArray2.length - n) {
            throw new RuntimeException("properties array too short (min), should be >= 12, is " + (nArray2.length - n));
        }
        if (n2 > nArray2.length - n) {
            throw new RuntimeException("properties array too short (count), should be >= " + n2 + ", is " + (nArray2.length - n));
        }
        int n3 = ++n;
        int n4 = nArray2[n3];
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInResolution(nArray2, ++n);
        n += 2;
        Rectangle rectangle = new Rectangle(nArray2[n++], nArray2[n++], nArray2[n++], nArray2[n++]);
        Rectangle rectangle2 = new Rectangle(nArray2[n++], nArray2[n++], nArray2[n++], nArray2[n++]);
        MonitorDevice monitorDevice = new MonitorDeviceImpl(screenImpl, n4, dimensionImmutable, rectangle, rectangle2, monitorMode, arrayHashSet);
        if (null != cache) {
            monitorDevice = cache.monitorDevices.getOrAdd(monitorDevice);
        }
        if (null != nArray) {
            int n5 = cache.monitorDevices.indexOf(monitorDevice);
            if (0 > n5) {
                throw new InternalError("Invalid index of current unified mode " + monitorDevice);
            }
            nArray[0] = n5;
        }
        return monitorDevice;
    }

    public static int[] streamOutMonitorDevice(MonitorDevice monitorDevice) {
        int n = monitorDevice.getSupportedModes().size();
        if (0 == n) {
            throw new RuntimeException("no supported modes: " + monitorDevice);
        }
        int[] nArray = new int[15 + n - 1];
        int n2 = 0;
        nArray[n2++] = nArray.length;
        nArray[n2++] = monitorDevice.getId();
        nArray[n2++] = monitorDevice.getSizeMM().getWidth();
        nArray[n2++] = monitorDevice.getSizeMM().getHeight();
        nArray[n2++] = monitorDevice.getViewport().getX();
        nArray[n2++] = monitorDevice.getViewport().getY();
        nArray[n2++] = monitorDevice.getViewport().getWidth();
        nArray[n2++] = monitorDevice.getViewport().getHeight();
        nArray[n2++] = monitorDevice.getViewportInWindowUnits().getX();
        nArray[n2++] = monitorDevice.getViewportInWindowUnits().getY();
        nArray[n2++] = monitorDevice.getViewportInWindowUnits().getWidth();
        nArray[n2++] = monitorDevice.getViewportInWindowUnits().getHeight();
        nArray[n2++] = monitorDevice.getCurrentMode().getId();
        nArray[n2++] = monitorDevice.getCurrentMode().getRotation();
        List<MonitorMode> list = monitorDevice.getSupportedModes();
        for (int i = 0; i < list.size(); ++i) {
            nArray[n2++] = list.get(i).getId();
        }
        if (nArray.length != n2) {
            throw new InternalError("wrong number of attributes: got " + n2 + " != should " + nArray.length);
        }
        return nArray;
    }

    public final void swapRotatePair(int n, int[] nArray, int n2, int n3) {
        if (0 == n || 180 == n) {
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n2];
            nArray[n2] = nArray[n2 + 1];
            nArray[n2 + 1] = n5;
            ++n4;
            n2 += 2;
        }
    }

    public static class Cache {
        public final ArrayHashSet<DimensionImmutable> resolutions = new ArrayHashSet();
        public final ArrayHashSet<SurfaceSize> surfaceSizes = new ArrayHashSet();
        public final ArrayHashSet<MonitorMode.SizeAndRRate> sizeAndRates = new ArrayHashSet();
        public final ArrayHashSet<MonitorMode> monitorModes = new ArrayHashSet();
        public final ArrayHashSet<MonitorDevice> monitorDevices = new ArrayHashSet();
    }
}

