/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.math.FloatUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLException;

public class GLUniformData {
    private String name;
    private int location;
    private int rows;
    private int columns;
    private int count;
    private Object data;
    private boolean isMatrix;

    public GLUniformData(String string, int n) {
        this.initScalar(string, 1, n);
    }

    public GLUniformData(String string, float f) {
        this.initScalar(string, 1, Float.valueOf(f));
    }

    public GLUniformData(String string, int n, IntBuffer intBuffer) {
        this.initBuffer(string, n, intBuffer);
    }

    public GLUniformData(String string, int n, FloatBuffer floatBuffer) {
        this.initBuffer(string, n, floatBuffer);
    }

    private GLUniformData(int n, String string) {
        this.initBuffer(string, n, null);
    }

    public static GLUniformData creatEmptyVector(String string, int n) {
        return new GLUniformData(n, string);
    }

    public static GLUniformData creatEmptyMatrix(String string, int n, int n2) {
        return new GLUniformData(string, n, n2, null);
    }

    public GLUniformData(String string, int n, int n2, FloatBuffer floatBuffer) {
        this.initBuffer(string, n, n2, floatBuffer);
    }

    public GLUniformData setData(int n) {
        this.initScalar(n);
        return this;
    }

    public GLUniformData setData(float f) {
        this.initScalar(Float.valueOf(f));
        return this;
    }

    public GLUniformData setData(IntBuffer intBuffer) {
        this.initBuffer(intBuffer);
        return this;
    }

    public GLUniformData setData(FloatBuffer floatBuffer) {
        this.initBuffer(floatBuffer);
        return this;
    }

    public int intValue() {
        return (Integer)this.data;
    }

    public float floatValue() {
        return ((Float)this.data).floatValue();
    }

    public IntBuffer intBufferValue() {
        return (IntBuffer)this.data;
    }

    public FloatBuffer floatBufferValue() {
        return (FloatBuffer)this.data;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("GLUniformData[name ").append(this.name).append(", location ").append(this.location).append(", size ").append(this.rows).append("x").append(this.columns).append(", count ").append(this.count).append(", data ");
        if (this.isMatrix() && this.data instanceof FloatBuffer) {
            stringBuilder.append("\n");
            FloatBuffer floatBuffer = (FloatBuffer)this.getBuffer();
            for (int i = 0; i < this.count; ++i) {
                FloatUtil.matrixToString(stringBuilder, i + ": ", "%10.5f", floatBuffer, i * this.rows * this.columns, this.rows, this.columns, false);
                stringBuilder.append(",\n");
            }
        } else if (this.isBuffer()) {
            Buffers.toString(stringBuilder, null, this.getBuffer());
        } else {
            stringBuilder.append(this.data);
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    private void initBuffer(String string, int n, int n2, Buffer buffer) {
        if (2 > n || n > 4 || 2 > n2 || n2 > 4) {
            throw new GLException("rowsXcolumns must be within [2..4]X[2..4], is: " + n + "X" + n2);
        }
        this.name = string;
        this.rows = n;
        this.columns = n2;
        this.isMatrix = true;
        this.location = -1;
        this.initBuffer(buffer);
    }

    private void initScalar(String string, int n, Object object) {
        if (1 > n || n > 4) {
            throw new GLException("components must be within [1..4], is: " + n);
        }
        this.name = string;
        this.columns = n;
        this.rows = 1;
        this.isMatrix = false;
        this.location = -1;
        this.initScalar(object);
    }

    private void initBuffer(String string, int n, Buffer buffer) {
        if (1 > n || n > 4) {
            throw new GLException("components must be within [1..4], is: " + n);
        }
        this.name = string;
        this.columns = n;
        this.rows = 1;
        this.isMatrix = false;
        this.location = -1;
        this.initBuffer(buffer);
    }

    private void initScalar(Object object) {
        if (object instanceof Buffer) {
            this.initBuffer((Buffer)object);
        } else if (null != object) {
            if (this.isMatrix) {
                throw new GLException("Atom type not allowed for matrix : " + this);
            }
            this.count = 1;
            this.data = object;
        } else {
            this.count = 0;
            this.data = object;
        }
    }

    private void initBuffer(Buffer buffer) {
        if (null != buffer) {
            int n = this.rows * this.columns;
            if (buffer.remaining() < n || 0 != buffer.remaining() % n) {
                throw new GLException("remaining data buffer size invalid: buffer: " + buffer.toString() + "\n\t" + this);
            }
            this.count = buffer.remaining() / n;
            this.data = buffer;
        } else {
            this.count = 0;
            this.data = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getLocation() {
        return this.location;
    }

    public int setLocation(int n) {
        this.location = n;
        return n;
    }

    public int setLocation(GL2ES2 gL2ES2, int n) {
        this.location = gL2ES2.glGetUniformLocation(n, this.name);
        return this.location;
    }

    public Object getObject() {
        return this.data;
    }

    public Buffer getBuffer() {
        return this.data instanceof Buffer ? (Buffer)this.data : null;
    }

    public boolean isBuffer() {
        return this.data instanceof Buffer;
    }

    public boolean isMatrix() {
        return this.isMatrix;
    }

    public int count() {
        return this.count;
    }

    public int components() {
        return this.rows * this.columns;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }
}

