/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi.awt;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.awt.ImageUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.spi.TextureWriter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class IIOTextureWriter
implements TextureWriter {
    @Override
    public boolean write(File file, TextureData textureData) throws IOException {
        int n = textureData.getPixelFormat();
        int n2 = textureData.getPixelType();
        if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
            byte by;
            int n3;
            BufferedImage bufferedImage = new BufferedImage(textureData.getWidth(), textureData.getHeight(), n == 6407 ? 5 : 6);
            byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            ByteBuffer byteBuffer = (ByteBuffer)textureData.getBuffer();
            if (byteBuffer == null) {
                byteBuffer = (ByteBuffer)textureData.getMipmapData()[0];
            }
            byteBuffer.rewind();
            byteBuffer.get(byArray);
            byteBuffer.rewind();
            if (n == 6407) {
                for (n3 = 0; n3 < byArray.length; n3 += 3) {
                    byte by2;
                    by = byArray[n3 + 0];
                    byArray[n3 + 0] = by2 = byArray[n3 + 2];
                    byArray[n3 + 2] = by;
                }
            } else {
                for (n3 = 0; n3 < byArray.length; n3 += 4) {
                    byte by3;
                    by = byArray[n3 + 0];
                    byte by4 = byArray[n3 + 1];
                    byte by5 = byArray[n3 + 2];
                    byArray[n3 + 0] = by3 = byArray[n3 + 3];
                    byArray[n3 + 1] = by5;
                    byArray[n3 + 2] = by4;
                    byArray[n3 + 3] = by;
                }
            }
            ImageUtil.flipImageVertically(bufferedImage);
            if ("jpg".equals(IOUtil.getFileSuffix(file)) && bufferedImage.getType() == 6) {
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
                Graphics graphics = bufferedImage2.getGraphics();
                graphics.drawImage(bufferedImage, 0, 0, null);
                graphics.dispose();
                bufferedImage = bufferedImage2;
            }
            return ImageIO.write((RenderedImage)bufferedImage, IOUtil.getFileSuffix(file), file);
        }
        throw new IOException("ImageIO writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
    }
}

