// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// Provides support for writing compressed output to file using zlib
// (http://www.zlib.net/).
// A given instance of an ZlibOutputBuffer is NOT safe for concurrent use
// by multiple threads
@Namespace("tensorflow::io") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class ZlibOutputBuffer extends WritableFile {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ZlibOutputBuffer(Pointer p) { super(p); }

  // Create an ZlibOutputBuffer for `file` with two buffers that cache the
  // 1. input data to be deflated
  // 2. the deflated output
  // with sizes `input_buffer_bytes` and `output_buffer_bytes` respectively.
  // Does not take ownership of `file`.
  // output_buffer_bytes should be greater than 1.
  public ZlibOutputBuffer(
        WritableFile file,
        int input_buffer_bytes,
        int output_buffer_bytes,
        @Const @ByRef ZlibCompressionOptions zlib_options) { super((Pointer)null); allocate(file, input_buffer_bytes, output_buffer_bytes, zlib_options); }
  private native void allocate(
        WritableFile file,
        int input_buffer_bytes,
        int output_buffer_bytes,
        @Const @ByRef ZlibCompressionOptions zlib_options);

  // Initializes some state necessary for the output buffer. This call is
  // required before any other operation on the buffer.
  public native @ByVal Status Init();

  // Adds `data` to the compression pipeline.
  //
  // The input data is buffered in `z_stream_input_` and is compressed in bulk
  // when the buffer gets full. The compressed output is not immediately
  // written to file but rather buffered in `z_stream_output_` and gets written
  // to file when the buffer is full.
  //
  // To immediately write contents to file call `Flush()`.
  public native @ByVal Status Append(@StringPiece BytePointer data);
  public native @ByVal Status Append(@StringPiece String data);

// #if defined(PLATFORM_GOOGLE)
// #endif

  // Deflates any cached input and writes all output to file.
  public native @ByVal Status Flush();

  // Compresses any cached input and writes all output to file. This must be
  // called before the destructor to avoid any data loss.
  //
  // Contrary to `Flush()` this informs zlib that it should not expect any
  // further input by using Z_FINISH flush mode. Also cleans up z_stream.
  //
  // After calling this, any further calls to `Write()`, `Flush()` or `Close()`
  // will fail.
  public native @ByVal Status Close();

  // Returns the name of the underlying file.
  public native @ByVal Status Name(@StringPiece @Cast({"char*", "StringPiece*"}) BytePointer result);

  // Deflates any cached input, writes all output to file and syncs it.
  public native @ByVal Status Sync();

  // Returns the write position in the underlying file. The position does not
  // reflect buffered, un-flushed data.
  public native @ByVal Status Tell(@Cast("tensorflow::int64*") LongPointer _position);
  public native @ByVal Status Tell(@Cast("tensorflow::int64*") LongBuffer _position);
  public native @ByVal Status Tell(@Cast("tensorflow::int64*") long... _position);
}
