// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Computes the sum along segments of a tensor.
 * 
 *  Read
 *  [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
 *  for an explanation of segments.
 * 
 *  Computes a tensor such that
 *  \(output[i] = \sum_{j...} data[j...]\) where the sum is over tuples {@code j...} such
 *  that {@code segment_ids[j...] == i}.  Unlike {@code SegmentSum}, {@code segment_ids}
 *  need not be sorted and need not cover all values in the full
 *  range of valid values.
 * 
 *  If the sum is empty for a given segment ID {@code i}, {@code output[i] = 0}.
 *  If the given segment ID {@code i} is negative, the value is dropped and will not be
 *  added to the sum of the segment.
 * 
 *  {@code num_segments} should equal the number of distinct segment IDs.
 * 
 *  <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
 *  <img style="width:100%" src="https://www.tensorflow.org/images/UnsortedSegmentSum.png" alt>
 *  </div>
 * 
 *  <pre>{@code python
 *  c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
 *  tf.unsorted_segment_sum(c, tf.constant([0, 1, 0]), num_segments=2)
 *  # ==> [[ 5,  5, 5, 5],
 *  #       [5,  6, 7, 8]]
 *  }</pre>
 * 
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * segment_ids: A tensor whose shape is a prefix of {@code data.shape}.
 * 
 *  Returns:
 *  * {@code Output}: Has same shape as data, except for the first {@code segment_ids.rank}
 *  dimensions, which are replaced with a single dimension which has size
 *  {@code num_segments}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class UnsortedSegmentSum extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public UnsortedSegmentSum(Pointer p) { super(p); }

  public UnsortedSegmentSum(@Const @ByRef Scope scope, @ByVal Input data,
                     @ByVal Input segment_ids, @ByVal Input num_segments) { super((Pointer)null); allocate(scope, data, segment_ids, num_segments); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input data,
                     @ByVal Input segment_ids, @ByVal Input num_segments);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native UnsortedSegmentSum operation(Operation setter);
  public native @ByRef Output output(); public native UnsortedSegmentSum output(Output setter);
}
