// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Transcode the input text from a source encoding to a destination encoding.
 * 
 *  The input is a string tensor of any shape. The output is a string tensor of
 *  the same shape containing the transcoded strings. Output strings are always
 *  valid unicode. If the input contains invalid encoding positions, the
 *  {@code errors} attribute sets the policy for how to deal with them. If the default
 *  error-handling policy is used, invalid formatting will be substituted in the
 *  output by the {@code replacement_char}. If the errors policy is to {@code ignore}, any
 *  invalid encoding positions in the input are skipped and not included in the
 *  output. If it set to {@code strict} then any invalid formatting will result in an
 *  InvalidArgument error.
 * 
 *  This operation can be used with {@code output_encoding = input_encoding} to enforce
 *  correct formatting for inputs even if they are already in the desired encoding.
 * 
 *  If the input is prefixed by a Byte Order Mark needed to determine encoding
 *  (e.g. if the encoding is UTF-16 and the BOM indicates big-endian), then that
 *  BOM will be consumed and not emitted into the output. If the input encoding
 *  is marked with an explicit endianness (e.g. UTF-16-BE), then the BOM is
 *  interpreted as a non-breaking-space and is preserved in the output (including
 *  always for UTF-8).
 * 
 *  The end result is that if the input is marked as an explicit endianness the
 *  transcoding is faithful to all codepoints in the source. If it is not marked
 *  with an explicit endianness, the BOM is not considered part of the string itself
 *  but as metadata, and so is not preserved in the output.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: The text to be processed. Can have any shape.
 *  * input_encoding: Text encoding of the input strings. This is any of the encodings supported
 *  by ICU ucnv algorithmic converters. Examples: {@code "UTF-16", "US ASCII", "UTF-8"}.
 *  * output_encoding: The unicode encoding to use in the output. Must be one of
 *  {@code "UTF-8", "UTF-16-BE", "UTF-32-BE"}. Multi-byte encodings will be big-endian.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * errors: Error handling policy when there is invalid formatting found in the input.
 *  The value of 'strict' will cause the operation to produce a InvalidArgument
 *  error on any invalid input formatting. A value of 'replace' (the default) will
 *  cause the operation to replace any invalid formatting in the input with the
 *  {@code replacement_char} codepoint. A value of 'ignore' will cause the operation to
 *  skip any invalid formatting in the input and produce no corresponding output
 *  character.
 *  * replacement_char: The replacement character codepoint to be used in place of any invalid
 *  formatting in the input when {@code errors='replace'}. Any valid unicode codepoint may
 *  be used. The default value is the default unicode replacement character is
 *  0xFFFD or U+65533.)
 * 
 *  Note that for UTF-8, passing a replacement character expressible in 1 byte, such
 *  as ' ', will preserve string alignment to the source since invalid bytes will be
 *  replaced with a 1-byte replacement. For UTF-16-BE and UTF-16-LE, any 1 or 2 byte
 *  replacement character will preserve byte alignment to the source.
 *  * replace_control_characters: Whether to replace the C0 control characters (00-1F) with the
 *  {@code replacement_char}. Default is false.
 * 
 *  Returns:
 *  * {@code Output}: A string tensor containing unicode text encoded using {@code output_encoding}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class UnicodeTranscode extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public UnicodeTranscode(Pointer p) { super(p); }

  /** Optional attribute setters for UnicodeTranscode */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Error handling policy when there is invalid formatting found in the input.
     *  The value of 'strict' will cause the operation to produce a InvalidArgument
     *  error on any invalid input formatting. A value of 'replace' (the default) will
     *  cause the operation to replace any invalid formatting in the input with the
     *  {@code replacement_char} codepoint. A value of 'ignore' will cause the operation to
     *  skip any invalid formatting in the input and produce no corresponding output
     *  character.
     * 
     *  Defaults to "replace" */
    
    ///
    ///
    public native @ByVal Attrs Errors(@StringPiece BytePointer x);
    public native @ByVal Attrs Errors(@StringPiece String x);

    /** The replacement character codepoint to be used in place of any invalid
     *  formatting in the input when {@code errors='replace'}. Any valid unicode codepoint may
     *  be used. The default value is the default unicode replacement character is
     *  0xFFFD or U+65533.)
     * 
     *  Note that for UTF-8, passing a replacement character expressible in 1 byte, such
     *  as ' ', will preserve string alignment to the source since invalid bytes will be
     *  replaced with a 1-byte replacement. For UTF-16-BE and UTF-16-LE, any 1 or 2 byte
     *  replacement character will preserve byte alignment to the source.
     * 
     *  Defaults to 65533 */
    
    ///
    public native @ByVal Attrs ReplacementChar(@Cast("tensorflow::int64") long x);

    /** Whether to replace the C0 control characters (00-1F) with the
     *  {@code replacement_char}. Default is false.
     * 
     *  Defaults to false */
    public native @ByVal Attrs ReplaceControlCharacters(@Cast("bool") boolean x);

    public native @StringPiece BytePointer errors_(); public native Attrs errors_(BytePointer setter);
    public native @Cast("tensorflow::int64") long replacement_char_(); public native Attrs replacement_char_(long setter);
    public native @Cast("bool") boolean replace_control_characters_(); public native Attrs replace_control_characters_(boolean setter);
  }
  public UnicodeTranscode(@Const @ByRef Scope scope, @ByVal Input input,
                   @StringPiece BytePointer input_encoding, @StringPiece BytePointer output_encoding) { super((Pointer)null); allocate(scope, input, input_encoding, output_encoding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @StringPiece BytePointer input_encoding, @StringPiece BytePointer output_encoding);
  public UnicodeTranscode(@Const @ByRef Scope scope, @ByVal Input input,
                   @StringPiece String input_encoding, @StringPiece String output_encoding) { super((Pointer)null); allocate(scope, input, input_encoding, output_encoding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @StringPiece String input_encoding, @StringPiece String output_encoding);
  public UnicodeTranscode(@Const @ByRef Scope scope, @ByVal Input input,
                   @StringPiece BytePointer input_encoding, @StringPiece BytePointer output_encoding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, input_encoding, output_encoding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @StringPiece BytePointer input_encoding, @StringPiece BytePointer output_encoding, @Const @ByRef Attrs attrs);
  public UnicodeTranscode(@Const @ByRef Scope scope, @ByVal Input input,
                   @StringPiece String input_encoding, @StringPiece String output_encoding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, input_encoding, output_encoding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @StringPiece String input_encoding, @StringPiece String output_encoding, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Errors(@StringPiece BytePointer x);
  public static native @ByVal Attrs Errors(@StringPiece String x);
  public static native @ByVal Attrs ReplacementChar(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs ReplaceControlCharacters(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native UnicodeTranscode operation(Operation setter);
  public native @ByRef Output output(); public native UnicodeTranscode output(Output setter);
}
