// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// Holds a tensor or tensor reference. For tensor references, we need
// a mutex to prevent concurrent access to the tensor.
@Namespace("tensorflow") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class TensorValue extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TensorValue(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TensorValue(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public TensorValue position(long position) {
        return (TensorValue)super.position(position);
    }
    @Override public TensorValue getPointer(long i) {
        return new TensorValue((Pointer)this).offsetAddress(i);
    }

  public TensorValue() { super((Pointer)null); allocate(); }
  private native void allocate();
  public TensorValue(Tensor t) { super((Pointer)null); allocate(t); }
  private native void allocate(Tensor t);
  public TensorValue(@Cast("tensorflow::mutex*") Pointer mu, Tensor t) { super((Pointer)null); allocate(mu, t); }
  private native void allocate(@Cast("tensorflow::mutex*") Pointer mu, Tensor t);
  public native @Name("operator ->") Tensor access();
  public native @Cast("bool") boolean is_ref();

  // Return the dtype of the Tensor. For references, return the underlying type.
  public native @Cast("tensorflow::DataType") int dtype();

  // Return the dtype of the Tensor. For references, return the underlying type.
  // This variation on the dtype() acquires the lock for references.
  //
  // TODO(b/133843385): Disallow dtype modifications
  public native @Cast("tensorflow::DataType") int dtype_safe();

  public native @Cast("tensorflow::mutex*") Pointer mutex_if_ref(); public native TensorValue mutex_if_ref(Pointer setter);  // nullptr if not a ref, != nullptr if a ref
  public native Tensor tensor(); public native TensorValue tensor(Tensor setter);
}
