// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Represents the shape of a Tensor.
 * 
 *  A tensor's shape is denoted by its number of dimensions and a size for each
 *  dimension.  For example, a Tensor represented by a 3 x 4 matrix would have
 *  a shape of 2-D, [3,4].
 * 
 *  If you know the exact shape of your Tensor when you create the TensorShape
 *  object, you can specify it then, or you can create a TensorShape with
 *  zero dimensions and one element, and call AddDim() to add dimensions later. */
@Namespace("tensorflow") @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class TensorShape extends TensorShapeBase {
    static { Loader.load(); }

  
    public TensorShape(@Cast("tensorflow::int64*") @ArraySlice LongPointer dim_sizes) { super((Pointer)null); allocate(dim_sizes); }
    private native void allocate(@Cast("tensorflow::int64*") @ArraySlice LongPointer dim_sizes);
    public TensorShape(@Cast("tensorflow::int64*") @ArraySlice LongBuffer dim_sizes) { super((Pointer)null); allocate(dim_sizes); }
    private native void allocate(@Cast("tensorflow::int64*") @ArraySlice LongBuffer dim_sizes);
    public TensorShape(@Cast("tensorflow::int64*") @ArraySlice long... dim_sizes) { super((Pointer)null); allocate(dim_sizes); }
    private native void allocate(@Cast("tensorflow::int64*") @ArraySlice long... dim_sizes);
    public TensorShape() { super((Pointer)null); allocate(); }
    private native void allocate();
  
    public TensorShape(@Const @ByRef TensorShapeProto proto) { super((Pointer)null); allocate(proto); }
    private native void allocate(@Const @ByRef TensorShapeProto proto);
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TensorShape(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TensorShape(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public TensorShape position(long position) {
        return (TensorShape)super.position(position);
    }
    @Override public TensorShape getPointer(long i) {
        return new TensorShape((Pointer)this).offsetAddress(i);
    }


  /** Allow a TensorShape to be used as a PartialTensorShape without copying */
  public native @Const @ByRef @Name("operator const tensorflow::PartialTensorShape&") PartialTensorShape asPartialTensorShape();  // NOLINT(runtime/explicit)

  /** Returns true if {@code *this} and {@code b} have the same sizes. Ignores
   *  dimension names. */
  public native @Cast("bool") boolean IsSameSize(@Const @ByRef TensorShape b);
  public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef TensorShape b);
  public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef TensorShape b);

  /** Fill {@code *dsizes} from {@code *this}.
   *  Notice: Using IndexType=int32 in combination with To32Bit() can
   *  significantly improve performance on GPU. */

  /** Same as {@code AsEigenDSizes()} but allows for {@code NDIMS > dims()} -- in
   *  which case we pad the rest of the sizes with 1.
   *  Notice: Using IndexType=int32 in combination with To32Bit() can
   *  significantly improve performance on GPU. */
  // These CHECK fail to ease debugging.
  // REQUIRES: dims() == NDIMS
}
