// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;
  // namespace batch_util

/** \ingroup core
 <p>
 *  Interface to access the raw ref-counted data buffer. */
@Namespace("tensorflow") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class TensorBuffer extends Pointer {
    static { Loader.load(); }

  public TensorBuffer(Pointer data_ptr) { super((Pointer)null); allocate(data_ptr); }
  private native void allocate(Pointer data_ptr);

  /** \brief data() points to a memory region of size() bytes.
   * 
   *  NOTE(mrry): The {@code data()} method is not virtual for performance reasons.
   *  It can be called multiple times when the contents of a {@code Tensor} are
   *  accessed, and so making it non-virtual allows the body to be inlined. */
  public native Pointer data();

  /** \brief Size (in bytes) of the buffer. */
  @Virtual(true) public native @Cast("size_t") @Const({false, false, true}) long size();

  /** \brief If this TensorBuffer is sub-buffer of another TensorBuffer,
   *  returns that TensorBuffer. Otherwise, returns this. */
  @Virtual(true) public native TensorBuffer root_buffer();

  /** \brief Fills metadata about the allocation into the proto. */
  @Virtual(true) public native @Const({false, false, true}) void FillAllocationDescription(
        AllocationDescription proto);

  /** \brief Helper method to reinterpret the buffer as an array of {@code T}. */

  /** \brief Whether this TensorBuffer owns the underlying memory. */
  @Virtual public native @Cast("bool") @Const({false, false, true}) boolean OwnsMemory();
}
