// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// Graphs which utilize Collective Ops in a common instance must
// execute with identical step_ids even if they are disjoint graphs
// run by otherwise independent tasks.  This interface supplies
// coordinated step_ids to use in such cases.
@Namespace("tensorflow") @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class StepSequenceInterface extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StepSequenceInterface(Pointer p) { super(p); }


  // Used with a distributed implementation to coordinate step_id
  // sequences across tasks.
  public native void GetStepSequenceAsync(@Const GetStepSequenceRequest request,
                                      GetStepSequenceResponse response,
                                      @Cast("const tensorflow::StatusCallback*") @ByRef Pointer done);

  // Refresh the local per-graph_key step_id sequence from collective
  // group leader, if applicable.
  public native void RefreshStepIdSequenceAsync(@Cast("tensorflow::int64") long graph_key,
                                            @Cast("const tensorflow::StatusCallback*") @ByRef Pointer done);

  // Returns the step_id that should be used for initiating a new execution
  // on the specified graph. May return the same step_id multiple times if
  // RetireStepId or RefreshStepIdReservation is not called.
  public native @Cast("tensorflow::int64") long NextStepId(@Cast("tensorflow::int64") long graph_key);

  // Reports that execution of the given step has completed successfully.
  // Should be called immediately after a step completes with OK status,
  // prior to calling NextStepId().  If the step fails, don't call.
  public native void RetireStepId(@Cast("tensorflow::int64") long graph_key, @Cast("tensorflow::int64") long step_id);
}
