// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// Helper class to manage multiple child status values.
@Namespace("tensorflow") @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class StatusGroup extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public StatusGroup() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public StatusGroup(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StatusGroup(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public StatusGroup position(long position) {
        return (StatusGroup)super.position(position);
    }
    @Override public StatusGroup getPointer(long i) {
        return new StatusGroup((Pointer)this).offsetAddress(i);
    }

  // Utility function to mark a Status as derived. By marking derived status,
  // Derived status messages are ignored when reporting errors to end users.
  public static native @ByVal Status MakeDerived(@Const @ByRef Status s);
  public static native @Cast("bool") boolean IsDerived(@Const @ByRef Status s);

  // Enable warning and error log collection for appending to the aggregated
  // status. This function may be called more than once.
  public static native void ConfigureLogHistory();

  // Return a merged status with combined child status messages with a summary.
  public native @ByVal Status as_summary_status();
  // Return a merged status with combined child status messages with
  // concatenation.
  public native @ByVal Status as_concatenated_status();

  public native @Cast("bool") boolean ok();

  // Augment this group with the child status `status`.
  public native void Update(@Const @ByRef Status status);

  // Attach recent warning and error log messages
  public native void AttachLogMessages();
  public native @Cast("bool") boolean HasLogMessages();
}
