// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Generates sparse cross from a list of sparse and dense tensors.
 * 
 *  The op takes two lists, one of 2D {@code SparseTensor} and one of 2D {@code Tensor}, each
 *  representing features of one feature column. It outputs a 2D {@code SparseTensor} with
 *  the batchwise crosses of these features.
 * 
 *  For example, if the inputs are
 * 
 *      inputs[0]: SparseTensor with shape = [2, 2]
 *      [0, 0]: "a"
 *      [1, 0]: "b"
 *      [1, 1]: "c"
 * 
 *      inputs[1]: SparseTensor with shape = [2, 1]
 *      [0, 0]: "d"
 *      [1, 0]: "e"
 * 
 *      inputs[2]: Tensor [["f"], ["g"]]
 * 
 *  then the output will be
 * 
 *      shape = [2, 2]
 *      [0, 0]: "a_X_d_X_f"
 *      [1, 0]: "b_X_e_X_g"
 *      [1, 1]: "c_X_e_X_g"
 * 
 *  if hashed_output=true then the output will be
 * 
 *      shape = [2, 2]
 *      [0, 0]: FingerprintCat64(
 *                  Fingerprint64("f"), FingerprintCat64(
 *                      Fingerprint64("d"), Fingerprint64("a")))
 *      [1, 0]: FingerprintCat64(
 *                  Fingerprint64("g"), FingerprintCat64(
 *                      Fingerprint64("e"), Fingerprint64("b")))
 *      [1, 1]: FingerprintCat64(
 *                  Fingerprint64("g"), FingerprintCat64(
 *                      Fingerprint64("e"), Fingerprint64("c")))
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * indices: 2-D.  Indices of each input {@code SparseTensor}.
 *  * values: 1-D.   values of each {@code SparseTensor}.
 *  * shapes: 1-D.   Shapes of each {@code SparseTensor}.
 *  * dense_inputs: 2-D.    Columns represented by dense {@code Tensor}.
 *  * hashed_output: If true, returns the hash of the cross instead of the string.
 *  This will allow us avoiding string manipulations.
 *  * num_buckets: It is used if hashed_output is true.
 *  output = hashed_value%num_buckets if num_buckets > 0 else hashed_value.
 *  * hash_key: Specify the hash_key that will be used by the {@code FingerprintCat64}
 *  function to combine the crosses fingerprints.
 * 
 *  Returns:
 *  * {@code Output} output_indices: 2-D.  Indices of the concatenated {@code SparseTensor}.
 *  * {@code Output} output_values: 1-D.  Non-empty values of the concatenated or hashed
 *  {@code SparseTensor}.
 *  * {@code Output} output_shape: 1-D.  Shape of the concatenated {@code SparseTensor}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SparseCross extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseCross(Pointer p) { super(p); }

  public SparseCross(@Const @ByRef Scope scope, @ByVal InputList indices,
              @ByVal InputList values, @ByVal InputList shapes,
              @ByVal InputList dense_inputs, @Cast("bool") boolean hashed_output, @Cast("tensorflow::int64") long num_buckets, @Cast("tensorflow::int64") long hash_key, @Cast("tensorflow::DataType") int out_type, @Cast("tensorflow::DataType") int internal_type) { super((Pointer)null); allocate(scope, indices, values, shapes, dense_inputs, hashed_output, num_buckets, hash_key, out_type, internal_type); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal InputList indices,
              @ByVal InputList values, @ByVal InputList shapes,
              @ByVal InputList dense_inputs, @Cast("bool") boolean hashed_output, @Cast("tensorflow::int64") long num_buckets, @Cast("tensorflow::int64") long hash_key, @Cast("tensorflow::DataType") int out_type, @Cast("tensorflow::DataType") int internal_type);

  public native @ByRef Operation operation(); public native SparseCross operation(Operation setter);
  public native @ByRef Output output_indices(); public native SparseCross output_indices(Output setter);
  public native @ByRef Output output_values(); public native SparseCross output_values(Output setter);
  public native @ByRef Output output_shape(); public native SparseCross output_shape(Output setter);
}
