// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Concatenates a list of {@code SparseTensor} along the specified dimension.
 * 
 *  Concatenation is with respect to the dense versions of these sparse tensors.
 *  It is assumed that each input is a {@code SparseTensor} whose elements are ordered
 *  along increasing dimension number.
 * 
 *  All inputs' shapes must match, except for the concat dimension.  The
 *  {@code indices}, {@code values}, and {@code shapes} lists must have the same length.
 * 
 *  The output shape is identical to the inputs', except along the concat
 *  dimension, where it is the sum of the inputs' sizes along that dimension.
 * 
 *  The output elements will be resorted to preserve the sort order along
 *  increasing dimension number.
 * 
 *  This op runs in {@code O(M log M)} time, where {@code M} is the total number of non-empty
 *  values across all inputs. This is due to the need for an internal sort in
 *  order to concatenate efficiently across an arbitrary dimension.
 * 
 *  For example, if {@code concat_dim = 1} and the inputs are
 * 
 *      sp_inputs[0]: shape = [2, 3]
 *      [0, 2]: "a"
 *      [1, 0]: "b"
 *      [1, 1]: "c"
 * 
 *      sp_inputs[1]: shape = [2, 4]
 *      [0, 1]: "d"
 *      [0, 2]: "e"
 * 
 *  then the output will be
 * 
 *      shape = [2, 7]
 *      [0, 2]: "a"
 *      [0, 4]: "d"
 *      [0, 5]: "e"
 *      [1, 0]: "b"
 *      [1, 1]: "c"
 * 
 *  Graphically this is equivalent to doing
 * 
 *      [    a] concat [  d e  ] = [    a   d e  ]
 *      [b c  ]        [       ]   [b c          ]
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * indices: 2-D.  Indices of each input {@code SparseTensor}.
 *  * values: 1-D.  Non-empty values of each {@code SparseTensor}.
 *  * shapes: 1-D.  Shapes of each {@code SparseTensor}.
 *  * concat_dim: Dimension to concatenate along. Must be in range [-rank, rank),
 *  where rank is the number of dimensions in each input {@code SparseTensor}.
 * 
 *  Returns:
 *  * {@code Output} output_indices: 2-D.  Indices of the concatenated {@code SparseTensor}.
 *  * {@code Output} output_values: 1-D.  Non-empty values of the concatenated {@code SparseTensor}.
 *  * {@code Output} output_shape: 1-D.  Shape of the concatenated {@code SparseTensor}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SparseConcat extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseConcat(Pointer p) { super(p); }

  public SparseConcat(@Const @ByRef Scope scope, @ByVal InputList indices,
               @ByVal InputList values, @ByVal InputList shapes,
               @Cast("tensorflow::int64") long concat_dim) { super((Pointer)null); allocate(scope, indices, values, shapes, concat_dim); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal InputList indices,
               @ByVal InputList values, @ByVal InputList shapes,
               @Cast("tensorflow::int64") long concat_dim);

  public native @ByRef Operation operation(); public native SparseConcat operation(Operation setter);
  public native @ByRef Output output_indices(); public native SparseConcat output_indices(Output setter);
  public native @ByRef Output output_values(); public native SparseConcat output_values(Output setter);
  public native @ByRef Output output_shape(); public native SparseConcat output_shape(Output setter);
}
