// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Adds two {@code SparseTensor} objects to produce another {@code SparseTensor}.
 * 
 *  The input {@code SparseTensor} objects' indices are assumed ordered in standard
 *  lexicographic order.  If this is not the case, before this step run
 *  {@code SparseReorder} to restore index ordering.
 * 
 *  By default, if two values sum to zero at some index, the output {@code SparseTensor}
 *  would still include that particular location in its index, storing a zero in the
 *  corresponding value slot.  To override this, callers can specify {@code thresh},
 *  indicating that if the sum has a magnitude strictly smaller than {@code thresh}, its
 *  corresponding value and index would then not be included.  In particular,
 *  {@code thresh == 0} (default) means everything is kept and actual thresholding happens
 *  only for a positive value.
 * 
 *  In the following shapes, {@code nnz} is the count after taking {@code thresh} into account.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * a_indices: 2-D.  The {@code indices} of the first {@code SparseTensor}, size {@code [nnz, ndims]} Matrix.
 *  * a_values: 1-D.  The {@code values} of the first {@code SparseTensor}, size {@code [nnz]} Vector.
 *  * a_shape: 1-D.  The {@code shape} of the first {@code SparseTensor}, size {@code [ndims]} Vector.
 *  * b_indices: 2-D.  The {@code indices} of the second {@code SparseTensor}, size {@code [nnz, ndims]} Matrix.
 *  * b_values: 1-D.  The {@code values} of the second {@code SparseTensor}, size {@code [nnz]} Vector.
 *  * b_shape: 1-D.  The {@code shape} of the second {@code SparseTensor}, size {@code [ndims]} Vector.
 *  * thresh: 0-D.  The magnitude threshold that determines if an output value/index
 *  pair takes space.
 * 
 *  Returns:
 *  * {@code Output} sum_indices
 *  * {@code Output} sum_values
 *  * {@code Output} sum_shape */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SparseAdd extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseAdd(Pointer p) { super(p); }

  public SparseAdd(@Const @ByRef Scope scope, @ByVal Input a_indices,
            @ByVal Input a_values, @ByVal Input a_shape,
            @ByVal Input b_indices, @ByVal Input b_values,
            @ByVal Input b_shape, @ByVal Input thresh) { super((Pointer)null); allocate(scope, a_indices, a_values, a_shape, b_indices, b_values, b_shape, thresh); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input a_indices,
            @ByVal Input a_values, @ByVal Input a_shape,
            @ByVal Input b_indices, @ByVal Input b_values,
            @ByVal Input b_shape, @ByVal Input thresh);

  public native @ByRef Operation operation(); public native SparseAdd operation(Operation setter);
  public native @ByRef Output sum_indices(); public native SparseAdd sum_indices(Output setter);
  public native @ByRef Output sum_values(); public native SparseAdd sum_values(Output setter);
  public native @ByRef Output sum_shape(); public native SparseAdd sum_shape(Output setter);
}
