// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** \defgroup manip_ops Manip Ops
 *  \{
 <p>
 *  Rolls the elements of a tensor along an axis.
 * 
 *  The elements are shifted positively (towards larger indices) by the offset of
 *  {@code shift} along the dimension of {@code axis}. Negative {@code shift} values will shift
 *  elements in the opposite direction. Elements that roll passed the last position
 *  will wrap around to the first and vice versa. Multiple shifts along multiple
 *  axes may be specified.
 * 
 *  For example:
 * 
 *  <pre>{@code
 *  # 't' is [0, 1, 2, 3, 4]
 *  roll(t, shift=2, axis=0) ==> [3, 4, 0, 1, 2]
 * 
 *  # shifting along multiple dimensions
 *  # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
 *  roll(t, shift=[1, -2], axis=[0, 1]) ==> [[7, 8, 9, 5, 6], [2, 3, 4, 0, 1]]
 * 
 *  # shifting along the same axis multiple times
 *  # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
 *  roll(t, shift=[2, -3], axis=[1, 1]) ==> [[1, 2, 3, 4, 0], [6, 7, 8, 9, 5]]
 *  }</pre>
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * shift: Dimension must be 0-D or 1-D. {@code shift[i]} specifies the number of places by which
 *  elements are shifted positively (towards larger indices) along the dimension
 *  specified by {@code axis[i]}. Negative shifts will roll the elements in the opposite
 *  direction.
 *  * axis: Dimension must be 0-D or 1-D. {@code axis[i]} specifies the dimension that the shift
 *  {@code shift[i]} should occur. If the same axis is referenced more than once, the
 *  total shift for that axis will be the sum of all the shifts that belong to that
 *  axis.
 * 
 *  Returns:
 *  * {@code Output}: Has the same shape and size as the input. The elements are shifted
 *  positively (towards larger indices) by the offsets of {@code shift} along the
 *  dimensions of {@code axis}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Roll extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Roll(Pointer p) { super(p); }

  public Roll(@Const @ByRef Scope scope, @ByVal Input input,
       @ByVal Input shift, @ByVal Input axis) { super((Pointer)null); allocate(scope, input, shift, axis); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
       @ByVal Input shift, @ByVal Input axis);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native Roll operation(Operation setter);
  public native @ByRef Output output(); public native Roll output(Output setter);
}
