// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Quantizes then dequantizes a tensor.
 * 
 *  This is almost identical to QuantizeAndDequantizeV2, except that num_bits is a
 *  tensor, so its value can change during training.
 * 
 *  Arguments:
 *  * scope: A Scope object
 * 
 *  Returns:
 *  * {@code Output}: The output tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class QuantizeAndDequantizeV3 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public QuantizeAndDequantizeV3(Pointer p) { super(p); }

  /** Optional attribute setters for QuantizeAndDequantizeV3 */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Defaults to true */
    public native @ByVal Attrs SignedInput(@Cast("bool") boolean x);

    /** Defaults to true */
    public native @ByVal Attrs RangeGiven(@Cast("bool") boolean x);

    /** Defaults to false */
    public native @ByVal Attrs NarrowRange(@Cast("bool") boolean x);

    public native @Cast("bool") boolean signed_input_(); public native Attrs signed_input_(boolean setter);
    public native @Cast("bool") boolean range_given_(); public native Attrs range_given_(boolean setter);
    public native @Cast("bool") boolean narrow_range_(); public native Attrs narrow_range_(boolean setter);
  }
  public QuantizeAndDequantizeV3(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input input_min,
                          @ByVal Input input_max, @ByVal Input num_bits) { super((Pointer)null); allocate(scope, input, input_min, input_max, num_bits); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input input_min,
                          @ByVal Input input_max, @ByVal Input num_bits);
  public QuantizeAndDequantizeV3(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input input_min,
                          @ByVal Input input_max, @ByVal Input num_bits, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, input_min, input_max, num_bits, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input input_min,
                          @ByVal Input input_max, @ByVal Input num_bits, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs SignedInput(@Cast("bool") boolean x);
  public static native @ByVal Attrs RangeGiven(@Cast("bool") boolean x);
  public static native @ByVal Attrs NarrowRange(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native QuantizeAndDequantizeV3 operation(Operation setter);
  public native @ByRef Output output(); public native QuantizeAndDequantizeV3 output(Output setter);
}
