// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Returns the next representable value of {@code x1} in the direction of {@code x2}, element-wise.
 * 
 *  This operation returns the same result as the C++ std::nextafter function.
 * 
 *  It can also return a subnormal number.
 * 
 *  \compatibility(cpp)
 *  Equivalent to C++ std::nextafter function.
 *  \end_compatibility
 * 
 *  Arguments:
 *  * scope: A Scope object
 * 
 *  Returns:
 *  * {@code Output}: The output tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class NextAfter extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NextAfter(Pointer p) { super(p); }

  public NextAfter(@Const @ByRef Scope scope, @ByVal Input x1,
            @ByVal Input x2) { super((Pointer)null); allocate(scope, x1, x2); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input x1,
            @ByVal Input x2);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native NextAfter operation(Operation setter);
  public native @ByRef Output output(); public native NextAfter output(Output setter);
}
