// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Transforms a spectrogram into a form that's useful for speech recognition.
 * 
 *  Mel Frequency Cepstral Coefficients are a way of representing audio data that's
 *  been effective as an input feature for machine learning. They are created by
 *  taking the spectrum of a spectrogram (a 'cepstrum'), and discarding some of the
 *  higher frequencies that are less significant to the human ear. They have a long
 *  history in the speech recognition world, and https://en.wikipedia.org/wiki/Mel-frequency_cepstrum
 *  is a good resource to learn more.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * spectrogram: Typically produced by the Spectrogram op, with magnitude_squared
 *  set to true.
 *  * sample_rate: How many samples per second the source audio used.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * upper_frequency_limit: The highest frequency to use when calculating the
 *  ceptstrum.
 *  * lower_frequency_limit: The lowest frequency to use when calculating the
 *  ceptstrum.
 *  * filterbank_channel_count: Resolution of the Mel bank used internally.
 *  * dct_coefficient_count: How many output channels to produce per time slice.
 * 
 *  Returns:
 *  * {@code Output}: The output tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Mfcc extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Mfcc(Pointer p) { super(p); }

  /** Optional attribute setters for Mfcc */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** The highest frequency to use when calculating the
     *  ceptstrum.
     * 
     *  Defaults to 4000 */
    
    ///
    public native @ByVal Attrs UpperFrequencyLimit(float x);

    /** The lowest frequency to use when calculating the
     *  ceptstrum.
     * 
     *  Defaults to 20 */
    
    ///
    public native @ByVal Attrs LowerFrequencyLimit(float x);

    /** Resolution of the Mel bank used internally.
     * 
     *  Defaults to 40 */
    
    ///
    public native @ByVal Attrs FilterbankChannelCount(@Cast("tensorflow::int64") long x);

    /** How many output channels to produce per time slice.
     * 
     *  Defaults to 13 */
    public native @ByVal Attrs DctCoefficientCount(@Cast("tensorflow::int64") long x);

    public native float upper_frequency_limit_(); public native Attrs upper_frequency_limit_(float setter);
    public native float lower_frequency_limit_(); public native Attrs lower_frequency_limit_(float setter);
    public native @Cast("tensorflow::int64") long filterbank_channel_count_(); public native Attrs filterbank_channel_count_(long setter);
    public native @Cast("tensorflow::int64") long dct_coefficient_count_(); public native Attrs dct_coefficient_count_(long setter);
  }
  public Mfcc(@Const @ByRef Scope scope, @ByVal Input spectrogram,
       @ByVal Input sample_rate) { super((Pointer)null); allocate(scope, spectrogram, sample_rate); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input spectrogram,
       @ByVal Input sample_rate);
  public Mfcc(@Const @ByRef Scope scope, @ByVal Input spectrogram,
       @ByVal Input sample_rate, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, spectrogram, sample_rate, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input spectrogram,
       @ByVal Input sample_rate, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs UpperFrequencyLimit(float x);
  public static native @ByVal Attrs LowerFrequencyLimit(float x);
  public static native @ByVal Attrs FilterbankChannelCount(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs DctCoefficientCount(@Cast("tensorflow::int64") long x);

  public native @ByRef Operation operation(); public native Mfcc operation(Operation setter);
  public native @ByRef Output output(); public native Mfcc output(Output setter);
}
