// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Returns a batched diagonal tensor with given batched diagonal values.
 * 
 *  Returns a tensor with the contents in {@code diagonal} as {@code k[0]}-th to {@code k[1]}-th
 *  diagonals of a matrix, with everything else padded with {@code padding}. {@code num_rows}
 *  and {@code num_cols} specify the dimension of the innermost matrix of the output. If
 *  both are not specified, the op assumes the innermost matrix is square and infers
 *  its size from {@code k} and the innermost dimension of {@code diagonal}. If only one of them
 *  is specified, the op assumes the unspecified value is the smallest possible
 *  based on other criteria.
 * 
 *  Let {@code diagonal} have {@code r} dimensions {@code [I, J, ..., L, M, N]}. The output tensor has
 *  rank {@code r+1} with shape {@code [I, J, ..., L, M, num_rows, num_cols]} when only one
 *  diagonal is given ({@code k} is an integer or {@code k[0] == k[1]}). Otherwise, it has rank
 *  {@code r} with shape {@code [I, J, ..., L, num_rows, num_cols]}.
 * 
 *  The second innermost dimension of {@code diagonal} has double meaning.
 *  When {@code k} is scalar or {@code k[0] == k[1]}, {@code M} is part of the batch size
 *  [I, J, ..., M], and the output tensor is:
 * 
 *  <pre>{@code
 *  output[i, j, ..., l, m, n]
 *    = diagonal[i, j, ..., l, n-max(d_upper, 0)] ; if n - m == d_upper
 *      output[i, j, ..., l, m, n]                ; otherwise
 *  }</pre>
 * 
 *  Otherwise, {@code M} is treated as the number of diagonals for the matrix in the
 *  same batch ({@code M = k[1]-k[0]+1}), and the output tensor is:
 * 
 *  <pre>{@code
 *  output[i, j, ..., l, m, n]
 *    = diagonal[i, j, ..., l, k[1]-d, n-max(d, 0)] ; if d_lower <= d <= d_upper
 *      input[i, j, ..., l, m, n]                   ; otherwise
 *  }</pre>
 *  where {@code d = n - m}
 * 
 *  For example:
 * 
 *  <pre>{@code
 *  # The main diagonal.
 *  diagonal = np.array([[1, 2, 3, 4],            # Input shape: (2, 4)
 *                       [5, 6, 7, 8]])
 *  tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0],  # Output shape: (2, 4, 4)
 *                                 [0, 2, 0, 0],
 *                                 [0, 0, 3, 0],
 *                                 [0, 0, 0, 4]],
 *                                [[5, 0, 0, 0],
 *                                 [0, 6, 0, 0],
 *                                 [0, 0, 7, 0],
 *                                 [0, 0, 0, 8]]]
 * 
 *  # A superdiagonal (per batch).
 *  diagonal = np.array([[1, 2, 3],  # Input shape: (2, 3)
 *                       [4, 5, 6]])
 *  tf.matrix_diag(diagonal, k = 1)
 *    ==> [[[0, 1, 0, 0],  # Output shape: (2, 4, 4)
 *          [0, 0, 2, 0],
 *          [0, 0, 0, 3],
 *          [0, 0, 0, 0]],
 *         [[0, 4, 0, 0],
 *          [0, 0, 5, 0],
 *          [0, 0, 0, 6],
 *          [0, 0, 0, 0]]]
 * 
 *  # A band of diagonals.
 *  diagonals = np.array([[[1, 2, 3],  # Input shape: (2, 2, 3)
 *                         [4, 5, 0]],
 *                        [[6, 7, 9],
 *                         [9, 1, 0]]])
 *  tf.matrix_diag(diagonals, k = (-1, 0))
 *    ==> [[[1, 0, 0],  # Output shape: (2, 3, 3)
 *          [4, 2, 0],
 *          [0, 5, 3]],
 *         [[6, 0, 0],
 *          [9, 7, 0],
 *          [0, 1, 9]]]
 * 
 *  # Rectangular matrix.
 *  diagonal = np.array([1, 2])  # Input shape: (2)
 *  tf.matrix_diag(diagonal, k = -1, num_rows = 3, num_cols = 4)
 *    ==> [[0, 0, 0, 0],  # Output shape: (3, 4)
 *         [1, 0, 0, 0],
 *         [0, 2, 0, 0]]
 * 
 *  # Rectangular matrix with inferred num_cols and padding = 9.
 *  tf.matrix_diag(diagonal, k = -1, num_rows = 3, padding = 9)
 *    ==> [[9, 9],  # Output shape: (3, 2)
 *         [1, 9],
 *         [9, 2]]
 *  }</pre>
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * diagonal: Rank {@code r}, where {@code r >= 1}
 *  * k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
 *  diagonal, and negative value means subdiagonals. {@code k} can be a single integer
 *  (for a single diagonal) or a pair of integers specifying the low and high ends
 *  of a matrix band. {@code k[0]} must not be larger than {@code k[1]}.
 *  * num_rows: The number of rows of the output matrix. If it is not provided, the op assumes
 *  the output matrix is a square matrix and infers the matrix size from k and the
 *  innermost dimension of {@code diagonal}.
 *  * num_cols: The number of columns of the output matrix. If it is not provided, the op
 *  assumes the output matrix is a square matrix and infers the matrix size from
 *  k and the innermost dimension of {@code diagonal}.
 *  * padding_value: The number to fill the area outside the specified diagonal band with.
 *  Default is 0.
 * 
 *  Returns:
 *  * {@code Output}: Has rank {@code r+1} when {@code k} is an integer or {@code k[0] == k[1]}, rank {@code r} otherwise. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class MatrixDiagV2 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MatrixDiagV2(Pointer p) { super(p); }

  public MatrixDiagV2(@Const @ByRef Scope scope, @ByVal Input diagonal,
               @ByVal Input k, @ByVal Input num_rows,
               @ByVal Input num_cols, @ByVal Input padding_value) { super((Pointer)null); allocate(scope, diagonal, k, num_rows, num_cols, padding_value); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input diagonal,
               @ByVal Input k, @ByVal Input num_rows,
               @ByVal Input num_cols, @ByVal Input padding_value);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native MatrixDiagV2 operation(Operation setter);
  public native @ByRef Output output(); public native MatrixDiagV2 output(Output setter);
}
