// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Returns the batched diagonal part of a batched tensor.
 * 
 *  Returns a tensor with the {@code k[0]}-th to {@code k[1]}-th diagonals of the batched
 *  {@code input}.
 * 
 *  Assume {@code input} has {@code r} dimensions {@code [I, J, ..., L, M, N]}.
 *  Let {@code max_diag_len} be the maximum length among all diagonals to be extracted,
 *  {@code max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))}
 *  Let {@code num_diags} be the number of diagonals to extract,
 *  {@code num_diags = k[1] - k[0] + 1}.
 * 
 *  If {@code num_diags == 1}, the output tensor is of rank {@code r - 1} with shape
 *  {@code [I, J, ..., L, max_diag_len]} and values:
 * 
 *  <pre>{@code
 *  diagonal[i, j, ..., l, n]
 *    = input[i, j, ..., l, n+y, n+x] ; when 0 <= n-y < M and 0 <= n-x < N,
 *      0                             ; otherwise.
 *  }</pre>
 *  where {@code y = max(-k[1], 0)}, {@code x = max(k[1], 0)}.
 * 
 *  Otherwise, the output tensor has rank {@code r} with dimensions
 *  {@code [I, J, ..., L, num_diags, max_diag_len]} with values:
 * 
 *  <pre>{@code
 *  diagonal[i, j, ..., l, m, n]
 *    = input[i, j, ..., l, n+y, n+x] ; when 0 <= n-y < M and 0 <= n-x < N,
 *      0                             ; otherwise.
 *  }</pre>
 *  where {@code d = k[1] - m}, {@code y = max(-d, 0)}, and {@code x = max(d, 0)}.
 * 
 *  The input must be at least a matrix.
 * 
 *  For example:
 * 
 *  <pre>{@code
 *  input = np.array([[[1, 2, 3, 4],  # Input shape: (2, 3, 4)
 *                     [5, 6, 7, 8],
 *                     [9, 8, 7, 6]],
 *                    [[5, 4, 3, 2],
 *                     [1, 2, 3, 4],
 *                     [5, 6, 7, 8]]])
 * 
 *  # A main diagonal from each batch.
 *  tf.matrix_diag_part(input) ==> [[1, 6, 7],  # Output shape: (2, 3)
 *                                  [5, 2, 7]]
 * 
 *  # A superdiagonal from each batch.
 *  tf.matrix_diag_part(input, k = 1)
 *    ==> [[2, 7, 6],  # Output shape: (2, 3)
 *         [4, 3, 8]]
 * 
 *  # A tridiagonal band from each batch.
 *  tf.matrix_diag_part(input, k = (-1, 1))
 *    ==> [[[2, 7, 6],  # Output shape: (2, 3, 3)
 *          [1, 6, 7],
 *          [5, 8, 0]],
 *         [[4, 3, 8],
 *          [5, 2, 7],
 *          [1, 6, 0]]]
 * 
 *  # Padding = 9
 *  tf.matrix_diag_part(input, k = (1, 3), padding = 9)
 *    ==> [[[4, 9, 9],  # Output shape: (2, 3, 3)
 *          [3, 8, 9],
 *          [2, 7, 6]],
 *         [[2, 9, 9],
 *          [3, 4, 9],
 *          [4, 3, 8]]]
 *  }</pre>
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: Rank {@code r} tensor where {@code r >= 2}.
 *  * k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
 *  diagonal, and negative value means subdiagonals. {@code k} can be a single integer
 *  (for a single diagonal) or a pair of integers specifying the low and high ends
 *  of a matrix band. {@code k[0]} must not be larger than {@code k[1]}.
 *  * padding_value: The value to fill the area outside the specified diagonal band with.
 *  Default is 0.
 * 
 *  Returns:
 *  * {@code Output}: The extracted diagonal(s). */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class MatrixDiagPartV2 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MatrixDiagPartV2(Pointer p) { super(p); }

  public MatrixDiagPartV2(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input k, @ByVal Input padding_value) { super((Pointer)null); allocate(scope, input, k, padding_value); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input k, @ByVal Input padding_value);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native MatrixDiagPartV2 operation(Operation setter);
  public native @ByRef Output diagonal(); public native MatrixDiagPartV2 diagonal(Output setter);
}
