// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Gather slices from {@code params} into a Tensor with shape specified by {@code indices}.
 * 
 *  {@code indices} is a K-dimensional integer tensor, best thought of as a
 *  (K-1)-dimensional tensor of indices into {@code params}, where each element defines a
 *  slice of {@code params}:
 * 
 *      output[\(i_0, ..., i_{K-2}\)] = params[indices[\(i_0, ..., i_{K-2}\)]]
 * 
 *  Whereas in {@code tf.gather} {@code indices} defines slices into the {@code axis}
 *  dimension of {@code params}, in {@code tf.gather_nd}, {@code indices} defines slices into the
 *  first {@code N} dimensions of {@code params}, where {@code N = indices.shape[-1]}.
 * 
 *  The last dimension of {@code indices} can be at most the rank of
 *  {@code params}:
 * 
 *      indices.shape[-1] <= params.rank
 * 
 *  The last dimension of {@code indices} corresponds to elements
 *  (if {@code indices.shape[-1] == params.rank}) or slices
 *  (if {@code indices.shape[-1] < params.rank}) along dimension {@code indices.shape[-1]}
 *  of {@code params}.  The output tensor has shape
 * 
 *      indices.shape[:-1] + params.shape[indices.shape[-1]:]
 * 
 *  Note that on CPU, if an out of bound index is found, an error is returned.
 *  On GPU, if an out of bound index is found, a 0 is stored in the
 *  corresponding output value.
 * 
 *  Some examples below.
 * 
 *  Simple indexing into a matrix:
 * 
 *  <pre>{@code python
 *      indices = [[0, 0], [1, 1]]
 *      params = [['a', 'b'], ['c', 'd']]
 *      output = ['a', 'd']
 *  }</pre>
 * 
 *  Slice indexing into a matrix:
 * 
 *  <pre>{@code python
 *      indices = [[1], [0]]
 *      params = [['a', 'b'], ['c', 'd']]
 *      output = [['c', 'd'], ['a', 'b']]
 *  }</pre>
 * 
 *  Indexing into a 3-tensor:
 * 
 *  <pre>{@code python
 *      indices = [[1]]
 *      params = [[['a0', 'b0'], ['c0', 'd0']],
 *                [['a1', 'b1'], ['c1', 'd1']]]
 *      output = [[['a1', 'b1'], ['c1', 'd1']]]
 * 
 * 
 *      indices = [[0, 1], [1, 0]]
 *      params = [[['a0', 'b0'], ['c0', 'd0']],
 *                [['a1', 'b1'], ['c1', 'd1']]]
 *      output = [['c0', 'd0'], ['a1', 'b1']]
 * 
 * 
 *      indices = [[0, 0, 1], [1, 0, 1]]
 *      params = [[['a0', 'b0'], ['c0', 'd0']],
 *                [['a1', 'b1'], ['c1', 'd1']]]
 *      output = ['b0', 'b1']
 *  }</pre>
 * 
 *  Batched indexing into a matrix:
 * 
 *  <pre>{@code python
 *      indices = [[[0, 0]], [[0, 1]]]
 *      params = [['a', 'b'], ['c', 'd']]
 *      output = [['a'], ['b']]
 *  }</pre>
 * 
 *  Batched slice indexing into a matrix:
 * 
 *  <pre>{@code python
 *      indices = [[[1]], [[0]]]
 *      params = [['a', 'b'], ['c', 'd']]
 *      output = [[['c', 'd']], [['a', 'b']]]
 *  }</pre>
 * 
 *  Batched indexing into a 3-tensor:
 * 
 *  <pre>{@code python
 *      indices = [[[1]], [[0]]]
 *      params = [[['a0', 'b0'], ['c0', 'd0']],
 *                [['a1', 'b1'], ['c1', 'd1']]]
 *      output = [[[['a1', 'b1'], ['c1', 'd1']]],
 *                [[['a0', 'b0'], ['c0', 'd0']]]]
 * 
 *      indices = [[[0, 1], [1, 0]], [[0, 0], [1, 1]]]
 *      params = [[['a0', 'b0'], ['c0', 'd0']],
 *                [['a1', 'b1'], ['c1', 'd1']]]
 *      output = [[['c0', 'd0'], ['a1', 'b1']],
 *                [['a0', 'b0'], ['c1', 'd1']]]
 * 
 * 
 *      indices = [[[0, 0, 1], [1, 0, 1]], [[0, 1, 1], [1, 1, 0]]]
 *      params = [[['a0', 'b0'], ['c0', 'd0']],
 *                [['a1', 'b1'], ['c1', 'd1']]]
 *      output = [['b0', 'b1'], ['d0', 'c1']]
 *  }</pre>
 * 
 *  See also {@code tf.gather} and {@code tf.batch_gather}.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * params: The tensor from which to gather values.
 *  * indices: Index tensor.
 * 
 *  Returns:
 *  * {@code Output}: Values from {@code params} gathered from indices given by {@code indices}, with
 *  shape {@code indices.shape[:-1] + params.shape[indices.shape[-1]:]}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class GatherNd extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GatherNd(Pointer p) { super(p); }

  public GatherNd(@Const @ByRef Scope scope, @ByVal Input params,
           @ByVal Input indices) { super((Pointer)null); allocate(scope, params, indices); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input params,
           @ByVal Input indices);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native GatherNd operation(Operation setter);
  public native @ByRef Output output(); public native GatherNd output(Output setter);
}
