// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Decode a 16-bit PCM WAV file to a float tensor.
 * 
 *  The -32768 to 32767 signed 16-bit values will be scaled to -1.0 to 1.0 in float.
 * 
 *  When desired_channels is set, if the input contains fewer channels than this
 *  then the last channel will be duplicated to give the requested number, else if
 *  the input has more channels than requested then the additional channels will be
 *  ignored.
 * 
 *  If desired_samples is set, then the audio will be cropped or padded with zeroes
 *  to the requested length.
 * 
 *  The first output contains a Tensor with the content of the audio samples. The
 *  lowest dimension will be the number of channels, and the second will be the
 *  number of samples. For example, a ten-sample-long stereo WAV file should give an
 *  output shape of [10, 2].
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * contents: The WAV-encoded audio, usually from a file.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * desired_channels: Number of sample channels wanted.
 *  * desired_samples: Length of audio requested.
 * 
 *  Returns:
 *  * {@code Output} audio: 2-D with shape {@code [length, channels]}.
 *  * {@code Output} sample_rate: Scalar holding the sample rate found in the WAV header. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class DecodeWav extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DecodeWav(Pointer p) { super(p); }

  /** Optional attribute setters for DecodeWav */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Number of sample channels wanted.
     * 
     *  Defaults to -1 */
    
    ///
    public native @ByVal Attrs DesiredChannels(@Cast("tensorflow::int64") long x);

    /** Length of audio requested.
     * 
     *  Defaults to -1 */
    public native @ByVal Attrs DesiredSamples(@Cast("tensorflow::int64") long x);

    public native @Cast("tensorflow::int64") long desired_channels_(); public native Attrs desired_channels_(long setter);
    public native @Cast("tensorflow::int64") long desired_samples_(); public native Attrs desired_samples_(long setter);
  }
  public DecodeWav(@Const @ByRef Scope scope, @ByVal Input contents) { super((Pointer)null); allocate(scope, contents); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input contents);
  public DecodeWav(@Const @ByRef Scope scope, @ByVal Input contents, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, contents, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input contents, @Const @ByRef Attrs attrs);

  public static native @ByVal Attrs DesiredChannels(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs DesiredSamples(@Cast("tensorflow::int64") long x);

  public native @ByRef Operation operation(); public native DecodeWav operation(Operation setter);
  public native @ByRef Output audio(); public native DecodeWav audio(Output setter);
  public native @ByRef Output sample_rate(); public native DecodeWav sample_rate(Output setter);
}
