// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// On construction, silently attempts to read the metadata associated with
// "prefix".  If caller intends to call any function afterwards, "status()"
// must be checked.
// All threads accessing the same BundleReader must synchronize.
@Namespace("tensorflow") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class BundleReader extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BundleReader(Pointer p) { super(p); }

  public BundleReader(Env env, @StringPiece BytePointer prefix) { super((Pointer)null); allocate(env, prefix); }
  private native void allocate(Env env, @StringPiece BytePointer prefix);
  public BundleReader(Env env, @StringPiece String prefix) { super((Pointer)null); allocate(env, prefix); }
  private native void allocate(Env env, @StringPiece String prefix);

  // Is ok() iff the reader construction is successful (completed the read of
  // the metadata).
  public native @ByVal Status status();

  // Queries whether the bundle contains an entry keyed by "key".  Calls Seek()
  // internally, so this call invalidates the reader's current position.
  // REQUIRES: status().ok()
  public native @Cast("bool") boolean Contains(@StringPiece BytePointer key);
  public native @Cast("bool") boolean Contains(@StringPiece String key);

  // Looks up the dtype and the shape of the tensor keyed by "key".
  // REQUIRES: status().ok()
  public native @ByVal Status LookupDtypeAndShape(@StringPiece BytePointer key, @Cast("tensorflow::DataType*") IntPointer dtype,
                               TensorShape shape);
  public native @ByVal Status LookupDtypeAndShape(@StringPiece String key, @Cast("tensorflow::DataType*") IntPointer dtype,
                               TensorShape shape);

  // Looks up the shape of the tensor keyed by "key".
  // Clears "shape" if not found.
  // REQUIRES: status().ok()
  public native @ByVal Status LookupTensorShape(@StringPiece BytePointer key,
                             TensorShape shape);
  public native @ByVal Status LookupTensorShape(@StringPiece String key,
                             TensorShape shape);

  // Looks up the tensor keyed by "key".  If "key" refers to a partitioned
  // tensor, attempts to look up the full contents using all stored slices.
  //
  // Caller must make sure "val" has the same shape and dtype as the
  // corresponding contents, so that its buffer can be filled without needing
  // extra allocation.  These can be queried via "LookupDtypeAndShape()".
  //
  // On error, "val" may contain nonsense data.  Returns a NotFound error if
  // tensor keyed by "key" does not exist in this bundle.
  //
  // Validates the stored crc32c checksum against the restored bytes.
  // REQUIRES: status().ok()
  public native @ByVal Status Lookup(@StringPiece BytePointer key, Tensor val);
  public native @ByVal Status Lookup(@StringPiece String key, Tensor val);

  // Looks up the tensor pointed to by the internal iterator.
  //
  // On error, "val" may contain nonsense data.
  //
  // Validates the stored crc32c checksum against the restored bytes.
  // REQUIRES: status().ok() && Valid()
  public native @ByVal Status ReadCurrent(Tensor val);

  // Looks up the slices of the tensor keyed by "key".  On OK, "slices"
  // is non-empty if and only if the tensor is a partitioned tensor.
  //
  // Warning - there is no guaranteed ordering for the returned slices, so
  // a slice with a larger start index in some dimension could come before
  // another slice with a smaller start index in the same dimension.
  // REQUIRES: status().ok()
  public native @ByVal Status LookupTensorSlices(@StringPiece BytePointer key, @StdVector TensorSlice slices);
  public native @ByVal Status LookupTensorSlices(@StringPiece String key, @StdVector TensorSlice slices);

  // Looks up a specific slice of a partitioned tensor.
  // It is only required that the stored slices cover the requested slice,
  // namely "slice_spec" is a subset of the union of the stored slices.
  // REQUIRES: status().ok()
  public native @ByVal Status LookupSlice(@StringPiece BytePointer full_tensor_key, @Const @ByRef TensorSlice slice_spec,
                       Tensor val);
  public native @ByVal Status LookupSlice(@StringPiece String full_tensor_key, @Const @ByRef TensorSlice slice_spec,
                       Tensor val);

  // Seeks to the first position in the bundle whose key is no less than "key".
  // REQUIRES: status().ok()
  public native void Seek(@StringPiece BytePointer key);
  public native void Seek(@StringPiece String key);
  // Moves to the next position in the bundle.
  // REQUIRES: status().ok()
  public native void Next();
  // Returns true iff the reader is positioned to a key/val pair.
  // REQUIRES: status().ok()
  public native @Cast("bool") boolean Valid();

  // Returns the key at the current position.
  // REQUIRES: status().ok() && Valid()
  public native @StringPiece BytePointer key();
  // Returns the raw value at the current position.
  // REQUIRES: status().ok() && Valid()
  public native @StringPiece BytePointer value();

  public native @StdString BytePointer DebugString();
}
