// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Computes the trignometric inverse sine of x element-wise.
 * 
 *  The {@code tf.math.asin} operation returns the inverse of {@code tf.math.sin}, such that
 *  if {@code y = tf.math.sin(x)} then, {@code x = tf.math.asin(y)}.
 * 
 *  **Note**: The output of {@code tf.math.asin} will lie within the invertible range
 *  of sine, i.e [-pi/2, pi/2].
 * 
 *  For example:
 * 
 *  <pre>{@code python
 *  # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
 *  x = tf.constant([1.047, 0.785])
 *  y = tf.math.sin(x) # [0.8659266, 0.7068252]
 * 
 *  tf.math.asin(y) # [1.047, 0.785] = x
 *  }</pre>
 * 
 * 
 *  Arguments:
 *  * scope: A Scope object
 * 
 *  Returns:
 *  * {@code Output}: The y tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Asin extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Asin(Pointer p) { super(p); }

  public Asin(@Const @ByRef Scope scope, @ByVal Input x) { super((Pointer)null); allocate(scope, x); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input x);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native Asin operation(Operation setter);
  public native @ByRef Output y(); public native Asin y(Output setter);
}
