// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// An implementation of Allocator that delegates all calls to another Allocator.
//
// Useful to clients who want to override part of the functionality of another
// allocator.
@Namespace("tensorflow") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class AllocatorWrapper extends Allocator {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AllocatorWrapper(Pointer p) { super(p); }

  public AllocatorWrapper(Allocator wrapped) { super((Pointer)null); allocate(wrapped); }
  private native void allocate(Allocator wrapped);

  // Returns the wrapped allocator to which all calls are delegated.
  public native Allocator wrapped();

  public native @StdString BytePointer Name();

  public native Pointer AllocateRaw(@Cast("size_t") long alignment, @Cast("size_t") long num_bytes);

  public native Pointer AllocateRaw(@Cast("size_t") long alignment, @Cast("size_t") long num_bytes,
                      @Const @ByRef AllocationAttributes allocation_attr);

  public native void DeallocateRaw(Pointer ptr);

  public native @Cast("bool") boolean TracksAllocationSizes();

  public native @Cast("bool") boolean AllocatesOpaqueHandle();

  public native @Cast("size_t") long RequestedSize(@Const Pointer ptr);

  public native @Cast("size_t") long AllocatedSize(@Const Pointer ptr);

  public native @Cast("tensorflow::int64") long AllocationId(@Const Pointer ptr);

  public native @Cast("size_t") long AllocatedSizeSlow(@Const Pointer ptr);
}
