/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.BoolPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<std::array<bool,2> >"})
@Properties(inherit={torch.class})
public class Bool2Vector
extends Pointer {
    public Bool2Vector(Pointer p) {
        super(p);
    }

    public Bool2Vector(BoolPointer value) {
        this(1L);
        this.put(0L, value);
    }

    public Bool2Vector(BoolPointer ... array) {
        this(array.length);
        this.put(array);
    }

    public Bool2Vector() {
        this.allocate();
    }

    public Bool2Vector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Bool2Vector put(@ByRef Bool2Vector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @Cast(value={"std::array<bool,2>*"})
    @ByRef
    public native BoolPointer get(@Cast(value={"size_t"}) long var1);

    public native Bool2Vector put(@Cast(value={"size_t"}) long var1, BoolPointer var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"std::array<bool,2>*"}) @ByRef BoolPointer var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public BoolPointer[] get() {
        BoolPointer[] array = new BoolPointer[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public BoolPointer pop_back() {
        long size = this.size();
        BoolPointer value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public Bool2Vector push_back(BoolPointer value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public Bool2Vector put(BoolPointer value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public Bool2Vector put(BoolPointer ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Cast(value={"std::array<bool,2>*"})
        @ByRef
        @Const
        public native BoolPointer get();
    }
}

