/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.nvcodec.presets;

import java.util.List;
import org.bytedeco.cuda.presets.cudart;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;

@Properties(inherit={cudart.class}, value={@Platform(value={"linux-arm64", "linux-ppc64le", "linux-x86_64", "windows-x86_64"}, include={"cuviddec.h", "nvcuvid.h"}, link={"nvcuvid"}), @Platform(value={"linux-arm64"}, includepath={"/usr/include/aarch64-linux-gnu/", "/usr/local/videocodecsdk/Interface/"}, linkpath={"/usr/lib/aarch64-linux-gnu/", "/usr/local/videocodecsdk/Lib/linux/stubs/aarch64/"}), @Platform(value={"linux-ppc64le"}, includepath={"/usr/include/powerpc64le-linux-gnu/", "/usr/local/videocodecsdk/Interface/"}, linkpath={"/usr/lib/powerpc64le-linux-gnu/", "/usr/local/videocodecsdk/Lib/linux/stubs/ppc64le/"}), @Platform(value={"linux-x86_64"}, includepath={"/usr/include/x86_64-linux-gnu/", "/usr/local/videocodecsdk/Interface/"}, linkpath={"/usr/lib/x86_64-linux-gnu/", "/usr/local/videocodecsdk/Lib/linux/stubs/x86_64/"}), @Platform(value={"windows-x86_64"}, includepath={"C:/Program Files/NVIDIA GPU Computing Toolkit/VideoCodecSDK/Interface/"}, linkpath={"C:/Program Files/NVIDIA GPU Computing Toolkit/VideoCodecSDK/Lib/x64/"})}, target="org.bytedeco.nvcodec.nvcuvid", global="org.bytedeco.nvcodec.global.nvcuvid")
public class nvcuvid
implements LoadEnabled,
InfoMapper {
    public void init(ClassProperties properties) {
        String[] libs;
        String platform = properties.getProperty("platform");
        List preloads = properties.get("platform.preload");
        List resources = properties.get("platform.preloadresource");
        if (!Loader.isLoadLibraries()) {
            return;
        }
        int i = 0;
        for (String lib : libs = new String[]{"cudart"}) {
            if (platform.startsWith("linux")) {
                lib = lib + (lib.equals("cudart") ? "@.11.0" : (lib.equals("nvrtc") ? "@.11.2" : "@.11"));
            } else {
                if (!platform.startsWith("windows")) continue;
                lib = lib + (lib.equals("cudart") ? "64_110" : (lib.equals("nvrtc") ? "64_112_0" : "64_11"));
            }
            if (preloads.contains(lib)) continue;
            preloads.add(i++, lib);
        }
        if (i > 0) {
            resources.add("/org/bytedeco/cuda/");
        }
    }

    public void map(InfoMap infoMap) {
        infoMap.put(new Info(new String[]{"cuviddec.h"}).linePatterns(new String[]{"#define cuvidMapVideoFrame.*", "#define cuvidUnmapVideoFrame.*"}).skip()).put(new Info(new String[]{"NV_ENC_DEPRECATED"}).cppText("#define NV_ENC_DEPRECATED deprecated").cppTypes(new String[0])).put(new Info(new String[]{"deprecated"}).annotations(new String[]{"@Deprecated"})).put(new Info(new String[]{"std::size_t"}).cast().valueTypes(new String[]{"long"}).pointerTypes(new String[]{"LongPointer", "LongBuffer", "long[]"})).put(new Info(new String[]{"const char"}).pointerTypes(new String[]{"String", "@Cast(\"const char*\") BytePointer"})).put(new Info(new String[]{"CUvideoctxlock"}).valueTypes(new String[]{"_CUcontextlock_st"}).pointerTypes(new String[]{"@ByPtrPtr _CUcontextlock_st"})).put(new Info(new String[]{"_CUVIDPICPARAMS"}).valueTypes(new String[]{"CUVIDPICPARAMS"})).put(new Info(new String[]{"defined(__CUVID_DEVPTR64)"}).define(true)).put(new Info(new String[]{"defined(__CUVID_DEVPTR64) && !defined(__CUVID_INTERNAL)"}).define(true)).put(new Info(new String[]{"!defined(__CUVID_DEVPTR64) || defined(__CUVID_INTERNAL)"}).define(false));
    }
}

