// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.nvcodec.nvencodeapi;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.nvcodec.nvcuvid.*;
import static org.bytedeco.nvcodec.global.nvcuvid.*;

import static org.bytedeco.nvcodec.global.nvencodeapi.*;


/**
 * \struct _NV_ENC_PIC_PARAMS_H264
 * H264 specific enc pic params. sent on a per frame basis.
 */ 
@Properties(inherit = org.bytedeco.nvcodec.presets.nvencodeapi.class)
public class NV_ENC_PIC_PARAMS_H264 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NV_ENC_PIC_PARAMS_H264() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NV_ENC_PIC_PARAMS_H264(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NV_ENC_PIC_PARAMS_H264(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NV_ENC_PIC_PARAMS_H264 position(long position) {
        return (NV_ENC_PIC_PARAMS_H264)super.position(position);
    }
    @Override public NV_ENC_PIC_PARAMS_H264 getPointer(long i) {
        return new NV_ENC_PIC_PARAMS_H264((Pointer)this).offsetAddress(i);
    }

    /** [in]: Specifies the display POC syntax This is required to be set if client is handling the picture type decision. */
    public native @Cast("uint32_t") int displayPOCSyntax(); public native NV_ENC_PIC_PARAMS_H264 displayPOCSyntax(int setter);
    /** [in]: Reserved and must be set to 0 */
    public native @Cast("uint32_t") int reserved3(); public native NV_ENC_PIC_PARAMS_H264 reserved3(int setter);
    /** [in]: Set to 1 for a reference picture. This is ignored if NV_ENC_INITIALIZE_PARAMS::enablePTD is set to 1. */
    public native @Cast("uint32_t") int refPicFlag(); public native NV_ENC_PIC_PARAMS_H264 refPicFlag(int setter);
    /** [in]: Specifies the colour plane ID associated with the current input. */
    public native @Cast("uint32_t") int colourPlaneId(); public native NV_ENC_PIC_PARAMS_H264 colourPlaneId(int setter);
    /** [in]: Forces an intra refresh with duration equal to intraRefreshFrameCnt. 
                                                                        When outputRecoveryPointSEI is set this is value is used for recovery_frame_cnt in recovery point SEI message 
                                                                        forceIntraRefreshWithFrameCnt cannot be used if B frames are used in the GOP structure specified */
    public native @Cast("uint32_t") int forceIntraRefreshWithFrameCnt(); public native NV_ENC_PIC_PARAMS_H264 forceIntraRefreshWithFrameCnt(int setter);
    /** [in]: Set to 1 if client wants to encode this frame with each slice completely independent of other slices in the frame. 
                                                                        NV_ENC_INITIALIZE_PARAMS::enableConstrainedEncoding should be set to 1 */
    public native @Cast("uint32_t") @NoOffset int constrainedFrame(); public native NV_ENC_PIC_PARAMS_H264 constrainedFrame(int setter);
    /** [in]: Set to 1 if client wants to change the sliceModeData field to specify new sliceSize Parameter
                                                                        When forceIntraRefreshWithFrameCnt is set it will have priority over sliceMode setting */
    public native @Cast("uint32_t") @NoOffset int sliceModeDataUpdate(); public native NV_ENC_PIC_PARAMS_H264 sliceModeDataUpdate(int setter);
    /** [in]: Set to 1 if client wants to mark this frame as LTR */
    public native @Cast("uint32_t") @NoOffset int ltrMarkFrame(); public native NV_ENC_PIC_PARAMS_H264 ltrMarkFrame(int setter);
    /** [in]: Set to 1 if client allows encoding this frame using the LTR frames specified in ltrFrameBitmap */
    public native @Cast("uint32_t") @NoOffset int ltrUseFrames(); public native NV_ENC_PIC_PARAMS_H264 ltrUseFrames(int setter);
    /** [in]: Reserved bit fields and must be set to 0 */
    public native @Cast("uint32_t") @NoOffset int reservedBitFields(); public native NV_ENC_PIC_PARAMS_H264 reservedBitFields(int setter);
    /** [in]: Deprecated. */
    public native @Cast("uint8_t*") BytePointer sliceTypeData(); public native NV_ENC_PIC_PARAMS_H264 sliceTypeData(BytePointer setter);
    /** [in]: Deprecated. */
    public native @Cast("uint32_t") int sliceTypeArrayCnt(); public native NV_ENC_PIC_PARAMS_H264 sliceTypeArrayCnt(int setter);
    /** [in]: Specifies the number of elements allocated in  seiPayloadArray array. */
    public native @Cast("uint32_t") int seiPayloadArrayCnt(); public native NV_ENC_PIC_PARAMS_H264 seiPayloadArrayCnt(int setter);
    /** [in]: Array of SEI payloads which will be inserted for this frame. */
    public native NV_ENC_SEI_PAYLOAD seiPayloadArray(); public native NV_ENC_PIC_PARAMS_H264 seiPayloadArray(NV_ENC_SEI_PAYLOAD setter);
    /** [in]: This parameter in conjunction with sliceModeData specifies the way in which the picture is divided into slices
                                                                        sliceMode = 0 MB based slices, sliceMode = 1 Byte based slices, sliceMode = 2 MB row based slices, sliceMode = 3, numSlices in Picture
                                                                        When forceIntraRefreshWithFrameCnt is set it will have priority over sliceMode setting
                                                                        When sliceMode == 0 and sliceModeData == 0 whole picture will be coded with one slice */
    public native @Cast("uint32_t") int sliceMode(); public native NV_ENC_PIC_PARAMS_H264 sliceMode(int setter);
    /** [in]: Specifies the parameter needed for sliceMode. For:
                                                                        sliceMode = 0, sliceModeData specifies # of MBs in each slice (except last slice)
                                                                        sliceMode = 1, sliceModeData specifies maximum # of bytes in each slice (except last slice)
                                                                        sliceMode = 2, sliceModeData specifies # of MB rows in each slice (except last slice)
                                                                        sliceMode = 3, sliceModeData specifies number of slices in the picture. Driver will divide picture into slices optimally */
    public native @Cast("uint32_t") int sliceModeData(); public native NV_ENC_PIC_PARAMS_H264 sliceModeData(int setter);
    /** [in]: Specifies the long term referenceframe index to use for marking this frame as LTR.*/
    public native @Cast("uint32_t") int ltrMarkFrameIdx(); public native NV_ENC_PIC_PARAMS_H264 ltrMarkFrameIdx(int setter);
    /** [in]: Specifies the associated bitmap of LTR frame indices to use when encoding this frame. */
    public native @Cast("uint32_t") int ltrUseFrameBitmap(); public native NV_ENC_PIC_PARAMS_H264 ltrUseFrameBitmap(int setter);
    /** [in]: Not supported. Reserved for future use and must be set to 0. */
    public native @Cast("uint32_t") int ltrUsageMode(); public native NV_ENC_PIC_PARAMS_H264 ltrUsageMode(int setter);
    /** [in]: Specifies the number of slices to be forced to Intra in the current picture.
                                                                        This option along with forceIntraSliceIdx[] array needs to be used with sliceMode = 3 only */
    public native @Cast("uint32_t") int forceIntraSliceCount(); public native NV_ENC_PIC_PARAMS_H264 forceIntraSliceCount(int setter);
    /** [in]: Slice indices to be forced to intra in the current picture. Each slice index should be <= num_slices_in_picture -1. Index starts from 0 for first slice.
                                                                        The number of entries in this array should be equal to forceIntraSliceCount */
    public native @Cast("uint32_t*") IntPointer forceIntraSliceIdx(); public native NV_ENC_PIC_PARAMS_H264 forceIntraSliceIdx(IntPointer setter);															
    /** [in]: Specifies the H264 extension config parameters using this config. */
    public native @ByRef NV_ENC_PIC_PARAMS_H264_EXT h264ExtPicParams(); public native NV_ENC_PIC_PARAMS_H264 h264ExtPicParams(NV_ENC_PIC_PARAMS_H264_EXT setter);
    /** [in]: Reserved and must be set to 0. */
    public native @Cast("uint32_t") int reserved(int i); public native NV_ENC_PIC_PARAMS_H264 reserved(int i, int setter);
    @MemberGetter public native @Cast("uint32_t*") IntPointer reserved();
    /** [in]: Reserved and must be set to NULL. */
    public native Pointer reserved2(int i); public native NV_ENC_PIC_PARAMS_H264 reserved2(int i, Pointer setter);
    @MemberGetter public native @Cast("void**") PointerPointer reserved2();
}
