// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.nvcodec.nvencodeapi;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.nvcodec.nvcuvid.*;
import static org.bytedeco.nvcodec.global.nvcuvid.*;

import static org.bytedeco.nvcodec.global.nvencodeapi.*;


/**
 * Motion vector structure per CU for HEVC motion estimation.
 */
@Properties(inherit = org.bytedeco.nvcodec.presets.nvencodeapi.class)
public class NV_ENC_HEVC_MV_DATA extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NV_ENC_HEVC_MV_DATA() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NV_ENC_HEVC_MV_DATA(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NV_ENC_HEVC_MV_DATA(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NV_ENC_HEVC_MV_DATA position(long position) {
        return (NV_ENC_HEVC_MV_DATA)super.position(position);
    }
    @Override public NV_ENC_HEVC_MV_DATA getPointer(long i) {
        return new NV_ENC_HEVC_MV_DATA((Pointer)this).offsetAddress(i);
    }

    /** up to 4 vectors within a CU */
    public native @ByRef NV_ENC_MVECTOR mv(int i); public native NV_ENC_HEVC_MV_DATA mv(int i, NV_ENC_MVECTOR setter);
    @MemberGetter public native NV_ENC_MVECTOR mv();
    /** 0 (I), 1(P) */
    public native @Cast("uint8_t") byte cuType(); public native NV_ENC_HEVC_MV_DATA cuType(byte setter);
    /** 0: 8x8, 1: 16x16, 2: 32x32, 3: 64x64 */
    public native @Cast("uint8_t") byte cuSize(); public native NV_ENC_HEVC_MV_DATA cuSize(byte setter);
    /** The CU partition mode
                                                    0 (2Nx2N), 1 (2NxN), 2(Nx2N), 3 (NxN),
                                                    4 (2NxnU), 5 (2NxnD), 6(nLx2N), 7 (nRx2N) */
    public native @Cast("uint8_t") byte partitionMode(); public native NV_ENC_HEVC_MV_DATA partitionMode(byte setter);
    /** Marker to separate CUs in the current CTB from CUs in the next CTB */
    public native @Cast("uint8_t") byte lastCUInCTB(); public native NV_ENC_HEVC_MV_DATA lastCUInCTB(byte setter);
}
