// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.nvcodec.nvencodeapi;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.nvcodec.nvcuvid.*;
import static org.bytedeco.nvcodec.global.nvcuvid.*;

import static org.bytedeco.nvcodec.global.nvencodeapi.*;



/**
 * \struct _NV_ENC_CONFIG
 * Encoder configuration parameters to be set during initialization.
 */
@Properties(inherit = org.bytedeco.nvcodec.presets.nvencodeapi.class)
public class NV_ENC_CONFIG extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NV_ENC_CONFIG() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NV_ENC_CONFIG(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NV_ENC_CONFIG(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NV_ENC_CONFIG position(long position) {
        return (NV_ENC_CONFIG)super.position(position);
    }
    @Override public NV_ENC_CONFIG getPointer(long i) {
        return new NV_ENC_CONFIG((Pointer)this).offsetAddress(i);
    }

    /** [in]: Struct version. Must be set to ::NV_ENC_CONFIG_VER. */
    public native @Cast("uint32_t") int version(); public native NV_ENC_CONFIG version(int setter);
    /** [in]: Specifies the codec profile GUID. If client specifies \p NV_ENC_CODEC_PROFILE_AUTOSELECT_GUID the NvEncodeAPI interface will select the appropriate codec profile. */
    public native @ByRef GUID profileGUID(); public native NV_ENC_CONFIG profileGUID(GUID setter);
    /** [in]: Specifies the number of pictures in one GOP. Low latency application client can set goplength to NVENC_INFINITE_GOPLENGTH so that keyframes are not inserted automatically. */
    public native @Cast("uint32_t") int gopLength(); public native NV_ENC_CONFIG gopLength(int setter);
    /** [in]: Specifies the GOP pattern as follows: \p frameIntervalP = 0: I, 1: IPP, 2: IBP, 3: IBBP  If goplength is set to NVENC_INFINITE_GOPLENGTH \p frameIntervalP should be set to 1. */
    public native @Cast("int32_t") int frameIntervalP(); public native NV_ENC_CONFIG frameIntervalP(int setter);
    /** [in]: Set this to 1 to enable monochrome encoding for this session. */
    public native @Cast("uint32_t") int monoChromeEncoding(); public native NV_ENC_CONFIG monoChromeEncoding(int setter);
    /** [in]: Specifies the frame/field mode.
                                                                                                Check support for field encoding using ::NV_ENC_CAPS_SUPPORT_FIELD_ENCODING caps.
                                                                                                Using a frameFieldMode other than NV_ENC_PARAMS_FRAME_FIELD_MODE_FRAME for RGB input is not supported. */
    public native @Cast("NV_ENC_PARAMS_FRAME_FIELD_MODE") int frameFieldMode(); public native NV_ENC_CONFIG frameFieldMode(int setter);
    /** [in]: Specifies the desired motion vector prediction precision. */
    public native @Cast("NV_ENC_MV_PRECISION") int mvPrecision(); public native NV_ENC_CONFIG mvPrecision(int setter);
    /** [in]: Specifies the rate control parameters for the current encoding session. */
    public native @ByRef NV_ENC_RC_PARAMS rcParams(); public native NV_ENC_CONFIG rcParams(NV_ENC_RC_PARAMS setter);
    /** [in]: Specifies the codec specific config parameters through this union. */
    public native @ByRef NV_ENC_CODEC_CONFIG encodeCodecConfig(); public native NV_ENC_CONFIG encodeCodecConfig(NV_ENC_CODEC_CONFIG setter);
    /** [in]: Reserved and must be set to 0 */
    public native @Cast("uint32_t") int reserved(int i); public native NV_ENC_CONFIG reserved(int i, int setter);
    @MemberGetter public native @Cast("uint32_t*") IntPointer reserved();
    /** [in]: Reserved and must be set to NULL */
    public native Pointer reserved2(int i); public native NV_ENC_CONFIG reserved2(int i, Pointer setter);
    @MemberGetter public native @Cast("void**") PointerPointer reserved2();
}
