// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.nvcodec.nvcuvid;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.nvcodec.global.nvcuvid.*;


/********************************************************/
/** \struct CUVIDVC1PICPARAMS
/** VC1 picture parameters
/** This structure is used in CUVIDPICPARAMS structure
/********************************************************/
@Properties(inherit = org.bytedeco.nvcodec.presets.nvcuvid.class)
public class CUVIDVC1PICPARAMS extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUVIDVC1PICPARAMS() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUVIDVC1PICPARAMS(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUVIDVC1PICPARAMS(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUVIDVC1PICPARAMS position(long position) {
        return (CUVIDVC1PICPARAMS)super.position(position);
    }
    @Override public CUVIDVC1PICPARAMS getPointer(long i) {
        return new CUVIDVC1PICPARAMS((Pointer)this).offsetAddress(i);
    }

    /** Picture index of forward reference (P/B-frames) */
    public native int ForwardRefIdx(); public native CUVIDVC1PICPARAMS ForwardRefIdx(int setter);
    /** Picture index of backward reference (B-frames)  */
    public native int BackwardRefIdx(); public native CUVIDVC1PICPARAMS BackwardRefIdx(int setter);
    /** Actual frame width                              */
    public native int FrameWidth(); public native CUVIDVC1PICPARAMS FrameWidth(int setter);
    /** Actual frame height                             */
    public native int FrameHeight(); public native CUVIDVC1PICPARAMS FrameHeight(int setter);
    // PICTURE
    /** Set to 1 for I,BI frames */
    public native int intra_pic_flag(); public native CUVIDVC1PICPARAMS intra_pic_flag(int setter);
    /** Set to 1 for I,P frames  */
    public native int ref_pic_flag(); public native CUVIDVC1PICPARAMS ref_pic_flag(int setter);
    /** Progressive frame        */
    public native int progressive_fcm(); public native CUVIDVC1PICPARAMS progressive_fcm(int setter);
    // SEQUENCE
    public native int profile(); public native CUVIDVC1PICPARAMS profile(int setter);
    public native int postprocflag(); public native CUVIDVC1PICPARAMS postprocflag(int setter);
    public native int pulldown(); public native CUVIDVC1PICPARAMS pulldown(int setter);
    public native int interlace(); public native CUVIDVC1PICPARAMS interlace(int setter);
    public native int tfcntrflag(); public native CUVIDVC1PICPARAMS tfcntrflag(int setter);
    public native int finterpflag(); public native CUVIDVC1PICPARAMS finterpflag(int setter);
    public native int psf(); public native CUVIDVC1PICPARAMS psf(int setter);
    public native int multires(); public native CUVIDVC1PICPARAMS multires(int setter);
    public native int syncmarker(); public native CUVIDVC1PICPARAMS syncmarker(int setter);
    public native int rangered(); public native CUVIDVC1PICPARAMS rangered(int setter);
    public native int maxbframes(); public native CUVIDVC1PICPARAMS maxbframes(int setter);
    // ENTRYPOINT
    public native int panscan_flag(); public native CUVIDVC1PICPARAMS panscan_flag(int setter);
    public native int refdist_flag(); public native CUVIDVC1PICPARAMS refdist_flag(int setter);
    public native int extended_mv(); public native CUVIDVC1PICPARAMS extended_mv(int setter);
    public native int dquant(); public native CUVIDVC1PICPARAMS dquant(int setter);
    public native int vstransform(); public native CUVIDVC1PICPARAMS vstransform(int setter);
    public native int loopfilter(); public native CUVIDVC1PICPARAMS loopfilter(int setter);
    public native int fastuvmc(); public native CUVIDVC1PICPARAMS fastuvmc(int setter);
    public native int overlap(); public native CUVIDVC1PICPARAMS overlap(int setter);
    public native int quantizer(); public native CUVIDVC1PICPARAMS quantizer(int setter);
    public native int extended_dmv(); public native CUVIDVC1PICPARAMS extended_dmv(int setter);
    public native int range_mapy_flag(); public native CUVIDVC1PICPARAMS range_mapy_flag(int setter);
    public native int range_mapy(); public native CUVIDVC1PICPARAMS range_mapy(int setter);
    public native int range_mapuv_flag(); public native CUVIDVC1PICPARAMS range_mapuv_flag(int setter);
    public native int range_mapuv(); public native CUVIDVC1PICPARAMS range_mapuv(int setter);
    public native int rangeredfrm(); public native CUVIDVC1PICPARAMS rangeredfrm(int setter);    // range reduction state
}
