// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.nvcodec.nvcuvid;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.nvcodec.global.nvcuvid.*;


/***********************************************************/
/** \struct CUVIDAV1PICPARAMS
/** AV1 picture parameters
/** This structure is used in CUVIDPICPARAMS structure
/***********************************************************/
@Properties(inherit = org.bytedeco.nvcodec.presets.nvcuvid.class)
public class CUVIDAV1PICPARAMS extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUVIDAV1PICPARAMS() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUVIDAV1PICPARAMS(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUVIDAV1PICPARAMS(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUVIDAV1PICPARAMS position(long position) {
        return (CUVIDAV1PICPARAMS)super.position(position);
    }
    @Override public CUVIDAV1PICPARAMS getPointer(long i) {
        return new CUVIDAV1PICPARAMS((Pointer)this).offsetAddress(i);
    }

    public native @Cast("unsigned int") int width(); public native CUVIDAV1PICPARAMS width(int setter);                               // coded width, if superres enabled then it is upscaled width
    public native @Cast("unsigned int") int height(); public native CUVIDAV1PICPARAMS height(int setter);                              // coded height
    public native @Cast("unsigned int") int frame_offset(); public native CUVIDAV1PICPARAMS frame_offset(int setter);                        // defined as order_hint in AV1 specification
    public native int decodePicIdx(); public native CUVIDAV1PICPARAMS decodePicIdx(int setter);                        // decoded output pic index, if film grain enabled, it will keep decoded (without film grain) output
                                                        // It can be used as reference frame for future frames

    // sequence header 
    public native @Cast("unsigned int") @NoOffset int profile(); public native CUVIDAV1PICPARAMS profile(int setter);                         // 0 = profile0, 1 = profile1, 2 = profile2
    public native @Cast("unsigned int") @NoOffset int use_128x128_superblock(); public native CUVIDAV1PICPARAMS use_128x128_superblock(int setter);          // superblock size 0:64x64, 1: 128x128
    public native @Cast("unsigned int") @NoOffset int subsampling_x(); public native CUVIDAV1PICPARAMS subsampling_x(int setter);                   // (subsampling_x, _y) 1,1 = 420, 1,0 = 422, 0,0 = 444
    public native @Cast("unsigned int") @NoOffset int subsampling_y(); public native CUVIDAV1PICPARAMS subsampling_y(int setter);
    public native @Cast("unsigned int") @NoOffset int mono_chrome(); public native CUVIDAV1PICPARAMS mono_chrome(int setter);                     // for monochrome content, mono_chrome = 1 and (subsampling_x, _y) should be 1,1
    public native @Cast("unsigned int") @NoOffset int bit_depth_minus8(); public native CUVIDAV1PICPARAMS bit_depth_minus8(int setter);                // bit depth minus 8
    public native @Cast("unsigned int") @NoOffset int enable_filter_intra(); public native CUVIDAV1PICPARAMS enable_filter_intra(int setter);             // tool enable in seq level, 0 : disable 1: frame header control
    public native @Cast("unsigned int") @NoOffset int enable_intra_edge_filter(); public native CUVIDAV1PICPARAMS enable_intra_edge_filter(int setter);        // intra edge filtering process, 0 : disable 1: enabled
    public native @Cast("unsigned int") @NoOffset int enable_interintra_compound(); public native CUVIDAV1PICPARAMS enable_interintra_compound(int setter);      // interintra, 0 : not present 1: present
    public native @Cast("unsigned int") @NoOffset int enable_masked_compound(); public native CUVIDAV1PICPARAMS enable_masked_compound(int setter);          // 1: mode info for inter blocks may contain the syntax element compound_type.
                                                        // 0: syntax element compound_type will not be present
    public native @Cast("unsigned int") @NoOffset int enable_dual_filter(); public native CUVIDAV1PICPARAMS enable_dual_filter(int setter);              // vertical and horiz filter selection, 1: enable and 0: disable 
    public native @Cast("unsigned int") @NoOffset int enable_order_hint(); public native CUVIDAV1PICPARAMS enable_order_hint(int setter);               // order hint, and related tools, 1: enable and 0: disable 
    public native @Cast("unsigned int") @NoOffset int order_hint_bits_minus1(); public native CUVIDAV1PICPARAMS order_hint_bits_minus1(int setter);          // is used to compute OrderHintBits
    public native @Cast("unsigned int") @NoOffset int enable_jnt_comp(); public native CUVIDAV1PICPARAMS enable_jnt_comp(int setter);                 // joint compound modes, 1: enable and 0: disable 
    public native @Cast("unsigned int") @NoOffset int enable_superres(); public native CUVIDAV1PICPARAMS enable_superres(int setter);                 // superres in seq level, 0 : disable 1: frame level control
    public native @Cast("unsigned int") @NoOffset int enable_cdef(); public native CUVIDAV1PICPARAMS enable_cdef(int setter);                     // cdef filtering in seq level, 0 : disable 1: frame level control
    public native @Cast("unsigned int") @NoOffset int enable_restoration(); public native CUVIDAV1PICPARAMS enable_restoration(int setter);              // loop restoration filtering in seq level, 0 : disable 1: frame level control
    public native @Cast("unsigned int") @NoOffset int enable_fgs(); public native CUVIDAV1PICPARAMS enable_fgs(int setter);                      // defined as film_grain_params_present in AV1 specification
    public native @Cast("unsigned int") @NoOffset int reserved0_7bits(); public native CUVIDAV1PICPARAMS reserved0_7bits(int setter);                 // reserved bits; must be set to 0

    // frame header
    public native @Cast("unsigned int") @NoOffset int frame_type(); public native CUVIDAV1PICPARAMS frame_type(int setter);                     // 0:Key frame, 1:Inter frame, 2:intra only, 3:s-frame
    public native @Cast("unsigned int") @NoOffset int show_frame(); public native CUVIDAV1PICPARAMS show_frame(int setter);                     // show_frame = 1 implies that frame should be immediately output once decoded
    public native @Cast("unsigned int") @NoOffset int disable_cdf_update(); public native CUVIDAV1PICPARAMS disable_cdf_update(int setter);              // CDF update during symbol decoding, 1: disabled, 0: enabled
    public native @Cast("unsigned int") @NoOffset int allow_screen_content_tools(); public native CUVIDAV1PICPARAMS allow_screen_content_tools(int setter);      // 1: intra blocks may use palette encoding, 0: palette encoding is never used
    public native @Cast("unsigned int") @NoOffset int force_integer_mv(); public native CUVIDAV1PICPARAMS force_integer_mv(int setter);                // 1: motion vectors will always be integers, 0: can contain fractional bits
    public native @Cast("unsigned int") @NoOffset int coded_denom(); public native CUVIDAV1PICPARAMS coded_denom(int setter);                     // coded_denom of the superres scale as specified in AV1 specification
    public native @Cast("unsigned int") @NoOffset int allow_intrabc(); public native CUVIDAV1PICPARAMS allow_intrabc(int setter);                   // 1: intra block copy may be used, 0: intra block copy is not allowed
    public native @Cast("unsigned int") @NoOffset int allow_high_precision_mv(); public native CUVIDAV1PICPARAMS allow_high_precision_mv(int setter);         // 1/8 precision mv enable
    public native @Cast("unsigned int") @NoOffset int interp_filter(); public native CUVIDAV1PICPARAMS interp_filter(int setter);                   // interpolation filter. Refer to section 6.8.9 of the AV1 specification Version 1.0.0 with Errata 1
    public native @Cast("unsigned int") @NoOffset int switchable_motion_mode(); public native CUVIDAV1PICPARAMS switchable_motion_mode(int setter);          // defined as is_motion_mode_switchable in AV1 specification
    public native @Cast("unsigned int") @NoOffset int use_ref_frame_mvs(); public native CUVIDAV1PICPARAMS use_ref_frame_mvs(int setter);               // 1: current frame can use the previous frame mv information, 0: will not use.
    public native @Cast("unsigned int") @NoOffset int disable_frame_end_update_cdf(); public native CUVIDAV1PICPARAMS disable_frame_end_update_cdf(int setter);    // 1: indicates that the end of frame CDF update is disabled
    public native @Cast("unsigned int") @NoOffset int delta_q_present(); public native CUVIDAV1PICPARAMS delta_q_present(int setter);                 // quantizer index delta values are present in the block level
    public native @Cast("unsigned int") @NoOffset int delta_q_res(); public native CUVIDAV1PICPARAMS delta_q_res(int setter);                     // left shift which should be applied to decoded quantizer index delta values
    public native @Cast("unsigned int") @NoOffset int using_qmatrix(); public native CUVIDAV1PICPARAMS using_qmatrix(int setter);                   // 1: quantizer matrix will be used to compute quantizers
    public native @Cast("unsigned int") @NoOffset int coded_lossless(); public native CUVIDAV1PICPARAMS coded_lossless(int setter);                  // 1: all segments use lossless coding
    public native @Cast("unsigned int") @NoOffset int use_superres(); public native CUVIDAV1PICPARAMS use_superres(int setter);                    // 1: superres enabled for frame 
    public native @Cast("unsigned int") @NoOffset int tx_mode(); public native CUVIDAV1PICPARAMS tx_mode(int setter);                         // 0: ONLY4x4,1:LARGEST,2:SELECT
    public native @Cast("unsigned int") @NoOffset int reference_mode(); public native CUVIDAV1PICPARAMS reference_mode(int setter);                  // 0: SINGLE, 1: SELECT
    public native @Cast("unsigned int") @NoOffset int allow_warped_motion(); public native CUVIDAV1PICPARAMS allow_warped_motion(int setter);             // 1: allow_warped_motion may be present, 0: allow_warped_motion will not be present
    public native @Cast("unsigned int") @NoOffset int reduced_tx_set(); public native CUVIDAV1PICPARAMS reduced_tx_set(int setter);                  // 1: frame is restricted to subset of the full set of transform types, 0: no such restriction
    public native @Cast("unsigned int") @NoOffset int skip_mode(); public native CUVIDAV1PICPARAMS skip_mode(int setter);                       // 1: most of the mode info is skipped, 0: mode info is not skipped
    public native @Cast("unsigned int") @NoOffset int reserved1_3bits(); public native CUVIDAV1PICPARAMS reserved1_3bits(int setter);                 // reserved bits; must be set to 0

    // tiling info
    public native @Cast("unsigned int") @NoOffset int num_tile_cols(); public native CUVIDAV1PICPARAMS num_tile_cols(int setter);                   // number of tiles across the frame., max is 64
    public native @Cast("unsigned int") @NoOffset int num_tile_rows(); public native CUVIDAV1PICPARAMS num_tile_rows(int setter);                   // number of tiles down the frame., max is 64
    public native @Cast("unsigned int") @NoOffset int context_update_tile_id(); public native CUVIDAV1PICPARAMS context_update_tile_id(int setter);         // specifies which tile to use for the CDF update
    public native @Cast("unsigned short") short tile_widths(int i); public native CUVIDAV1PICPARAMS tile_widths(int i, short setter);
    @MemberGetter public native @Cast("unsigned short*") ShortPointer tile_widths();                     // Width of each column in superblocks
    public native @Cast("unsigned short") short tile_heights(int i); public native CUVIDAV1PICPARAMS tile_heights(int i, short setter);
    @MemberGetter public native @Cast("unsigned short*") ShortPointer tile_heights();                    // height of each row in superblocks

    // CDEF - refer to section 6.10.14 of the AV1 specification Version 1.0.0 with Errata 1
    public native @Cast("unsigned char") @NoOffset byte cdef_damping_minus_3(); public native CUVIDAV1PICPARAMS cdef_damping_minus_3(byte setter);            // controls the amount of damping in the deringing filter 
    public native @Cast("unsigned char") @NoOffset byte cdef_bits(); public native CUVIDAV1PICPARAMS cdef_bits(byte setter);                       // the number of bits needed to specify which CDEF filter to apply  
    public native @Cast("unsigned char") @NoOffset byte reserved2_4bits(); public native CUVIDAV1PICPARAMS reserved2_4bits(byte setter);                 // reserved bits; must be set to 0
    public native @Cast("unsigned char") byte cdef_y_strength(int i); public native CUVIDAV1PICPARAMS cdef_y_strength(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer cdef_y_strength();                  // 0-3 bits: y_pri_strength, 4-7 bits y_sec_strength
    public native @Cast("unsigned char") byte cdef_uv_strength(int i); public native CUVIDAV1PICPARAMS cdef_uv_strength(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer cdef_uv_strength();                 // 0-3 bits: uv_pri_strength, 4-7 bits uv_sec_strength

    // SkipModeFrames
    public native @Cast("unsigned char") @NoOffset byte SkipModeFrame0(); public native CUVIDAV1PICPARAMS SkipModeFrame0(byte setter);                 // specifies the frames to use for compound prediction when skip_mode is equal to 1.
    public native @Cast("unsigned char") @NoOffset byte SkipModeFrame1(); public native CUVIDAV1PICPARAMS SkipModeFrame1(byte setter);

    // qp information - refer to section 6.8.11 of the AV1 specification Version 1.0.0 with Errata 1
    public native @Cast("unsigned char") byte base_qindex(); public native CUVIDAV1PICPARAMS base_qindex(byte setter);                         // indicates the base frame qindex. Defined as base_q_idx in AV1 specification
    public native @Cast("char") byte qp_y_dc_delta_q(); public native CUVIDAV1PICPARAMS qp_y_dc_delta_q(byte setter);                     // indicates the Y DC quantizer relative to base_q_idx. Defined as DeltaQYDc in AV1 specification
    public native @Cast("char") byte qp_u_dc_delta_q(); public native CUVIDAV1PICPARAMS qp_u_dc_delta_q(byte setter);                     // indicates the U DC quantizer relative to base_q_idx. Defined as DeltaQUDc in AV1 specification
    public native @Cast("char") byte qp_v_dc_delta_q(); public native CUVIDAV1PICPARAMS qp_v_dc_delta_q(byte setter);                     // indicates the V DC quantizer relative to base_q_idx. Defined as DeltaQVDc in AV1 specification
    public native @Cast("char") byte qp_u_ac_delta_q(); public native CUVIDAV1PICPARAMS qp_u_ac_delta_q(byte setter);                     // indicates the U AC quantizer relative to base_q_idx. Defined as DeltaQUAc in AV1 specification
    public native @Cast("char") byte qp_v_ac_delta_q(); public native CUVIDAV1PICPARAMS qp_v_ac_delta_q(byte setter);                     // indicates the V AC quantizer relative to base_q_idx. Defined as DeltaQVAc in AV1 specification
    public native @Cast("unsigned char") byte qm_y(); public native CUVIDAV1PICPARAMS qm_y(byte setter);                                // specifies the level in the quantizer matrix that should be used for luma plane decoding
    public native @Cast("unsigned char") byte qm_u(); public native CUVIDAV1PICPARAMS qm_u(byte setter);                                // specifies the level in the quantizer matrix that should be used for chroma U plane decoding
    public native @Cast("unsigned char") byte qm_v(); public native CUVIDAV1PICPARAMS qm_v(byte setter);                                // specifies the level in the quantizer matrix that should be used for chroma V plane decoding

    // segmentation - refer to section 6.8.13 of the AV1 specification Version 1.0.0 with Errata 1
    public native @Cast("unsigned char") @NoOffset byte segmentation_enabled(); public native CUVIDAV1PICPARAMS segmentation_enabled(byte setter);             // 1 indicates that this frame makes use of the segmentation tool
    public native @Cast("unsigned char") @NoOffset byte segmentation_update_map(); public native CUVIDAV1PICPARAMS segmentation_update_map(byte setter);          // 1 indicates that the segmentation map are updated during the decoding of this frame
    public native @Cast("unsigned char") @NoOffset byte segmentation_update_data(); public native CUVIDAV1PICPARAMS segmentation_update_data(byte setter);         // 1 indicates that new parameters are about to be specified for each segment
    public native @Cast("unsigned char") @NoOffset byte segmentation_temporal_update(); public native CUVIDAV1PICPARAMS segmentation_temporal_update(byte setter);     // 1 indicates that the updates to the segmentation map are coded relative to the existing segmentation map
    public native @Cast("unsigned char") @NoOffset byte reserved3_4bits(); public native CUVIDAV1PICPARAMS reserved3_4bits(byte setter);                  // reserved bits; must be set to 0
    public native short segmentation_feature_data(int i, int j); public native CUVIDAV1PICPARAMS segmentation_feature_data(int i, int j, short setter);
    @MemberGetter public native @Cast("short(* /*[8]*/ )[8]") ShortPointer segmentation_feature_data();      // specifies the feature data for a segment feature
    public native @Cast("unsigned char") byte segmentation_feature_mask(int i); public native CUVIDAV1PICPARAMS segmentation_feature_mask(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer segmentation_feature_mask();         // indicates that the corresponding feature is unused or feature value is coded

    // loopfilter - refer to section 6.8.10 of the AV1 specification Version 1.0.0 with Errata 1
    public native @Cast("unsigned char") byte loop_filter_level(int i); public native CUVIDAV1PICPARAMS loop_filter_level(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer loop_filter_level();                // contains loop filter strength values
    public native @Cast("unsigned char") byte loop_filter_level_u(); public native CUVIDAV1PICPARAMS loop_filter_level_u(byte setter);                 // loop filter strength value of U plane
    public native @Cast("unsigned char") byte loop_filter_level_v(); public native CUVIDAV1PICPARAMS loop_filter_level_v(byte setter);                 // loop filter strength value of V plane
    public native @Cast("unsigned char") byte loop_filter_sharpness(); public native CUVIDAV1PICPARAMS loop_filter_sharpness(byte setter);               // indicates the sharpness level
    public native @Cast("char") byte loop_filter_ref_deltas(int i); public native CUVIDAV1PICPARAMS loop_filter_ref_deltas(int i, byte setter);
    @MemberGetter public native @Cast("char*") BytePointer loop_filter_ref_deltas();           // contains the adjustment needed for the filter level based on the chosen reference frame
    public native @Cast("char") byte loop_filter_mode_deltas(int i); public native CUVIDAV1PICPARAMS loop_filter_mode_deltas(int i, byte setter);
    @MemberGetter public native @Cast("char*") BytePointer loop_filter_mode_deltas();          // contains the adjustment needed for the filter level based on the chosen mode
    public native @Cast("unsigned char") @NoOffset byte loop_filter_delta_enabled(); public native CUVIDAV1PICPARAMS loop_filter_delta_enabled(byte setter);       // indicates that the filter level depends on the mode and reference frame used to predict a block
    public native @Cast("unsigned char") @NoOffset byte loop_filter_delta_update(); public native CUVIDAV1PICPARAMS loop_filter_delta_update(byte setter);        // indicates that additional syntax elements are present that specify which mode and
                                                        // reference frame deltas are to be updated
    public native @Cast("unsigned char") @NoOffset byte delta_lf_present(); public native CUVIDAV1PICPARAMS delta_lf_present(byte setter);                // specifies whether loop filter delta values are present in the block level
    public native @Cast("unsigned char") @NoOffset byte delta_lf_res(); public native CUVIDAV1PICPARAMS delta_lf_res(byte setter);                    // specifies the left shift to apply to the decoded loop filter values
    public native @Cast("unsigned char") @NoOffset byte delta_lf_multi(); public native CUVIDAV1PICPARAMS delta_lf_multi(byte setter);                 // separate loop filter deltas for Hy,Vy,U,V edges
    public native @Cast("unsigned char") @NoOffset byte reserved4_2bits(); public native CUVIDAV1PICPARAMS reserved4_2bits(byte setter);                 // reserved bits; must be set to 0

    // restoration - refer to section 6.10.15 of the AV1 specification Version 1.0.0 with Errata 1
    public native @Cast("unsigned char") byte lr_unit_size(int i); public native CUVIDAV1PICPARAMS lr_unit_size(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer lr_unit_size();                     // specifies the size of loop restoration units: 0: 32, 1: 64, 2: 128, 3: 256
    public native @Cast("unsigned char") byte lr_type(int i); public native CUVIDAV1PICPARAMS lr_type(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer lr_type();                         // used to compute FrameRestorationType

    // reference frames
    public native @Cast("unsigned char") byte primary_ref_frame(); public native CUVIDAV1PICPARAMS primary_ref_frame(byte setter);                    // specifies which reference frame contains the CDF values and other state that should be 
                                                        // loaded at the start of the frame
    public native @Cast("unsigned char") byte ref_frame_map(int i); public native CUVIDAV1PICPARAMS ref_frame_map(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer ref_frame_map();                     // frames in dpb that can be used as reference for current or future frames

    public native @Cast("unsigned char") @NoOffset byte temporal_layer_id(); public native CUVIDAV1PICPARAMS temporal_layer_id(byte setter);                // temporal layer id
    public native @Cast("unsigned char") @NoOffset byte spatial_layer_id(); public native CUVIDAV1PICPARAMS spatial_layer_id(byte setter);                 // spatial layer id

    public native @Cast("unsigned char") byte reserved5_32bits(int i); public native CUVIDAV1PICPARAMS reserved5_32bits(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer reserved5_32bits();                  // reserved bits; must be set to 0

    // ref frame list
        @Name({"ref_frame", ".width"}) public native @Cast("unsigned int") int ref_frame_width(int i); public native CUVIDAV1PICPARAMS ref_frame_width(int i, int setter);
        @Name({"ref_frame", ".height"}) public native @Cast("unsigned int") int ref_frame_height(int i); public native CUVIDAV1PICPARAMS ref_frame_height(int i, int setter);
        @Name({"ref_frame", ".index"}) public native @Cast("unsigned char") byte ref_frame_index(int i); public native CUVIDAV1PICPARAMS ref_frame_index(int i, byte setter);
        @Name({"ref_frame", ".reserved24Bits"}) @MemberGetter public native @Cast("unsigned char*") BytePointer ref_frame_reserved24Bits(int i);               // reserved bits; must be set to 0                                     // frames used as reference frame for current frame.
    
    // global motion
        @Name({"global_motion", ".invalid"}) public native @Cast("unsigned char") @NoOffset byte global_motion_invalid(int i); public native CUVIDAV1PICPARAMS global_motion_invalid(int i, byte setter);
        @Name({"global_motion", ".wmtype"}) public native @Cast("unsigned char") @NoOffset byte global_motion_wmtype(int i); public native CUVIDAV1PICPARAMS global_motion_wmtype(int i, byte setter);                       // defined as GmType in AV1 specification
        @Name({"global_motion", ".reserved5Bits"}) public native @Cast("unsigned char") @NoOffset byte global_motion_reserved5Bits(int i); public native CUVIDAV1PICPARAMS global_motion_reserved5Bits(int i, byte setter);                // reserved bits; must be set to 0
        @Name({"global_motion", ".reserved24Bits"}) @MemberGetter public native @Cast("char*") BytePointer global_motion_reserved24Bits(int i);                // reserved bits; must be set to 0
        @Name({"global_motion", ".wmmat"}) @MemberGetter public native IntPointer global_motion_wmmat(int i);                         // defined as gm_params[] in AV1 specification                                 // global motion params for reference frames
    
    // film grain params - refer to section 6.8.20 of the AV1 specification Version 1.0.0 with Errata 1
    public native @Cast("unsigned short") @NoOffset short apply_grain(); public native CUVIDAV1PICPARAMS apply_grain(short setter);
    public native @Cast("unsigned short") @NoOffset short overlap_flag(); public native CUVIDAV1PICPARAMS overlap_flag(short setter);
    public native @Cast("unsigned short") @NoOffset short scaling_shift_minus8(); public native CUVIDAV1PICPARAMS scaling_shift_minus8(short setter);
    public native @Cast("unsigned short") @NoOffset short chroma_scaling_from_luma(); public native CUVIDAV1PICPARAMS chroma_scaling_from_luma(short setter);  
    public native @Cast("unsigned short") @NoOffset short ar_coeff_lag(); public native CUVIDAV1PICPARAMS ar_coeff_lag(short setter);
    public native @Cast("unsigned short") @NoOffset short ar_coeff_shift_minus6(); public native CUVIDAV1PICPARAMS ar_coeff_shift_minus6(short setter);
    public native @Cast("unsigned short") @NoOffset short grain_scale_shift(); public native CUVIDAV1PICPARAMS grain_scale_shift(short setter);
    public native @Cast("unsigned short") @NoOffset short clip_to_restricted_range(); public native CUVIDAV1PICPARAMS clip_to_restricted_range(short setter);
    public native @Cast("unsigned short") @NoOffset short reserved6_4bits(); public native CUVIDAV1PICPARAMS reserved6_4bits(short setter);                 // reserved bits; must be set to 0
    public native @Cast("unsigned char") byte num_y_points(); public native CUVIDAV1PICPARAMS num_y_points(byte setter);
    public native @Cast("unsigned char") byte scaling_points_y(int i, int j); public native CUVIDAV1PICPARAMS scaling_points_y(int i, int j, byte setter);
    @MemberGetter public native @Cast("unsigned char(* /*[14]*/ )[2]") BytePointer scaling_points_y();
    public native @Cast("unsigned char") byte num_cb_points(); public native CUVIDAV1PICPARAMS num_cb_points(byte setter);
    public native @Cast("unsigned char") byte scaling_points_cb(int i, int j); public native CUVIDAV1PICPARAMS scaling_points_cb(int i, int j, byte setter);
    @MemberGetter public native @Cast("unsigned char(* /*[10]*/ )[2]") BytePointer scaling_points_cb();
    public native @Cast("unsigned char") byte num_cr_points(); public native CUVIDAV1PICPARAMS num_cr_points(byte setter);
    public native @Cast("unsigned char") byte scaling_points_cr(int i, int j); public native CUVIDAV1PICPARAMS scaling_points_cr(int i, int j, byte setter);
    @MemberGetter public native @Cast("unsigned char(* /*[10]*/ )[2]") BytePointer scaling_points_cr();
    public native @Cast("unsigned char") byte reserved7_8bits(); public native CUVIDAV1PICPARAMS reserved7_8bits(byte setter);                     // reserved bits; must be set to 0
    public native @Cast("unsigned short") short random_seed(); public native CUVIDAV1PICPARAMS random_seed(short setter);
    public native short ar_coeffs_y(int i); public native CUVIDAV1PICPARAMS ar_coeffs_y(int i, short setter);
    @MemberGetter public native ShortPointer ar_coeffs_y();
    public native short ar_coeffs_cb(int i); public native CUVIDAV1PICPARAMS ar_coeffs_cb(int i, short setter);
    @MemberGetter public native ShortPointer ar_coeffs_cb();
    public native short ar_coeffs_cr(int i); public native CUVIDAV1PICPARAMS ar_coeffs_cr(int i, short setter);
    @MemberGetter public native ShortPointer ar_coeffs_cr();
    public native @Cast("unsigned char") byte cb_mult(); public native CUVIDAV1PICPARAMS cb_mult(byte setter);
    public native @Cast("unsigned char") byte cb_luma_mult(); public native CUVIDAV1PICPARAMS cb_luma_mult(byte setter);
    public native short cb_offset(); public native CUVIDAV1PICPARAMS cb_offset(short setter);
    public native @Cast("unsigned char") byte cr_mult(); public native CUVIDAV1PICPARAMS cr_mult(byte setter);
    public native @Cast("unsigned char") byte cr_luma_mult(); public native CUVIDAV1PICPARAMS cr_luma_mult(byte setter);
    public native short cr_offset(); public native CUVIDAV1PICPARAMS cr_offset(short setter);

    public native int reserved(int i); public native CUVIDAV1PICPARAMS reserved(int i, int setter);
    @MemberGetter public native IntPointer reserved();                       // reserved bits; must be set to 0
}
