// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.nvcodec.global;

import org.bytedeco.nvcodec.nvencodeapi.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.nvcodec.nvcuvid.*;
import static org.bytedeco.nvcodec.global.nvcuvid.*;

public class nvencodeapi extends org.bytedeco.nvcodec.presets.nvencodeapi {
    static { Loader.load(); }

// Parsed from nvEncodeAPI.h

/*
 * This copyright notice applies to this header file only:
 *
 * Copyright (c) 2010-2021 NVIDIA Corporation
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the software, and to permit persons to whom the
 * software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * \file nvEncodeAPI.h
 *   NVIDIA GPUs - beginning with the Kepler generation - contain a hardware-based encoder
 *   (referred to as NVENC) which provides fully-accelerated hardware-based video encoding.
 *   NvEncodeAPI provides the interface for NVIDIA video encoder (NVENC).
 * \date 2011-2020
 *  This file contains the interface constants, structure definitions and function prototypes.
 */

// #ifndef _NV_ENCODEAPI_H_
// #define _NV_ENCODEAPI_H_

// #include <stdlib.h>

// #ifdef _WIN32
// #include <windows.h>
// #endif

// #ifdef _MSC_VER
// #ifndef _STDINT
// #endif
// #else
// #include <stdint.h>
// #endif

// #ifdef __cplusplus
// #endif

/**
 * \addtogroup ENCODER_STRUCTURE NvEncodeAPI Data structures
 * \{
 */

// #ifdef _WIN32
// #define NVENCAPI     __stdcall
// #else
// #define NVENCAPI
// Targeting ..\nvencodeapi\GUID.java


// Targeting ..\nvencodeapi\RECT.java


// Targeting ..\nvencodeapi\NV_ENC_INPUT_PTR.java


// Targeting ..\nvencodeapi\NV_ENC_OUTPUT_PTR.java


// Targeting ..\nvencodeapi\NV_ENC_REGISTERED_PTR.java


// Targeting ..\nvencodeapi\NV_ENC_CUSTREAM_PTR.java



public static final int NVENCAPI_MAJOR_VERSION = 11;
public static final int NVENCAPI_MINOR_VERSION = 1;

public static final int NVENCAPI_VERSION = (NVENCAPI_MAJOR_VERSION | (NVENCAPI_MINOR_VERSION << 24));

/**
 * Macro to generate per-structure version for use with API.
 */
// #define NVENCAPI_STRUCT_VERSION(ver) ((uint32_t)NVENCAPI_VERSION | ((ver)<<16) | (0x7 << 28))


public static final int NVENC_INFINITE_GOPLENGTH =  0xffffffff;

public static final int NV_MAX_SEQ_HDR_LEN =  (512);

// #ifdef __GNUC__
// #define NV_ENC_DEPRECATED __attribute__ ((deprecated("WILL BE REMOVED IN A FUTURE VIDEO CODEC SDK VERSION")))
// #elif defined(_MSC_VER)
// #define NV_ENC_DEPRECATED __declspec(deprecated("WILL BE REMOVED IN A FUTURE VIDEO CODEC SDK VERSION"))
// #endif

// =========================================================================================
// Encode Codec GUIDS supported by the NvEncodeAPI interface.
// =========================================================================================

// {6BC82762-4E63-4ca4-AA85-1E50F321F6BF}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_CODEC_H264_GUID();

// {790CDC88-4522-4d7b-9425-BDA9975F7603}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_CODEC_HEVC_GUID();



// =========================================================================================
// *   Encode Profile GUIDS supported by the NvEncodeAPI interface.
// =========================================================================================

// {BFD6F8E7-233C-4341-8B3E-4818523803F4}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_CODEC_PROFILE_AUTOSELECT_GUID();

// {0727BCAA-78C4-4c83-8C2F-EF3DFF267C6A}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_H264_PROFILE_BASELINE_GUID();

// {60B5C1D4-67FE-4790-94D5-C4726D7B6E6D}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_H264_PROFILE_MAIN_GUID();

// {E7CBC309-4F7A-4b89-AF2A-D537C92BE310}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_H264_PROFILE_HIGH_GUID();

// {7AC663CB-A598-4960-B844-339B261A7D52}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_H264_PROFILE_HIGH_444_GUID();

// {40847BF5-33F7-4601-9084-E8FE3C1DB8B7}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_H264_PROFILE_STEREO_GUID();

// {B405AFAC-F32B-417B-89C4-9ABEED3E5978}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_H264_PROFILE_PROGRESSIVE_HIGH_GUID();

// {AEC1BD87-E85B-48f2-84C3-98BCA6285072}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_H264_PROFILE_CONSTRAINED_HIGH_GUID();

// {B514C39A-B55B-40fa-878F-F1253B4DFDEC}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_HEVC_PROFILE_MAIN_GUID();

// {fa4d2b6c-3a5b-411a-8018-0a3f5e3c9be5}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_HEVC_PROFILE_MAIN10_GUID();

// For HEVC Main 444 8 bit and HEVC Main 444 10 bit profiles only
// {51ec32b5-1b4c-453c-9cbd-b616bd621341}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_HEVC_PROFILE_FREXT_GUID();

// =========================================================================================
// *   Preset GUIDS supported by the NvEncodeAPI interface.
// =========================================================================================
// {B2DFB705-4EBD-4C49-9B5F-24A777D3E587}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_DEFAULT_GUID();

// {60E4C59F-E846-4484-A56D-CD45BE9FDDF6}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_HP_GUID();

// {34DBA71D-A77B-4B8F-9C3E-B6D5DA24C012}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_HQ_GUID();

// {82E3E450-BDBB-4e40-989C-82A90DF9EF32}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_BD_GUID();

// {49DF21C5-6DFA-4feb-9787-6ACC9EFFB726}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_LOW_LATENCY_DEFAULT_GUID();

// {C5F733B9-EA97-4cf9-BEC2-BF78A74FD105}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_LOW_LATENCY_HQ_GUID();

// {67082A44-4BAD-48FA-98EA-93056D150A58}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_LOW_LATENCY_HP_GUID();

// {D5BFB716-C604-44e7-9BB8-DEA5510FC3AC}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_LOSSLESS_DEFAULT_GUID();

// {149998E7-2364-411d-82EF-179888093409}
@MemberGetter public static native @Const @Deprecated @ByRef GUID NV_ENC_PRESET_LOSSLESS_HP_GUID();

// Performance degrades and quality improves as we move from P1 to P7. Presets P3 to P7 for H264 and Presets P2 to P7 for HEVC have B frames enabled by default 
// for HIGH_QUALITY and LOSSLESS tuning info, and will not work with Weighted Prediction enabled. In case Weighted Prediction is required, disable B frames by
// setting frameIntervalP = 1
// {FC0A8D3E-45F8-4CF8-80C7-298871590EBF}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_PRESET_P1_GUID();

// {F581CFB8-88D6-4381-93F0-DF13F9C27DAB}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_PRESET_P2_GUID();

// {36850110-3A07-441F-94D5-3670631F91F6}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_PRESET_P3_GUID();

// {90A7B826-DF06-4862-B9D2-CD6D73A08681}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_PRESET_P4_GUID();

// {21C6E6B4-297A-4CBA-998F-B6CBDE72ADE3}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_PRESET_P5_GUID();

// {8E75C279-6299-4AB6-8302-0B215A335CF5}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_PRESET_P6_GUID();

// {84848C12-6F71-4C13-931B-53E283F57974}
@MemberGetter public static native @Const @ByRef GUID NV_ENC_PRESET_P7_GUID();

/**
 * \addtogroup ENCODER_STRUCTURE NvEncodeAPI Data structures
 * \{
 */

/**
 * Input frame encode modes
 */
/** enum NV_ENC_PARAMS_FRAME_FIELD_MODE */
public static final int
    /** Frame mode */
    NV_ENC_PARAMS_FRAME_FIELD_MODE_FRAME = 0x01,
    /** Field mode */
    NV_ENC_PARAMS_FRAME_FIELD_MODE_FIELD = 0x02,
    /** MB adaptive frame/field */
    NV_ENC_PARAMS_FRAME_FIELD_MODE_MBAFF = 0x03;

/**
 * Rate Control Modes
 */
/** enum NV_ENC_PARAMS_RC_MODE */
public static final int
    /** Constant QP mode */
    NV_ENC_PARAMS_RC_CONSTQP                = 0x0,
    /** Variable bitrate mode */
    NV_ENC_PARAMS_RC_VBR                    = 0x1,
    /** Constant bitrate mode */
    NV_ENC_PARAMS_RC_CBR                    = 0x2,
    /** Deprecated, use NV_ENC_PARAMS_RC_CBR + NV_ENC_TWO_PASS_QUARTER_RESOLUTION / NV_ENC_TWO_PASS_FULL_RESOLUTION +
                                                              lowDelayKeyFrameScale=1 */
    NV_ENC_PARAMS_RC_CBR_LOWDELAY_HQ        = 0x8,
    /** Deprecated, use NV_ENC_PARAMS_RC_CBR + NV_ENC_TWO_PASS_QUARTER_RESOLUTION / NV_ENC_TWO_PASS_FULL_RESOLUTION */
    NV_ENC_PARAMS_RC_CBR_HQ                 = 0x10,
    /** Deprecated, use NV_ENC_PARAMS_RC_VBR + NV_ENC_TWO_PASS_QUARTER_RESOLUTION / NV_ENC_TWO_PASS_FULL_RESOLUTION */
    NV_ENC_PARAMS_RC_VBR_HQ                 = 0x20;

/**
 * Multi Pass encoding
 */
/** enum NV_ENC_MULTI_PASS */
public static final int
    /** Single Pass */
    NV_ENC_MULTI_PASS_DISABLED              = 0x0,
    /** Two Pass encoding is enabled where first Pass is quarter resolution */
    NV_ENC_TWO_PASS_QUARTER_RESOLUTION      = 0x1,
    /** Two Pass encoding is enabled where first Pass is full resolution */
    NV_ENC_TWO_PASS_FULL_RESOLUTION         = 0x2;

/**
 * Emphasis Levels
 */
/** enum NV_ENC_EMPHASIS_MAP_LEVEL */
public static final int
    /** Emphasis Map Level 0, for zero Delta QP value */
    NV_ENC_EMPHASIS_MAP_LEVEL_0               = 0x0,
    /** Emphasis Map Level 1, for very low Delta QP value */
    NV_ENC_EMPHASIS_MAP_LEVEL_1               = 0x1,
    /** Emphasis Map Level 2, for low Delta QP value */
    NV_ENC_EMPHASIS_MAP_LEVEL_2               = 0x2,
    /** Emphasis Map Level 3, for medium Delta QP value */
    NV_ENC_EMPHASIS_MAP_LEVEL_3               = 0x3,
    /** Emphasis Map Level 4, for high Delta QP value */
    NV_ENC_EMPHASIS_MAP_LEVEL_4               = 0x4,
    /** Emphasis Map Level 5, for very high Delta QP value */
    NV_ENC_EMPHASIS_MAP_LEVEL_5               = 0x5;

/**
 * QP MAP MODE
 */
/** enum NV_ENC_QP_MAP_MODE */
public static final int
    /** Value in NV_ENC_PIC_PARAMS::qpDeltaMap have no effect. */
    NV_ENC_QP_MAP_DISABLED               = 0x0,
    /** Value in NV_ENC_PIC_PARAMS::qpDeltaMap will be treated as Emphasis level. Currently this is only supported for H264 */
    NV_ENC_QP_MAP_EMPHASIS               = 0x1,
    /** Value in NV_ENC_PIC_PARAMS::qpDeltaMap will be treated as QP delta map. */
    NV_ENC_QP_MAP_DELTA                  = 0x2,
    /** Currently This is not supported. Value in NV_ENC_PIC_PARAMS::qpDeltaMap will be treated as QP value.   */
    NV_ENC_QP_MAP                        = 0x3;


/**
 * Input picture structure
 */
/** enum NV_ENC_PIC_STRUCT */
public static final int
    /** Progressive frame */
    NV_ENC_PIC_STRUCT_FRAME             = 0x01,
    /** Field encoding top field first */
    NV_ENC_PIC_STRUCT_FIELD_TOP_BOTTOM  = 0x02,
    /** Field encoding bottom field first */
    NV_ENC_PIC_STRUCT_FIELD_BOTTOM_TOP  = 0x03;

/**
 * Input picture type
 */
/** enum NV_ENC_PIC_TYPE */
public static final int
    /** Forward predicted */
    NV_ENC_PIC_TYPE_P               = 0x0,
    /** Bi-directionally predicted picture */
    NV_ENC_PIC_TYPE_B               = 0x01,
    /** Intra predicted picture */
    NV_ENC_PIC_TYPE_I               = 0x02,
    /** IDR picture */
    NV_ENC_PIC_TYPE_IDR             = 0x03,
    /** Bi-directionally predicted with only Intra MBs */
    NV_ENC_PIC_TYPE_BI              = 0x04,
    /** Picture is skipped */
    NV_ENC_PIC_TYPE_SKIPPED         = 0x05,
    /** First picture in intra refresh cycle */
    NV_ENC_PIC_TYPE_INTRA_REFRESH   = 0x06,
    /** Non reference P picture */
    NV_ENC_PIC_TYPE_NONREF_P        = 0x07,            
    /** Picture type unknown */
    NV_ENC_PIC_TYPE_UNKNOWN         = 0xFF;

/**
 * Motion vector precisions
 */
/** enum NV_ENC_MV_PRECISION */
public static final int
    /** Driver selects Quarter-Pel motion vector precision by default */
    NV_ENC_MV_PRECISION_DEFAULT     = 0x0,
    /** Full-Pel motion vector precision */
    NV_ENC_MV_PRECISION_FULL_PEL    = 0x01,
    /** Half-Pel motion vector precision */
    NV_ENC_MV_PRECISION_HALF_PEL    = 0x02,
    /** Quarter-Pel motion vector precision */
    NV_ENC_MV_PRECISION_QUARTER_PEL = 0x03;


/**
 * Input buffer formats
 */
/** enum NV_ENC_BUFFER_FORMAT */
public static final int
    /** Undefined buffer format */
    NV_ENC_BUFFER_FORMAT_UNDEFINED                       = 0x00000000,
                                                                       
    /** Semi-Planar YUV [Y plane followed by interleaved UV plane] */
    NV_ENC_BUFFER_FORMAT_NV12                            = 0x00000001,
    /** Planar YUV [Y plane followed by V and U planes] */
    NV_ENC_BUFFER_FORMAT_YV12                            = 0x00000010,
    /** Planar YUV [Y plane followed by U and V planes] */
    NV_ENC_BUFFER_FORMAT_IYUV                            = 0x00000100,
    /** Planar YUV [Y plane followed by U and V planes] */
    NV_ENC_BUFFER_FORMAT_YUV444                          = 0x00001000,
    /** 10 bit Semi-Planar YUV [Y plane followed by interleaved UV plane]. Each pixel of size 2 bytes. Most Significant 10 bits contain pixel data. */
    NV_ENC_BUFFER_FORMAT_YUV420_10BIT                    = 0x00010000,
    /** 10 bit Planar YUV444 [Y plane followed by U and V planes]. Each pixel of size 2 bytes. Most Significant 10 bits contain pixel data.  */
    NV_ENC_BUFFER_FORMAT_YUV444_10BIT                    = 0x00100000,
    /** 8 bit Packed A8R8G8B8. This is a word-ordered format
                                                                             where a pixel is represented by a 32-bit word with B
                                                                             in the lowest 8 bits, G in the next 8 bits, R in the
                                                                             8 bits after that and A in the highest 8 bits. */
    NV_ENC_BUFFER_FORMAT_ARGB                            = 0x01000000,
    /** 10 bit Packed A2R10G10B10. This is a word-ordered format
                                                                             where a pixel is represented by a 32-bit word with B
                                                                             in the lowest 10 bits, G in the next 10 bits, R in the
                                                                             10 bits after that and A in the highest 2 bits. */
    NV_ENC_BUFFER_FORMAT_ARGB10                          = 0x02000000,
    /** 8 bit Packed A8Y8U8V8. This is a word-ordered format
                                                                             where a pixel is represented by a 32-bit word with V
                                                                             in the lowest 8 bits, U in the next 8 bits, Y in the
                                                                             8 bits after that and A in the highest 8 bits. */
    NV_ENC_BUFFER_FORMAT_AYUV                            = 0x04000000,
    /** 8 bit Packed A8B8G8R8. This is a word-ordered format
                                                                             where a pixel is represented by a 32-bit word with R
                                                                             in the lowest 8 bits, G in the next 8 bits, B in the
                                                                             8 bits after that and A in the highest 8 bits. */
    NV_ENC_BUFFER_FORMAT_ABGR                            = 0x10000000,
    /** 10 bit Packed A2B10G10R10. This is a word-ordered format
                                                                             where a pixel is represented by a 32-bit word with R
                                                                             in the lowest 10 bits, G in the next 10 bits, B in the
                                                                             10 bits after that and A in the highest 2 bits. */
    NV_ENC_BUFFER_FORMAT_ABGR10                          = 0x20000000,
    /** Buffer format representing one-dimensional buffer. 
                                                                             This format should be used only when registering the 
                                                                             resource as output buffer, which will be used to write
                                                                             the encoded bit stream or H.264 ME only mode output. */
    NV_ENC_BUFFER_FORMAT_U8                              = 0x40000000;


/**
 * Encoding levels
 */
/** enum NV_ENC_LEVEL */
public static final int
    NV_ENC_LEVEL_AUTOSELECT         = 0,
    
    NV_ENC_LEVEL_H264_1             = 10,
    NV_ENC_LEVEL_H264_1b            = 9,
    NV_ENC_LEVEL_H264_11            = 11,
    NV_ENC_LEVEL_H264_12            = 12,
    NV_ENC_LEVEL_H264_13            = 13,
    NV_ENC_LEVEL_H264_2             = 20,
    NV_ENC_LEVEL_H264_21            = 21,
    NV_ENC_LEVEL_H264_22            = 22,
    NV_ENC_LEVEL_H264_3             = 30,
    NV_ENC_LEVEL_H264_31            = 31,
    NV_ENC_LEVEL_H264_32            = 32,
    NV_ENC_LEVEL_H264_4             = 40,
    NV_ENC_LEVEL_H264_41            = 41,
    NV_ENC_LEVEL_H264_42            = 42,
    NV_ENC_LEVEL_H264_5             = 50,
    NV_ENC_LEVEL_H264_51            = 51,
    NV_ENC_LEVEL_H264_52            = 52,
    NV_ENC_LEVEL_H264_60            = 60,
    NV_ENC_LEVEL_H264_61            = 61,
    NV_ENC_LEVEL_H264_62            = 62,

    NV_ENC_LEVEL_HEVC_1             = 30,
    NV_ENC_LEVEL_HEVC_2             = 60,
    NV_ENC_LEVEL_HEVC_21            = 63,
    NV_ENC_LEVEL_HEVC_3             = 90,
    NV_ENC_LEVEL_HEVC_31            = 93,
    NV_ENC_LEVEL_HEVC_4             = 120,
    NV_ENC_LEVEL_HEVC_41            = 123,
    NV_ENC_LEVEL_HEVC_5             = 150,
    NV_ENC_LEVEL_HEVC_51            = 153,
    NV_ENC_LEVEL_HEVC_52            = 156,
    NV_ENC_LEVEL_HEVC_6             = 180,
    NV_ENC_LEVEL_HEVC_61            = 183,
    NV_ENC_LEVEL_HEVC_62            = 186,

    NV_ENC_TIER_HEVC_MAIN           = 0,
    NV_ENC_TIER_HEVC_HIGH           = 1;

/**
 * Error Codes
 */
/** enum NVENCSTATUS */
public static final int
    /**
     * This indicates that API call returned with no errors.
     */
    NV_ENC_SUCCESS = 0,

    /**
     * This indicates that no encode capable devices were detected.
     */
    NV_ENC_ERR_NO_ENCODE_DEVICE = 1,

    /**
     * This indicates that devices pass by the client is not supported.
     */
    NV_ENC_ERR_UNSUPPORTED_DEVICE = 2,

    /**
     * This indicates that the encoder device supplied by the client is not 
     * valid.
     */
    NV_ENC_ERR_INVALID_ENCODERDEVICE = 3,

    /**
     * This indicates that device passed to the API call is invalid.
     */
    NV_ENC_ERR_INVALID_DEVICE = 4,

    /**
     * This indicates that device passed to the API call is no longer available and 
     * needs to be reinitialized. The clients need to destroy the current encoder  
     * session by freeing the allocated input output buffers and destroying the device 
     * and create a new encoding session.
     */
    NV_ENC_ERR_DEVICE_NOT_EXIST = 5,

    /**
     * This indicates that one or more of the pointers passed to the API call
     * is invalid.
     */
    NV_ENC_ERR_INVALID_PTR = 6,

    /**
     * This indicates that completion event passed in ::NvEncEncodePicture() call
     * is invalid.
     */
    NV_ENC_ERR_INVALID_EVENT = 7,

    /**
     * This indicates that one or more of the parameter passed to the API call
     * is invalid.
     */
    NV_ENC_ERR_INVALID_PARAM = 8,

    /**
     * This indicates that an API call was made in wrong sequence/order.
     */
    NV_ENC_ERR_INVALID_CALL = 9,

    /**
     * This indicates that the API call failed because it was unable to allocate 
     * enough memory to perform the requested operation.
     */
    NV_ENC_ERR_OUT_OF_MEMORY = 10,
    
    /**
     * This indicates that the encoder has not been initialized with
     * ::NvEncInitializeEncoder() or that initialization has failed.
     * The client cannot allocate input or output buffers or do any encoding
     * related operation before successfully initializing the encoder.
     */
    NV_ENC_ERR_ENCODER_NOT_INITIALIZED = 11,

    /**
     * This indicates that an unsupported parameter was passed by the client.
     */
    NV_ENC_ERR_UNSUPPORTED_PARAM = 12,

    /**
     * This indicates that the ::NvEncLockBitstream() failed to lock the output 
     * buffer. This happens when the client makes a non blocking lock call to 
     * access the output bitstream by passing NV_ENC_LOCK_BITSTREAM::doNotWait flag.
     * This is not a fatal error and client should retry the same operation after
     * few milliseconds.
     */
    NV_ENC_ERR_LOCK_BUSY = 13,

    /**
     * This indicates that the size of the user buffer passed by the client is 
     * insufficient for the requested operation.
     */
    NV_ENC_ERR_NOT_ENOUGH_BUFFER = 14,

    /**
     * This indicates that an invalid struct version was used by the client.
     */
    NV_ENC_ERR_INVALID_VERSION = 15,

    /**
     * This indicates that ::NvEncMapInputResource() API failed to map the client
     * provided input resource.
     */
    NV_ENC_ERR_MAP_FAILED = 16,

    /**
     * This indicates encode driver requires more input buffers to produce an output
     * bitstream. If this error is returned from ::NvEncEncodePicture() API, this
     * is not a fatal error. If the client is encoding with B frames then,
     * ::NvEncEncodePicture() API might be buffering the input frame for re-ordering. 
     * 
     * A client operating in synchronous mode cannot call ::NvEncLockBitstream()
     * API on the output bitstream buffer if ::NvEncEncodePicture() returned the 
     * ::NV_ENC_ERR_NEED_MORE_INPUT error code.
     * The client must continue providing input frames until encode driver returns
     * ::NV_ENC_SUCCESS. After receiving ::NV_ENC_SUCCESS status the client can call
     * ::NvEncLockBitstream() API on the output buffers in the same order in which
     * it has called ::NvEncEncodePicture().
     */
    NV_ENC_ERR_NEED_MORE_INPUT = 17,

    /**
     * This indicates that the HW encoder is busy encoding and is unable to encode  
     * the input. The client should call ::NvEncEncodePicture() again after few
     * milliseconds.
     */
    NV_ENC_ERR_ENCODER_BUSY = 18,

    /**
     * This indicates that the completion event passed in ::NvEncEncodePicture()
     * API has not been registered with encoder driver using ::NvEncRegisterAsyncEvent().
     */
    NV_ENC_ERR_EVENT_NOT_REGISTERD = 19,

    /**
     * This indicates that an unknown internal error has occurred.
     */
    NV_ENC_ERR_GENERIC = 20,
    
    /**
     * This indicates that the client is attempting to use a feature
     * that is not available for the license type for the current system.
     */
    NV_ENC_ERR_INCOMPATIBLE_CLIENT_KEY = 21,
    
    /**
     * This indicates that the client is attempting to use a feature
     * that is not implemented for the current version.
     */
    NV_ENC_ERR_UNIMPLEMENTED = 22,

    /**
     * This indicates that the ::NvEncRegisterResource API failed to register the resource.
     */
    NV_ENC_ERR_RESOURCE_REGISTER_FAILED = 23,

    /**
     * This indicates that the client is attempting to unregister a resource
     * that has not been successfully registered.
     */
    NV_ENC_ERR_RESOURCE_NOT_REGISTERED = 24,

    /**
     * This indicates that the client is attempting to unmap a resource
     * that has not been successfully mapped.
     */
    NV_ENC_ERR_RESOURCE_NOT_MAPPED = 25;

/**
 * Encode Picture encode flags.
 */
/** enum NV_ENC_PIC_FLAGS */
public static final int
    /** Encode the current picture as an Intra picture */
    NV_ENC_PIC_FLAG_FORCEINTRA         = 0x1,
    /** Encode the current picture as an IDR picture. 
                                                     This flag is only valid when Picture type decision is taken by the Encoder
                                                     [_NV_ENC_INITIALIZE_PARAMS::enablePTD == 1]. */
    NV_ENC_PIC_FLAG_FORCEIDR           = 0x2,
    /** Write the sequence and picture header in encoded bitstream of the current picture */
    NV_ENC_PIC_FLAG_OUTPUT_SPSPPS      = 0x4,
    /** Indicates end of the input stream */
    NV_ENC_PIC_FLAG_EOS                = 0x8;

/**
 * Memory heap to allocate input and output buffers.
 */
/** enum NV_ENC_MEMORY_HEAP */
public static final int
    /** Memory heap to be decided by the encoder driver based on the usage */
    NV_ENC_MEMORY_HEAP_AUTOSELECT      = 0,
    /** Memory heap is in local video memory */
    NV_ENC_MEMORY_HEAP_VID             = 1,
    /** Memory heap is in cached system memory */
    NV_ENC_MEMORY_HEAP_SYSMEM_CACHED   = 2,
    /** Memory heap is in uncached system memory */
    NV_ENC_MEMORY_HEAP_SYSMEM_UNCACHED = 3;

/**
 * B-frame used as reference modes
 */
/** enum NV_ENC_BFRAME_REF_MODE */
public static final int
    /** B frame is not used for reference */
    NV_ENC_BFRAME_REF_MODE_DISABLED = 0x0,
    /** Each B-frame will be used for reference. currently not supported for H.264 */
    NV_ENC_BFRAME_REF_MODE_EACH     = 0x1,
    /** Only(Number of B-frame)/2 th B-frame will be used for reference */
    NV_ENC_BFRAME_REF_MODE_MIDDLE   = 0x2;

/**
 * H.264 entropy coding modes.
 */
/** enum NV_ENC_H264_ENTROPY_CODING_MODE */
public static final int
    /** Entropy coding mode is auto selected by the encoder driver */
    NV_ENC_H264_ENTROPY_CODING_MODE_AUTOSELECT = 0x0,
    /** Entropy coding mode is CABAC */
    NV_ENC_H264_ENTROPY_CODING_MODE_CABAC      = 0x1,
    /** Entropy coding mode is CAVLC */
    NV_ENC_H264_ENTROPY_CODING_MODE_CAVLC      = 0x2;

/**
 * H.264 specific BDirect modes
 */
/** enum NV_ENC_H264_BDIRECT_MODE */
public static final int
    /** BDirect mode is auto selected by the encoder driver */
    NV_ENC_H264_BDIRECT_MODE_AUTOSELECT = 0x0,
    /** Disable BDirect mode */
    NV_ENC_H264_BDIRECT_MODE_DISABLE    = 0x1,
    /** Temporal BDirect mode */
    NV_ENC_H264_BDIRECT_MODE_TEMPORAL   = 0x2,
    /** Spatial BDirect mode */
    NV_ENC_H264_BDIRECT_MODE_SPATIAL    = 0x3;

/**
 * H.264 specific FMO usage
 */
/** enum NV_ENC_H264_FMO_MODE */
public static final int
    /** FMO usage is auto selected by the encoder driver */
    NV_ENC_H264_FMO_AUTOSELECT          = 0x0,
    /** Enable FMO */
    NV_ENC_H264_FMO_ENABLE              = 0x1,
    /** Disable FMO */
    NV_ENC_H264_FMO_DISABLE             = 0x2;

/**
 * H.264 specific Adaptive Transform modes
 */
/** enum NV_ENC_H264_ADAPTIVE_TRANSFORM_MODE */
public static final int
    /** Adaptive Transform 8x8 mode is auto selected by the encoder driver*/
    NV_ENC_H264_ADAPTIVE_TRANSFORM_AUTOSELECT = 0x0,
    /** Adaptive Transform 8x8 mode disabled */
    NV_ENC_H264_ADAPTIVE_TRANSFORM_DISABLE    = 0x1,
    /** Adaptive Transform 8x8 mode should be used */
    NV_ENC_H264_ADAPTIVE_TRANSFORM_ENABLE     = 0x2;

/**
 * Stereo frame packing modes.
 */
/** enum NV_ENC_STEREO_PACKING_MODE */
public static final int
    /** No Stereo packing required */
    NV_ENC_STEREO_PACKING_MODE_NONE             = 0x0,
    /** Checkerboard mode for packing stereo frames */
    NV_ENC_STEREO_PACKING_MODE_CHECKERBOARD     = 0x1,
    /** Column Interleave mode for packing stereo frames */
    NV_ENC_STEREO_PACKING_MODE_COLINTERLEAVE    = 0x2,
    /** Row Interleave mode for packing stereo frames */
    NV_ENC_STEREO_PACKING_MODE_ROWINTERLEAVE    = 0x3,
    /** Side-by-side mode for packing stereo frames */
    NV_ENC_STEREO_PACKING_MODE_SIDEBYSIDE       = 0x4,
    /** Top-Bottom mode for packing stereo frames */
    NV_ENC_STEREO_PACKING_MODE_TOPBOTTOM        = 0x5,
    /** Frame Sequential mode for packing stereo frames */
    NV_ENC_STEREO_PACKING_MODE_FRAMESEQ         = 0x6;

/**
 *  Input Resource type
 */
/** enum NV_ENC_INPUT_RESOURCE_TYPE */
public static final int
    /** input resource type is a directx9 surface*/
    NV_ENC_INPUT_RESOURCE_TYPE_DIRECTX          = 0x0,
    /** input resource type is a cuda device pointer surface*/
    NV_ENC_INPUT_RESOURCE_TYPE_CUDADEVICEPTR    = 0x1,
    /** input resource type is a cuda array surface.
                                                              This array must be a 2D array and the CUDA_ARRAY3D_SURFACE_LDST
                                                              flag must have been specified when creating it. */
    NV_ENC_INPUT_RESOURCE_TYPE_CUDAARRAY        = 0x2,
    /** input resource type is an OpenGL texture */
    NV_ENC_INPUT_RESOURCE_TYPE_OPENGL_TEX       = 0x3;

/**
 *  Buffer usage
 */
/** enum NV_ENC_BUFFER_USAGE */
public static final int
    /** Registered surface will be used for input image */
    NV_ENC_INPUT_IMAGE              = 0x0,
    /** Registered surface will be used for output of H.264 ME only mode. 
                                                         This buffer usage type is not supported for HEVC ME only mode. */
    NV_ENC_OUTPUT_MOTION_VECTOR     = 0x1,
    /** Registered surface will be used for output bitstream in encoding */
    NV_ENC_OUTPUT_BITSTREAM         = 0x2;

/**
 *  Encoder Device type
 */
/** enum NV_ENC_DEVICE_TYPE */
public static final int
    /** encode device type is a directx9 device */
    NV_ENC_DEVICE_TYPE_DIRECTX          = 0x0,
    /** encode device type is a cuda device */
    NV_ENC_DEVICE_TYPE_CUDA             = 0x1,
    /** encode device type is an OpenGL device.
                                                      Use of this device type is supported only on Linux */
    NV_ENC_DEVICE_TYPE_OPENGL           = 0x2;

/**
 * Number of reference frames
 */
/** enum NV_ENC_NUM_REF_FRAMES */
public static final int
    /** Number of reference frames is auto selected by the encoder driver */
    NV_ENC_NUM_REF_FRAMES_AUTOSELECT       = 0x0,
    /** Number of reference frames equal to 1 */
    NV_ENC_NUM_REF_FRAMES_1                = 0x1,
    /** Number of reference frames equal to 2 */
    NV_ENC_NUM_REF_FRAMES_2                = 0x2,
    /** Number of reference frames equal to 3 */
    NV_ENC_NUM_REF_FRAMES_3                = 0x3,
    /** Number of reference frames equal to 4 */
    NV_ENC_NUM_REF_FRAMES_4                = 0x4,
    /** Number of reference frames equal to 5 */
    NV_ENC_NUM_REF_FRAMES_5                = 0x5,
    /** Number of reference frames equal to 6 */
    NV_ENC_NUM_REF_FRAMES_6                = 0x6,
    /** Number of reference frames equal to 7 */
    NV_ENC_NUM_REF_FRAMES_7                = 0x7;

/**
 * Encoder capabilities enumeration.
 */
/** enum NV_ENC_CAPS */
public static final int
    /**
     * Maximum number of B-Frames supported.
     */
    NV_ENC_CAPS_NUM_MAX_BFRAMES = 0,

    /**
     * Rate control modes supported.
     * \n The API return value is a bitmask of the values in NV_ENC_PARAMS_RC_MODE.
     */
    NV_ENC_CAPS_SUPPORTED_RATECONTROL_MODES = 1,

    /** 
     * Indicates HW support for field mode encoding.
     * \n 0 : Interlaced mode encoding is not supported.
     * \n 1 : Interlaced field mode encoding is supported.
     * \n 2 : Interlaced frame encoding and field mode encoding are both supported.
     */
     NV_ENC_CAPS_SUPPORT_FIELD_ENCODING = 2,

    /**
     * Indicates HW support for monochrome mode encoding.
     * \n 0 : Monochrome mode not supported.
     * \n 1 : Monochrome mode supported.
     */
    NV_ENC_CAPS_SUPPORT_MONOCHROME = 3,

    /**
     * Indicates HW support for FMO.
     * \n 0 : FMO not supported.
     * \n 1 : FMO supported.
     */
    NV_ENC_CAPS_SUPPORT_FMO = 4,

    /**
     * Indicates HW capability for Quarter pel motion estimation.
     * \n 0 : Quarter-Pel Motion Estimation not supported.
     * \n 1 : Quarter-Pel Motion Estimation supported.
     */
    NV_ENC_CAPS_SUPPORT_QPELMV = 5,

    /**
     * H.264 specific. Indicates HW support for BDirect modes.
     * \n 0 : BDirect mode encoding not supported.
     * \n 1 : BDirect mode encoding supported.
     */
    NV_ENC_CAPS_SUPPORT_BDIRECT_MODE = 6,

    /**
     * H264 specific. Indicates HW support for CABAC entropy coding mode.
     * \n 0 : CABAC entropy coding not supported.
     * \n 1 : CABAC entropy coding supported.
     */
    NV_ENC_CAPS_SUPPORT_CABAC = 7,

    /**
     * Indicates HW support for Adaptive Transform.
     * \n 0 : Adaptive Transform not supported.
     * \n 1 : Adaptive Transform supported.
     */
    NV_ENC_CAPS_SUPPORT_ADAPTIVE_TRANSFORM = 8,

    /**
     * Indicates HW support for Multi View Coding.
     * \n 0 : Multi View Coding not supported.
     * \n 1 : Multi View Coding supported.
     */
    NV_ENC_CAPS_SUPPORT_STEREO_MVC = 9,

    /**
     * Indicates HW support for encoding Temporal layers.
     * \n 0 : Encoding Temporal layers not supported.
     * \n 1 : Encoding Temporal layers supported.
     */
    NV_ENC_CAPS_NUM_MAX_TEMPORAL_LAYERS = 10,

    /**
     * Indicates HW support for Hierarchical P frames.
     * \n 0 : Hierarchical P frames not supported.
     * \n 1 : Hierarchical P frames supported.
     */
    NV_ENC_CAPS_SUPPORT_HIERARCHICAL_PFRAMES = 11,

    /**
     * Indicates HW support for Hierarchical B frames.
     * \n 0 : Hierarchical B frames not supported.
     * \n 1 : Hierarchical B frames supported.
     */
    NV_ENC_CAPS_SUPPORT_HIERARCHICAL_BFRAMES = 12,

    /**
     * Maximum Encoding level supported (See ::NV_ENC_LEVEL for details).
     */
    NV_ENC_CAPS_LEVEL_MAX = 13,
 
    /**
     * Minimum Encoding level supported (See ::NV_ENC_LEVEL for details).
     */
    NV_ENC_CAPS_LEVEL_MIN = 14,

    /**
     * Indicates HW support for separate colour plane encoding.
     * \n 0 : Separate colour plane encoding not supported.
     * \n 1 : Separate colour plane encoding supported.
     */
    NV_ENC_CAPS_SEPARATE_COLOUR_PLANE = 15,
    
    /**
     * Maximum output width supported.
     */
    NV_ENC_CAPS_WIDTH_MAX = 16,
    
    /**
     * Maximum output height supported.
     */
    NV_ENC_CAPS_HEIGHT_MAX = 17,

    /**
     * Indicates Temporal Scalability Support.
     * \n 0 : Temporal SVC encoding not supported.
     * \n 1 : Temporal SVC encoding supported.
     */
    NV_ENC_CAPS_SUPPORT_TEMPORAL_SVC = 18,

    /**
     * Indicates Dynamic Encode Resolution Change Support.
     * Support added from NvEncodeAPI version 2.0.
     * \n 0 : Dynamic Encode Resolution Change not supported.
     * \n 1 : Dynamic Encode Resolution Change supported.
     */
    NV_ENC_CAPS_SUPPORT_DYN_RES_CHANGE = 19,

    /**
     * Indicates Dynamic Encode Bitrate Change Support.
     * Support added from NvEncodeAPI version 2.0.
     * \n 0 : Dynamic Encode bitrate change not supported.
     * \n 1 : Dynamic Encode bitrate change supported.
     */
    NV_ENC_CAPS_SUPPORT_DYN_BITRATE_CHANGE = 20,
        
    /**
     * Indicates Forcing Constant QP On The Fly Support.
     * Support added from NvEncodeAPI version 2.0.
     * \n 0 : Forcing constant QP on the fly not supported.
     * \n 1 : Forcing constant QP on the fly supported.
     */
    NV_ENC_CAPS_SUPPORT_DYN_FORCE_CONSTQP = 21,

    /**
     * Indicates Dynamic rate control mode Change Support.    
     * \n 0 : Dynamic rate control mode change not supported.
     * \n 1 : Dynamic rate control mode change supported.
     */
    NV_ENC_CAPS_SUPPORT_DYN_RCMODE_CHANGE = 22,

    /**
     * Indicates Subframe readback support for slice-based encoding. If this feature is supported, it can be enabled by setting enableSubFrameWrite = 1.
     * \n 0 : Subframe readback not supported.
     * \n 1 : Subframe readback supported.
     */
    NV_ENC_CAPS_SUPPORT_SUBFRAME_READBACK = 23,

    /**
     * Indicates Constrained Encoding mode support.
     * Support added from NvEncodeAPI version 2.0.
     * \n 0 : Constrained encoding mode not supported.
     * \n 1 : Constrained encoding mode supported.
     * If this mode is supported client can enable this during initialization.
     * Client can then force a picture to be coded as constrained picture where
     * in-loop filtering is disabled across slice boundaries and prediction vectors for inter
     * macroblocks in each slice will be restricted to the slice region.
     */
    NV_ENC_CAPS_SUPPORT_CONSTRAINED_ENCODING = 24,

    /**
     * Indicates Intra Refresh Mode Support.
     * Support added from NvEncodeAPI version 2.0.
     * \n 0 : Intra Refresh Mode not supported.
     * \n 1 : Intra Refresh Mode supported.
     */
    NV_ENC_CAPS_SUPPORT_INTRA_REFRESH = 25,

    /**
     * Indicates Custom VBV Buffer Size support. It can be used for capping frame size.
     * Support added from NvEncodeAPI version 2.0.
     * \n 0 : Custom VBV buffer size specification from client, not supported.
     * \n 1 : Custom VBV buffer size specification from client, supported.
     */
    NV_ENC_CAPS_SUPPORT_CUSTOM_VBV_BUF_SIZE = 26,

    /**
     * Indicates Dynamic Slice Mode Support.
     * Support added from NvEncodeAPI version 2.0.
     * \n 0 : Dynamic Slice Mode not supported.
     * \n 1 : Dynamic Slice Mode supported.
     */
    NV_ENC_CAPS_SUPPORT_DYNAMIC_SLICE_MODE = 27,

    /**
     * Indicates Reference Picture Invalidation Support.
     * Support added from NvEncodeAPI version 2.0.
     * \n 0 : Reference Picture Invalidation not supported.
     * \n 1 : Reference Picture Invalidation supported.
     */
    NV_ENC_CAPS_SUPPORT_REF_PIC_INVALIDATION = 28,
    
    /**
     * Indicates support for Pre-Processing.
     * The API return value is a bitmask of the values defined in ::NV_ENC_PREPROC_FLAGS
     */
    NV_ENC_CAPS_PREPROC_SUPPORT = 29,

    /**
    * Indicates support Async mode.
    * \n 0 : Async Encode mode not supported.
    * \n 1 : Async Encode mode supported.
    */
    NV_ENC_CAPS_ASYNC_ENCODE_SUPPORT = 30,

    /**
     * Maximum MBs per frame supported.
     */
    NV_ENC_CAPS_MB_NUM_MAX = 31,

    /**
     * Maximum aggregate throughput in MBs per sec.
     */
    NV_ENC_CAPS_MB_PER_SEC_MAX = 32,

    /**
     * Indicates HW support for YUV444 mode encoding.
     * \n 0 : YUV444 mode encoding not supported.
     * \n 1 : YUV444 mode encoding supported.
     */
    NV_ENC_CAPS_SUPPORT_YUV444_ENCODE = 33,

    /**
     * Indicates HW support for lossless encoding.
     * \n 0 : lossless encoding not supported.
     * \n 1 : lossless encoding supported.
     */
    NV_ENC_CAPS_SUPPORT_LOSSLESS_ENCODE = 34,
    
     /**
     * Indicates HW support for Sample Adaptive Offset.
     * \n 0 : SAO not supported.
     * \n 1 : SAO encoding supported.
     */
    NV_ENC_CAPS_SUPPORT_SAO = 35,

    /**
     * Indicates HW support for Motion Estimation Only Mode.
     * \n 0 : MEOnly Mode not supported.
     * \n 1 : MEOnly Mode supported for I and P frames.
     * \n 2 : MEOnly Mode supported for I, P and B frames.
     */
    NV_ENC_CAPS_SUPPORT_MEONLY_MODE = 36,

    /**
     * Indicates HW support for lookahead encoding (enableLookahead=1).
     * \n 0 : Lookahead not supported.
     * \n 1 : Lookahead supported.
     */
    NV_ENC_CAPS_SUPPORT_LOOKAHEAD = 37,

    /**
     * Indicates HW support for temporal AQ encoding (enableTemporalAQ=1).
     * \n 0 : Temporal AQ not supported.
     * \n 1 : Temporal AQ supported.
     */
    NV_ENC_CAPS_SUPPORT_TEMPORAL_AQ = 38,
    /**
     * Indicates HW support for 10 bit encoding.
     * \n 0 : 10 bit encoding not supported.
     * \n 1 : 10 bit encoding supported.
     */
    NV_ENC_CAPS_SUPPORT_10BIT_ENCODE = 39,
    /**
     * Maximum number of Long Term Reference frames supported
     */
    NV_ENC_CAPS_NUM_MAX_LTR_FRAMES = 40,

    /**
     * Indicates HW support for Weighted Prediction.
     * \n 0 : Weighted Prediction not supported.
     * \n 1 : Weighted Prediction supported.
     */
    NV_ENC_CAPS_SUPPORT_WEIGHTED_PREDICTION = 41,


    /**
     * On managed (vGPU) platforms (Windows only), this API, in conjunction with other GRID Management APIs, can be used 
     * to estimate the residual capacity of the hardware encoder on the GPU as a percentage of the total available encoder capacity. 
     * This API can be called at any time; i.e. during the encode session or before opening the encode session. 
     * If the available encoder capacity is returned as zero, applications may choose to switch to software encoding 
     * and continue to call this API (e.g. polling once per second) until capacity becomes available.
     *
     * On bare metal (non-virtualized GPU) and linux platforms, this API always returns 100.
     */
    NV_ENC_CAPS_DYNAMIC_QUERY_ENCODER_CAPACITY = 42,

     /**
     * Indicates B as reference support.
     * \n 0 : B as reference is not supported.
     * \n 1 : each B-Frame as reference is supported.
     * \n 2 : only Middle B-frame as reference is supported.
     */
    NV_ENC_CAPS_SUPPORT_BFRAME_REF_MODE = 43,

    /**
     * Indicates HW support for Emphasis Level Map based delta QP computation.
     * \n 0 : Emphasis Level Map based delta QP not supported.
     * \n 1 : Emphasis Level Map based delta QP is supported.
     */
    NV_ENC_CAPS_SUPPORT_EMPHASIS_LEVEL_MAP = 44,

    /**
     * Minimum input width supported.
     */
    NV_ENC_CAPS_WIDTH_MIN = 45,

    /**
     * Minimum input height supported.
     */
    NV_ENC_CAPS_HEIGHT_MIN = 46,

    /**
     * Indicates HW support for multiple reference frames.
     */
    NV_ENC_CAPS_SUPPORT_MULTIPLE_REF_FRAMES = 47,

    /**
     * Indicates HW support for HEVC with alpha encoding.
     * \n 0 : HEVC with alpha encoding not supported.
     * \n 1 : HEVC with alpha encoding is supported.
     */
    NV_ENC_CAPS_SUPPORT_ALPHA_LAYER_ENCODING = 48,

     /**
     * Indicates number of Encoding engines present on GPU.
     */
    NV_ENC_CAPS_NUM_ENCODER_ENGINES = 49,

    /**
     * Indicates single slice intra refresh support.
     */
    NV_ENC_CAPS_SINGLE_SLICE_INTRA_REFRESH = 50,

     /**
     * Reserved - Not to be used by clients.
     */
    NV_ENC_CAPS_EXPOSED_COUNT = 51;

/**
 *  HEVC CU SIZE
 */
/** enum NV_ENC_HEVC_CUSIZE */
public static final int
    NV_ENC_HEVC_CUSIZE_AUTOSELECT = 0,
    NV_ENC_HEVC_CUSIZE_8x8        = 1,
    NV_ENC_HEVC_CUSIZE_16x16      = 2,
    NV_ENC_HEVC_CUSIZE_32x32      = 3,
    NV_ENC_HEVC_CUSIZE_64x64      = 4;
// Targeting ..\nvencodeapi\NV_ENC_CAPS_PARAM.java



/** NV_ENC_CAPS_PARAM struct version. */
public static native @MemberGetter int NV_ENC_CAPS_PARAM_VER();
public static final int NV_ENC_CAPS_PARAM_VER = NV_ENC_CAPS_PARAM_VER();
// Targeting ..\nvencodeapi\NV_ENC_ENCODE_OUT_PARAMS.java



/** NV_ENC_ENCODE_OUT_PARAMS struct version. */
public static native @MemberGetter int NV_ENC_ENCODE_OUT_PARAMS_VER();
public static final int NV_ENC_ENCODE_OUT_PARAMS_VER = NV_ENC_ENCODE_OUT_PARAMS_VER();
// Targeting ..\nvencodeapi\NV_ENC_CREATE_INPUT_BUFFER.java



/** NV_ENC_CREATE_INPUT_BUFFER struct version. */
public static native @MemberGetter int NV_ENC_CREATE_INPUT_BUFFER_VER();
public static final int NV_ENC_CREATE_INPUT_BUFFER_VER = NV_ENC_CREATE_INPUT_BUFFER_VER();
// Targeting ..\nvencodeapi\NV_ENC_CREATE_BITSTREAM_BUFFER.java



/** NV_ENC_CREATE_BITSTREAM_BUFFER struct version. */
public static native @MemberGetter int NV_ENC_CREATE_BITSTREAM_BUFFER_VER();
public static final int NV_ENC_CREATE_BITSTREAM_BUFFER_VER = NV_ENC_CREATE_BITSTREAM_BUFFER_VER();
// Targeting ..\nvencodeapi\NV_ENC_MVECTOR.java


// Targeting ..\nvencodeapi\NV_ENC_H264_MV_DATA.java


// Targeting ..\nvencodeapi\NV_ENC_HEVC_MV_DATA.java


// Targeting ..\nvencodeapi\NV_ENC_CREATE_MV_BUFFER.java



/** NV_ENC_CREATE_MV_BUFFER struct version*/
public static native @MemberGetter int NV_ENC_CREATE_MV_BUFFER_VER();
public static final int NV_ENC_CREATE_MV_BUFFER_VER = NV_ENC_CREATE_MV_BUFFER_VER();
// Targeting ..\nvencodeapi\NV_ENC_QP.java


// Targeting ..\nvencodeapi\NV_ENC_RC_PARAMS.java



/** macro for constructing the version field of ::_NV_ENC_RC_PARAMS */
public static native @MemberGetter int NV_ENC_RC_PARAMS_VER();
public static final int NV_ENC_RC_PARAMS_VER = NV_ENC_RC_PARAMS_VER();
// Targeting ..\nvencodeapi\NV_ENC_CONFIG_H264_VUI_PARAMETERS.java


// Targeting ..\nvencodeapi\NVENC_EXTERNAL_ME_HINT_COUNTS_PER_BLOCKTYPE.java


// Targeting ..\nvencodeapi\NVENC_EXTERNAL_ME_HINT.java


// Targeting ..\nvencodeapi\NV_ENC_CONFIG_H264.java


// Targeting ..\nvencodeapi\NV_ENC_CONFIG_HEVC.java


// Targeting ..\nvencodeapi\NV_ENC_CONFIG_H264_MEONLY.java


// Targeting ..\nvencodeapi\NV_ENC_CONFIG_HEVC_MEONLY.java


// Targeting ..\nvencodeapi\NV_ENC_CODEC_CONFIG.java


// Targeting ..\nvencodeapi\NV_ENC_CONFIG.java



/** macro for constructing the version field of ::_NV_ENC_CONFIG */
public static native @MemberGetter int NV_ENC_CONFIG_VER();
public static final int NV_ENC_CONFIG_VER = NV_ENC_CONFIG_VER();

/**
 *  Tuning information of NVENC encoding (TuningInfo is not applicable to H264 and HEVC MEOnly mode).
 */
/** enum NV_ENC_TUNING_INFO */
public static final int
    /** Undefined tuningInfo. Invalid value for encoding. */
    NV_ENC_TUNING_INFO_UNDEFINED         = 0,
    /** Tune presets for latency tolerant encoding.*/
    NV_ENC_TUNING_INFO_HIGH_QUALITY      = 1,
    /** Tune presets for low latency streaming.*/
    NV_ENC_TUNING_INFO_LOW_LATENCY       = 2,
    /** Tune presets for ultra low latency streaming.*/
    NV_ENC_TUNING_INFO_ULTRA_LOW_LATENCY = 3,
    /** Tune presets for lossless encoding.*/
    NV_ENC_TUNING_INFO_LOSSLESS          = 4,
    /** Count number of tuningInfos. Invalid value. */
    NV_ENC_TUNING_INFO_COUNT = 5;
// Targeting ..\nvencodeapi\NV_ENC_INITIALIZE_PARAMS.java



/** macro for constructing the version field of ::_NV_ENC_INITIALIZE_PARAMS */
public static native @MemberGetter int NV_ENC_INITIALIZE_PARAMS_VER();
public static final int NV_ENC_INITIALIZE_PARAMS_VER = NV_ENC_INITIALIZE_PARAMS_VER();
// Targeting ..\nvencodeapi\NV_ENC_RECONFIGURE_PARAMS.java



/** macro for constructing the version field of ::_NV_ENC_RECONFIGURE_PARAMS */
public static native @MemberGetter int NV_ENC_RECONFIGURE_PARAMS_VER();
public static final int NV_ENC_RECONFIGURE_PARAMS_VER = NV_ENC_RECONFIGURE_PARAMS_VER();
// Targeting ..\nvencodeapi\NV_ENC_PRESET_CONFIG.java



/** macro for constructing the version field of ::_NV_ENC_PRESET_CONFIG */
public static native @MemberGetter int NV_ENC_PRESET_CONFIG_VER();
public static final int NV_ENC_PRESET_CONFIG_VER = NV_ENC_PRESET_CONFIG_VER();
// Targeting ..\nvencodeapi\NV_ENC_PIC_PARAMS_MVC.java



/** macro for constructing the version field of ::_NV_ENC_PIC_PARAMS_MVC */
public static native @MemberGetter int NV_ENC_PIC_PARAMS_MVC_VER();
public static final int NV_ENC_PIC_PARAMS_MVC_VER = NV_ENC_PIC_PARAMS_MVC_VER();
// Targeting ..\nvencodeapi\NV_ENC_PIC_PARAMS_H264_EXT.java


// Targeting ..\nvencodeapi\NV_ENC_SEI_PAYLOAD.java



// #define NV_ENC_H264_SEI_PAYLOAD NV_ENC_SEI_PAYLOAD
// Targeting ..\nvencodeapi\NV_ENC_PIC_PARAMS_H264.java


// Targeting ..\nvencodeapi\NV_ENC_PIC_PARAMS_HEVC.java


// Targeting ..\nvencodeapi\NV_ENC_CODEC_PIC_PARAMS.java


// Targeting ..\nvencodeapi\NV_ENC_PIC_PARAMS.java



/** Macro for constructing the version field of ::_NV_ENC_PIC_PARAMS */
public static native @MemberGetter int NV_ENC_PIC_PARAMS_VER();
public static final int NV_ENC_PIC_PARAMS_VER = NV_ENC_PIC_PARAMS_VER();
// Targeting ..\nvencodeapi\NV_ENC_MEONLY_PARAMS.java



/** NV_ENC_MEONLY_PARAMS struct version*/
public static native @MemberGetter int NV_ENC_MEONLY_PARAMS_VER();
public static final int NV_ENC_MEONLY_PARAMS_VER = NV_ENC_MEONLY_PARAMS_VER();
// Targeting ..\nvencodeapi\NV_ENC_LOCK_BITSTREAM.java



/** Macro for constructing the version field of ::_NV_ENC_LOCK_BITSTREAM */
public static native @MemberGetter int NV_ENC_LOCK_BITSTREAM_VER();
public static final int NV_ENC_LOCK_BITSTREAM_VER = NV_ENC_LOCK_BITSTREAM_VER();
// Targeting ..\nvencodeapi\NV_ENC_LOCK_INPUT_BUFFER.java



/** Macro for constructing the version field of ::_NV_ENC_LOCK_INPUT_BUFFER */
public static native @MemberGetter int NV_ENC_LOCK_INPUT_BUFFER_VER();
public static final int NV_ENC_LOCK_INPUT_BUFFER_VER = NV_ENC_LOCK_INPUT_BUFFER_VER();
// Targeting ..\nvencodeapi\NV_ENC_MAP_INPUT_RESOURCE.java



/** Macro for constructing the version field of ::_NV_ENC_MAP_INPUT_RESOURCE */
public static native @MemberGetter int NV_ENC_MAP_INPUT_RESOURCE_VER();
public static final int NV_ENC_MAP_INPUT_RESOURCE_VER = NV_ENC_MAP_INPUT_RESOURCE_VER();
// Targeting ..\nvencodeapi\NV_ENC_INPUT_RESOURCE_OPENGL_TEX.java


// Targeting ..\nvencodeapi\NV_ENC_FENCE_POINT_D3D12.java


// Targeting ..\nvencodeapi\NV_ENC_INPUT_RESOURCE_D3D12.java


// Targeting ..\nvencodeapi\NV_ENC_OUTPUT_RESOURCE_D3D12.java


// Targeting ..\nvencodeapi\NV_ENC_REGISTER_RESOURCE.java



/** Macro for constructing the version field of ::_NV_ENC_REGISTER_RESOURCE */
public static native @MemberGetter int NV_ENC_REGISTER_RESOURCE_VER();
public static final int NV_ENC_REGISTER_RESOURCE_VER = NV_ENC_REGISTER_RESOURCE_VER();
// Targeting ..\nvencodeapi\NV_ENC_STAT.java



/** Macro for constructing the version field of ::_NV_ENC_STAT */
public static native @MemberGetter int NV_ENC_STAT_VER();
public static final int NV_ENC_STAT_VER = NV_ENC_STAT_VER();
// Targeting ..\nvencodeapi\NV_ENC_SEQUENCE_PARAM_PAYLOAD.java



/** Macro for constructing the version field of ::_NV_ENC_SEQUENCE_PARAM_PAYLOAD */
public static native @MemberGetter int NV_ENC_SEQUENCE_PARAM_PAYLOAD_VER();
public static final int NV_ENC_SEQUENCE_PARAM_PAYLOAD_VER = NV_ENC_SEQUENCE_PARAM_PAYLOAD_VER();
// Targeting ..\nvencodeapi\NV_ENC_EVENT_PARAMS.java



/** Macro for constructing the version field of ::_NV_ENC_EVENT_PARAMS */
public static native @MemberGetter int NV_ENC_EVENT_PARAMS_VER();
public static final int NV_ENC_EVENT_PARAMS_VER = NV_ENC_EVENT_PARAMS_VER();
// Targeting ..\nvencodeapi\NV_ENC_OPEN_ENCODE_SESSION_EX_PARAMS.java


/** Macro for constructing the version field of ::_NV_ENC_OPEN_ENCODE_SESSIONEX_PARAMS */
public static native @MemberGetter int NV_ENC_OPEN_ENCODE_SESSION_EX_PARAMS_VER();
public static final int NV_ENC_OPEN_ENCODE_SESSION_EX_PARAMS_VER = NV_ENC_OPEN_ENCODE_SESSION_EX_PARAMS_VER();

/** \} */ /* END ENCODER_STRUCTURE */


/**
 * \addtogroup ENCODE_FUNC NvEncodeAPI Functions
 * \{
 */

// NvEncOpenEncodeSession
/**
 * \brief Opens an encoding session.
 * 
 * Deprecated.
 *
 * @return
 * ::NV_ENC_ERR_INVALID_CALL\n
 *
 */


// NvEncGetEncodeGuidCount
/**
 * \brief Retrieves the number of supported encode GUIDs.
 *
 * The function returns the number of codec GUIDs supported by the NvEncodeAPI
 * interface.
 *  
 * @param encoder [in]  
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeGUIDCount [out] 
 *   Number of supported encode GUIDs.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncGetEncodeGUIDs
/**
 * \brief Retrieves an array of supported encoder codec GUIDs.
 *
 * The function returns an array of codec GUIDs supported by the NvEncodeAPI interface.
 * The client must allocate an array where the NvEncodeAPI interface can
 * fill the supported GUIDs and pass the pointer in \p *GUIDs parameter.
 * The size of the array can be determined by using ::NvEncGetEncodeGUIDCount() API.
 * The Nvidia Encoding interface returns the number of codec GUIDs it has actually
 * filled in the GUID array in the \p GUIDCount parameter.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param guidArraySize [in]
 *   Number of GUIDs to retrieved. Should be set to the number retrieved using
 *   ::NvEncGetEncodeGUIDCount.
 * @param GUIDs [out]
 *   Array of supported Encode GUIDs.
 * @param GUIDCount [out]
 *   Number of supported Encode GUIDs.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncGetEncodeProfileGuidCount
/**
 * \brief Retrieves the number of supported profile GUIDs.
 *
 * The function returns the number of profile GUIDs supported for a given codec. 
 * The client must first enumerate the codec GUIDs supported by the NvEncodeAPI 
 * interface. After determining the codec GUID, it can query the NvEncodeAPI
 * interface to determine the number of profile GUIDs supported for a particular
 * codec GUID.
 *
 * @param encoder [in]  
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeGUID [in] 
 *   The codec GUID for which the profile GUIDs are being enumerated.
 * @param encodeProfileGUIDCount [out]
 *   Number of encode profiles supported for the given encodeGUID.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncGetEncodeProfileGUIDs
/**
 * \brief Retrieves an array of supported encode profile GUIDs.
 *
 * The function returns an array of supported profile GUIDs for a particular
 * codec GUID. The client must allocate an array where the NvEncodeAPI interface
 * can populate the profile GUIDs. The client can determine the array size using 
 * ::NvEncGetEncodeProfileGUIDCount() API. The client must also validiate that the
 * NvEncodeAPI interface supports the GUID the client wants to pass as \p encodeGUID
 * parameter.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeGUID [in]
 *   The encode GUID whose profile GUIDs are being enumerated.
 * @param guidArraySize [in]
 *   Number of GUIDs to be retrieved. Should be set to the number retrieved using 
 *   ::NvEncGetEncodeProfileGUIDCount.
 * @param profileGUIDs [out]
 *   Array of supported Encode Profile GUIDs
 * @param GUIDCount [out]
 *   Number of valid encode profile GUIDs in \p profileGUIDs array.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncGetInputFormatCount
/**
 * \brief Retrieve the number of supported Input formats.
 *
 * The function returns the number of supported input formats. The client must
 * query the NvEncodeAPI interface to determine the supported input formats
 * before creating the input surfaces.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeGUID [in]
 *   Encode GUID, corresponding to which the number of supported input formats 
 *   is to be retrieved.
 * @param inputFmtCount [out]
 *   Number of input formats supported for specified Encode GUID.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 */



// NvEncGetInputFormats
/**
 * \brief Retrieves an array of supported Input formats
 *
 * Returns an array of supported input formats  The client must use the input 
 * format to create input surface using ::NvEncCreateInputBuffer() API.
 * 
 * @param encoder [in] 
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeGUID [in]
 *   Encode GUID, corresponding to which the number of supported input formats 
 *   is to be retrieved.
 *@param inputFmtArraySize [in]
 *   Size input format count array passed in \p inputFmts.
 *@param inputFmts [out]
 *   Array of input formats supported for this Encode GUID.
 *@param inputFmtCount [out]
 *   The number of valid input format types returned by the NvEncodeAPI
 *   interface in \p inputFmts array.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncGetEncodeCaps
/**
 * \brief Retrieves the capability value for a specified encoder attribute.
 *
 * The function returns the capability value for a given encoder attribute. The 
 * client must validate the encodeGUID using ::NvEncGetEncodeGUIDs() API before 
 * calling this function. The encoder attribute being queried are enumerated in 
 * ::NV_ENC_CAPS_PARAM enum.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeGUID [in]
 *   Encode GUID, corresponding to which the capability attribute is to be retrieved.
 * @param capsParam [in]
 *   Used to specify attribute being queried. Refer ::NV_ENC_CAPS_PARAM for  more 
 * details.
 * @param capsVal [out]
 *   The value corresponding to the capability attribute being queried.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 */



// NvEncGetEncodePresetCount
/**
 * \brief Retrieves the number of supported preset GUIDs.
 *
 * The function returns the number of preset GUIDs available for a given codec. 
 * The client must validate the codec GUID using ::NvEncGetEncodeGUIDs() API 
 * before calling this function.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeGUID [in]
 *   Encode GUID, corresponding to which the number of supported presets is to 
 *   be retrieved.
 * @param encodePresetGUIDCount [out]
 *   Receives the number of supported preset GUIDs.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncGetEncodePresetGUIDs
/**
 * \brief Receives an array of supported encoder preset GUIDs.
 *
 * The function returns an array of encode preset GUIDs available for a given codec. 
 * The client can directly use one of the preset GUIDs based upon the use case
 * or target device. The preset GUID chosen can be directly used in 
 * NV_ENC_INITIALIZE_PARAMS::presetGUID parameter to ::NvEncEncodePicture() API. 
 * Alternately client can  also use the preset GUID to retrieve the encoding config 
 * parameters being used by NvEncodeAPI interface for that given preset, using
 * ::NvEncGetEncodePresetConfig() API. It can then modify preset config parameters
 * as per its use case and send it to NvEncodeAPI interface as part of 
 * NV_ENC_INITIALIZE_PARAMS::encodeConfig parameter for NvEncInitializeEncoder()
 * API.
 *
 *
 * @param encoder [in] 
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeGUID [in]
 *   Encode GUID, corresponding to which the list of supported presets is to be
 *   retrieved.
 * @param guidArraySize [in]
 *   Size of array of preset GUIDs passed in \p preset GUIDs
 * @param presetGUIDs [out]
 *   Array of supported Encode preset GUIDs from the NvEncodeAPI interface 
 *   to client.
 * @param encodePresetGUIDCount [out]
 *   Receives the number of preset GUIDs returned by the NvEncodeAPI 
 *   interface.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncGetEncodePresetConfig
/**
 * \brief Returns a preset config structure supported for given preset GUID.
 *
 * The function returns a preset config structure for a given preset GUID. Before  
 * using this function the client must enumerate the preset GUIDs available for 
 * a given codec. The preset config structure can be modified by the client depending
 * upon its use case and can be then used to initialize the encoder using 
 * ::NvEncInitializeEncoder() API. The client can use this function only if it 
 * wants to modify the NvEncodeAPI preset configuration, otherwise it can 
 * directly use the preset GUID.
 * 
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface. 
 * @param encodeGUID [in]
 *   Encode GUID, corresponding to which the list of supported presets is to be
 *   retrieved.
 * @param presetGUID [in]
 *   Preset GUID, corresponding to which the Encoding configurations is to be 
 *   retrieved.
 * @param presetConfig [out]
 *   The requested Preset Encoder Attribute set. Refer ::_NV_ENC_CONFIG for
*    more details.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncGetEncodePresetConfigEx
/**
 * \brief Returns a preset config structure supported for given preset GUID.
 *
 * The function returns a preset config structure for a given preset GUID and tuning info. 
 * NvEncGetEncodePresetConfigEx() API is not applicable to H264 and HEVC meonly mode.
 * Before using this function the client must enumerate the preset GUIDs available for 
 * a given codec. The preset config structure can be modified by the client depending
 * upon its use case and can be then used to initialize the encoder using 
 * ::NvEncInitializeEncoder() API. The client can use this function only if it 
 * wants to modify the NvEncodeAPI preset configuration, otherwise it can 
 * directly use the preset GUID.
 * 
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface. 
 * @param encodeGUID [in]
 *   Encode GUID, corresponding to which the list of supported presets is to be
 *   retrieved.
 * @param presetGUID [in]
 *   Preset GUID, corresponding to which the Encoding configurations is to be 
 *   retrieved.
 * @param tuningInfo [in]
 *   tuning info, corresponding to which the Encoding configurations is to be 
 *   retrieved.
 * @param presetConfig [out]
 *   The requested Preset Encoder Attribute set. Refer ::_NV_ENC_CONFIG for
 *    more details.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncInitializeEncoder
/**
 * \brief Initialize the encoder.
 *
 * This API must be used to initialize the encoder. The initialization parameter
 * is passed using \p *createEncodeParams  The client must send the following
 * fields of the _NV_ENC_INITIALIZE_PARAMS structure with a valid value.
 * - NV_ENC_INITIALIZE_PARAMS::encodeGUID
 * - NV_ENC_INITIALIZE_PARAMS::encodeWidth
 * - NV_ENC_INITIALIZE_PARAMS::encodeHeight
 * 
 * The client can pass a preset GUID directly to the NvEncodeAPI interface using
 * NV_ENC_INITIALIZE_PARAMS::presetGUID field. If the client doesn't pass 
 * NV_ENC_INITIALIZE_PARAMS::encodeConfig structure, the codec specific parameters
 * will be selected based on the preset GUID. The preset GUID must have been 
 * validated by the client using ::NvEncGetEncodePresetGUIDs() API.
 * If the client passes a custom ::_NV_ENC_CONFIG structure through
 * NV_ENC_INITIALIZE_PARAMS::encodeConfig , it will override the codec specific parameters
 * based on the preset GUID. It is recommended that even if the client passes a custom config,
 * it should also send a preset GUID. In this case, the preset GUID passed by the client
 * will not override any of the custom config parameters programmed by the client,
 * it is only used as a hint by the NvEncodeAPI interface to determine certain encoder parameters
 * which are not exposed to the client.
 *
 * There are two modes of operation for the encoder namely:
 * - Asynchronous mode
 * - Synchronous mode
 *
 * The client can select asynchronous or synchronous mode by setting the \p
 * enableEncodeAsync field in ::_NV_ENC_INITIALIZE_PARAMS to 1 or 0 respectively.
 *\par Asynchronous mode of operation:
 * The Asynchronous mode can be enabled by setting NV_ENC_INITIALIZE_PARAMS::enableEncodeAsync to 1.
 * The client operating in asynchronous mode must allocate completion event object
 * for each output buffer and pass the completion event object in the
 * ::NvEncEncodePicture() API. The client can create another thread and wait on
 * the event object to be signaled by NvEncodeAPI interface on completion of the
 * encoding process for the output frame. This should unblock the main thread from
 * submitting work to the encoder. When the event is signaled the client can call
 * NvEncodeAPI interfaces to copy the bitstream data using ::NvEncLockBitstream()
 * API. This is the preferred mode of operation.
 *
 * NOTE: Asynchronous mode is not supported on Linux.
 *
 *\par Synchronous mode of operation:
 * The client can select synchronous mode by setting NV_ENC_INITIALIZE_PARAMS::enableEncodeAsync to 0.
 * The client working in synchronous mode can work in a single threaded or multi
 * threaded mode. The client need not allocate any event objects. The client can
 * only lock the bitstream data after NvEncodeAPI interface has returned
 * ::NV_ENC_SUCCESS from encode picture. The NvEncodeAPI interface can return 
 * ::NV_ENC_ERR_NEED_MORE_INPUT error code from ::NvEncEncodePicture() API. The
 * client must not lock the output buffer in such case but should send the next
 * frame for encoding. The client must keep on calling ::NvEncEncodePicture() API
 * until it returns ::NV_ENC_SUCCESS. \n
 * The client must always lock the bitstream data in order in which it has submitted.
 * This is true for both asynchronous and synchronous mode.
 *
 *\par Picture type decision:
 * If the client is taking the picture type decision and it must disable the picture
 * type decision module in NvEncodeAPI by setting NV_ENC_INITIALIZE_PARAMS::enablePTD
 * to 0. In this case the client is  required to send the picture in encoding 
 * order to NvEncodeAPI by doing the re-ordering for B frames. \n
 * If the client doesn't want to take the picture type decision it can enable 
 * picture type decision module in the NvEncodeAPI interface by setting 
 * NV_ENC_INITIALIZE_PARAMS::enablePTD to 1 and send the input pictures in display 
 * order.
 * 
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param createEncodeParams [in] 
 *   Refer ::_NV_ENC_INITIALIZE_PARAMS for details.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncCreateInputBuffer
/**
 * \brief Allocates Input buffer.
 *
 * This function is used to allocate an input buffer. The client must enumerate
 * the input buffer format before allocating the input buffer resources. The 
 * NV_ENC_INPUT_PTR returned by the NvEncodeAPI interface in the 
 * NV_ENC_CREATE_INPUT_BUFFER::inputBuffer field can be directly used in
 * ::NvEncEncodePicture() API. The number of input buffers to be allocated by the 
 * client must be at least 4 more than the number of B frames being used for encoding.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param createInputBufferParams [in,out]
 *  Pointer to the ::NV_ENC_CREATE_INPUT_BUFFER structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_GENERIC \n
 * 
 */



// NvEncDestroyInputBuffer
/**
 * \brief Release an input buffers.
 *
 * This function is used to free an input buffer. If the client has allocated
 * any input buffer using ::NvEncCreateInputBuffer() API, it must free those
 * input buffers by calling this function. The client must release the input
 * buffers before destroying the encoder using ::NvEncDestroyEncoder() API.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param inputBuffer [in] 
 *   Pointer to the input buffer to be released.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncSetIOCudaStreams
/**
 * \brief Set input and output CUDA stream for specified encoder attribute.
 *
 * Encoding may involve CUDA pre-processing on the input and post-processing on encoded output.
 * This function is used to set input and output CUDA streams to pipeline the CUDA pre-processing 
 * and post-processing tasks. Clients should call this function before the call to 
 * NvEncUnlockInputBuffer(). If this function is not called, the default CUDA stream is used for 
 * input and output processing. After a successful call to this function, the streams specified 
 * in that call will replace the previously-used streams. 
 * This API is supported for NVCUVID interface only.
 *
 * @param encoder [in] 
 *   Pointer to the NvEncodeAPI interface.
 * @param inputStream [in]
 *   Pointer to CUstream which is used to process ::NV_ENC_PIC_PARAMS::inputFrame for encode.
 *   In case of ME-only mode, inputStream is used to process ::NV_ENC_MEONLY_PARAMS::inputBuffer and 
 *   ::NV_ENC_MEONLY_PARAMS::referenceFrame
 * @param outputStream [in]
 *  Pointer to CUstream which is used to process ::NV_ENC_PIC_PARAMS::outputBuffer for encode.
 *  In case of ME-only mode, outputStream is used to process ::NV_ENC_MEONLY_PARAMS::mvBuffer
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_GENERIC \n
 */



// NvEncCreateBitstreamBuffer
/**
 * \brief Allocates an output bitstream buffer 
 *
 * This function is used to allocate an output bitstream buffer and returns a 
 * NV_ENC_OUTPUT_PTR to bitstream  buffer to the client in the 
 * NV_ENC_CREATE_BITSTREAM_BUFFER::bitstreamBuffer field.
 * The client can only call this function after the encoder session has been 
 * initialized using ::NvEncInitializeEncoder() API. The minimum number of output 
 * buffers allocated by the client must be at least 4 more than the number of B
 * B frames being used for encoding. The client can only access the output 
 * bitstream data by locking the \p bitstreamBuffer using the ::NvEncLockBitstream()
 * function.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param createBitstreamBufferParams [in,out]
 *   Pointer ::NV_ENC_CREATE_BITSTREAM_BUFFER for details.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncDestroyBitstreamBuffer
/**
 * \brief Release a bitstream buffer. 
 *
 * This function is used to release the output bitstream buffer allocated using
 * the ::NvEncCreateBitstreamBuffer() function. The client must release the output
 * bitstreamBuffer using this function before destroying the encoder session.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param bitstreamBuffer [in]
 *   Pointer to the bitstream buffer being released.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncEncodePicture
/**
 * \brief Submit an input picture for encoding.
 *
 * This function is used to submit an input picture buffer for encoding. The 
 * encoding parameters are passed using \p *encodePicParams which is a pointer
 * to the ::_NV_ENC_PIC_PARAMS structure.
 *
 * If the client has set NV_ENC_INITIALIZE_PARAMS::enablePTD to 0, then it must
 * send a valid value for the following fields.
 * - NV_ENC_PIC_PARAMS::pictureType
 * - NV_ENC_PIC_PARAMS_H264::displayPOCSyntax (H264 only)
 * - NV_ENC_PIC_PARAMS_H264::frameNumSyntax(H264 only)
 * - NV_ENC_PIC_PARAMS_H264::refPicFlag(H264 only)
 *
 *\par MVC Encoding:
 * For MVC encoding the client must call encode picture API for each view separately
 * and must pass valid view id in NV_ENC_PIC_PARAMS_MVC::viewID field. Currently
 * NvEncodeAPI only support stereo MVC so client must send viewID as 0 for base
 * view and view ID as 1 for dependent view.
 *
 *\par Asynchronous Encoding
 * If the client has enabled asynchronous mode of encoding by setting 
 * NV_ENC_INITIALIZE_PARAMS::enableEncodeAsync to 1 in the ::NvEncInitializeEncoder()
 * API ,then the client must send a valid NV_ENC_PIC_PARAMS::completionEvent.
 * Incase of asynchronous mode of operation, client can queue the ::NvEncEncodePicture()
 * API commands from the main thread and then queue output buffers to be processed 
 * to a secondary worker thread. Before the locking the output buffers in the 
 * secondary thread , the client must wait on NV_ENC_PIC_PARAMS::completionEvent
 * it has queued in ::NvEncEncodePicture() API call. The client must always process
 * completion event and the output buffer in the same order in which they have been
 * submitted for encoding. The NvEncodeAPI interface is responsible for any 
 * re-ordering required for B frames and will always ensure that encoded bitstream
 * data is written in the same order in which output buffer is submitted.
 * The NvEncodeAPI interface may return ::NV_ENC_ERR_NEED_MORE_INPUT error code for
 * some ::NvEncEncodePicture() API calls but the client must not treat it as a fatal error.
 * The NvEncodeAPI interface might not be able to submit an input picture buffer for encoding 
 * immediately due to re-ordering for B frames.
 *<pre>{@code
  The below example shows how  asynchronous encoding in case of 1 B frames
  ------------------------------------------------------------------------
  Suppose the client allocated 4 input buffers(I1,I2..), 4 output buffers(O1,O2..) 
  and 4 completion events(E1, E2, ...). The NvEncodeAPI interface will need to 
  keep a copy of the input buffers for re-ordering and it allocates following 
  internal buffers (NvI1, NvI2...). These internal buffers are managed by NvEncodeAPI
  and the client is not responsible for the allocating or freeing the memory of 
  the internal buffers.

  a) The client main thread will queue the following encode frame calls. 
  Note the picture type is unknown to the client, the decision is being taken by 
  NvEncodeAPI interface. The client should pass ::_NV_ENC_PIC_PARAMS parameter  
  consisting of allocated input buffer, output buffer and output events in successive 
  ::NvEncEncodePicture() API calls along with other required encode picture params.
  For example:
  1st EncodePicture parameters - (I1, O1, E1)
  2nd EncodePicture parameters - (I2, O2, E2)
  3rd EncodePicture parameters - (I3, O3, E3)

  b) NvEncodeAPI SW will receive the following encode Commands from the client. 
  The left side shows input from client in the form (Input buffer, Output Buffer, 
  Output Event). The right hand side shows a possible picture type decision take by
  the NvEncodeAPI interface.
  (I1, O1, E1)    ---P1 Frame
  (I2, O2, E2)    ---B2 Frame
  (I3, O3, E3)    ---P3 Frame

  c) NvEncodeAPI interface will make a copy of the input buffers to its internal  
   buffers for re-ordering. These copies are done as part of nvEncEncodePicture  
   function call from the client and NvEncodeAPI interface is responsible for  
   synchronization of copy operation with the actual encoding operation.
   I1 --> NvI1  
   I2 --> NvI2 
   I3 --> NvI3

   d) The NvEncodeAPI encodes I1 as P frame and submits I1 to encoder HW and returns ::NV_ENC_SUCCESS.
   The NvEncodeAPI tries to encode I2 as B frame and fails with ::NV_ENC_ERR_NEED_MORE_INPUT error code.
   The error is not fatal and it notifies client that I2 is not submitted to encoder immediately.
   The NvEncodeAPI encodes I3 as P frame and submits I3 for encoding which will be used as  backward 
   reference frame for I2. The NvEncodeAPI then submits I2 for encoding and returns ::NV_ENC_SUCESS.
   Both the submission are part of the same ::NvEncEncodePicture() function call.

  e) After returning from ::NvEncEncodePicture() call , the client must queue the output
   bitstream  processing work to the secondary thread. The output bitstream processing
   for asynchronous mode consist of first waiting on completion event(E1, E2..)
   and then locking the output bitstream buffer(O1, O2..) for reading the encoded
   data. The work queued to the secondary thread by the client is in the following order
   (I1, O1, E1)
   (I2, O2, E2)
   (I3, O3, E3)
   Note they are in the same order in which client calls ::NvEncEncodePicture() API 
   in \p step a).

  f) NvEncodeAPI interface  will do the re-ordering such that Encoder HW will receive 
  the following encode commands:
  (NvI1, O1, E1)   ---P1 Frame
  (NvI3, O2, E2)   ---P3 Frame
  (NvI2, O3, E3)   ---B2 frame

  g) After the encoding operations are completed, the events will be signaled 
  by NvEncodeAPI interface in the following order :
  (O1, E1) ---P1 Frame ,output bitstream copied to O1 and event E1 signaled.
  (O2, E2) ---P3 Frame ,output bitstream copied to O2 and event E2 signaled.
  (O3, E3) ---B2 Frame ,output bitstream copied to O3 and event E3 signaled.

  h) The client must lock the bitstream data using ::NvEncLockBitstream() API in 
   the order O1,O2,O3  to read the encoded data, after waiting for the events
   to be signaled in the same order i.e E1, E2 and E3.The output processing is
   done in the secondary thread in the following order:
   Waits on E1, copies encoded bitstream from O1
   Waits on E2, copies encoded bitstream from O2
   Waits on E3, copies encoded bitstream from O3

  -Note the client will receive the events signaling and output buffer in the 
   same order in which they have submitted for encoding.
  -Note the LockBitstream will have picture type field which will notify the 
   output picture type to the clients.
  -Note the input, output buffer and the output completion event are free to be 
   reused once NvEncodeAPI interfaced has signaled the event and the client has
   copied the data from the output buffer.

 * }</pre>
 *
 *\par Synchronous Encoding
 * The client can enable synchronous mode of encoding by setting 
 * NV_ENC_INITIALIZE_PARAMS::enableEncodeAsync to 0 in ::NvEncInitializeEncoder() API.
 * The NvEncodeAPI interface may return ::NV_ENC_ERR_NEED_MORE_INPUT error code for
 * some ::NvEncEncodePicture() API calls when NV_ENC_INITIALIZE_PARAMS::enablePTD 
 * is set to 1, but the client must not treat it as a fatal error. The NvEncodeAPI 
 * interface might not be able to submit an input picture buffer for encoding 
 * immediately due to re-ordering for B frames. The NvEncodeAPI interface cannot 
 * submit the input picture which is decided to be encoded as B frame as it waits 
 * for backward reference from  temporally subsequent frames. This input picture
 * is buffered internally and waits for more input picture to arrive. The client
 * must not call ::NvEncLockBitstream() API on the output buffers whose 
 * ::NvEncEncodePicture() API returns ::NV_ENC_ERR_NEED_MORE_INPUT. The client must 
 * wait for the NvEncodeAPI interface to return ::NV_ENC_SUCCESS before locking the 
 * output bitstreams to read the encoded bitstream data. The following example
 * explains the scenario with synchronous encoding with 2 B frames.
 *<pre>{@code
 The below example shows how  synchronous encoding works in case of 1 B frames
 -----------------------------------------------------------------------------
 Suppose the client allocated 4 input buffers(I1,I2..), 4 output buffers(O1,O2..) 
 and 4 completion events(E1, E2, ...). The NvEncodeAPI interface will need to 
 keep a copy of the input buffers for re-ordering and it allocates following 
 internal buffers (NvI1, NvI2...). These internal buffers are managed by NvEncodeAPI
 and the client is not responsible for the allocating or freeing the memory of 
 the internal buffers.

 The client calls ::NvEncEncodePicture() API with input buffer I1 and output buffer O1.
 The NvEncodeAPI decides to encode I1 as P frame and submits it to encoder
 HW and returns ::NV_ENC_SUCCESS. 
 The client can now read the encoded data by locking the output O1 by calling
 NvEncLockBitstream API.

 The client calls ::NvEncEncodePicture() API with input buffer I2 and output buffer O2.
 The NvEncodeAPI decides to encode I2 as B frame and buffers I2 by copying it
 to internal buffer and returns ::NV_ENC_ERR_NEED_MORE_INPUT.
 The error is not fatal and it notifies client that it cannot read the encoded 
 data by locking the output O2 by calling ::NvEncLockBitstream() API without submitting
 more work to the NvEncodeAPI interface.
  
 The client calls ::NvEncEncodePicture() with input buffer I3 and output buffer O3.
 The NvEncodeAPI decides to encode I3 as P frame and it first submits I3 for 
 encoding which will be used as backward reference frame for I2.
 The NvEncodeAPI then submits I2 for encoding and returns ::NV_ENC_SUCESS. Both
 the submission are part of the same ::NvEncEncodePicture() function call.
 The client can now read the encoded data for both the frames by locking the output
 O2 followed by  O3 ,by calling ::NvEncLockBitstream() API.

 The client must always lock the output in the same order in which it has submitted
 to receive the encoded bitstream in correct encoding order.

 * }</pre>
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param encodePicParams [in,out]
 *   Pointer to the ::_NV_ENC_PIC_PARAMS structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_ENCODER_BUSY \n
 * ::NV_ENC_ERR_NEED_MORE_INPUT \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncLockBitstream
/**
 * \brief Lock output bitstream buffer
 *
 * This function is used to lock the bitstream buffer to read the encoded data.
 * The client can only access the encoded data by calling this function. 
 * The pointer to client accessible encoded data is returned in the 
 * NV_ENC_LOCK_BITSTREAM::bitstreamBufferPtr field. The size of the encoded data
 * in the output buffer is returned in the NV_ENC_LOCK_BITSTREAM::bitstreamSizeInBytes
 * The NvEncodeAPI interface also returns the output picture type and picture structure 
 * of the encoded frame in NV_ENC_LOCK_BITSTREAM::pictureType and
 * NV_ENC_LOCK_BITSTREAM::pictureStruct fields respectively. If the client has
 * set NV_ENC_LOCK_BITSTREAM::doNotWait to 1, the function might return
 * ::NV_ENC_ERR_LOCK_BUSY if client is operating in synchronous mode. This is not 
 * a fatal failure if NV_ENC_LOCK_BITSTREAM::doNotWait is set to 1. In the above case the client can 
 * retry the function after few milliseconds.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param lockBitstreamBufferParams [in,out]
 *   Pointer to the ::_NV_ENC_LOCK_BITSTREAM structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_LOCK_BUSY \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncUnlockBitstream
/**
 * \brief Unlock the output bitstream buffer
 *
 * This function is used to unlock the output bitstream buffer after the client
 * has read the encoded data from output buffer. The client must call this function
 * to unlock the output buffer which it has previously locked using ::NvEncLockBitstream()
 * function. Using a locked bitstream buffer in ::NvEncEncodePicture() API will cause
 * the function to fail.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param bitstreamBuffer [in,out]
 *   bitstream buffer pointer being unlocked
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvLockInputBuffer
/**
 * \brief Locks an input buffer
 *
 * This function is used to lock the input buffer to load the uncompressed YUV
 * pixel data into input buffer memory. The client must pass the NV_ENC_INPUT_PTR
 * it had previously allocated using ::NvEncCreateInputBuffer()in the
 * NV_ENC_LOCK_INPUT_BUFFER::inputBuffer field. 
 * The NvEncodeAPI interface returns pointer to client accessible input buffer 
 * memory in NV_ENC_LOCK_INPUT_BUFFER::bufferDataPtr field. 
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param lockInputBufferParams [in,out]
 *   Pointer to the ::_NV_ENC_LOCK_INPUT_BUFFER structure
 *
 * @return
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_LOCK_BUSY \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvUnlockInputBuffer
/**
 * \brief Unlocks the input buffer
 *
 * This function is used to unlock the input buffer memory previously locked for
 * uploading YUV pixel data. The input buffer must be unlocked before being used
 * again for encoding, otherwise NvEncodeAPI will fail the ::NvEncEncodePicture()
 *
  * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param inputBuffer [in]
 *   Pointer to the input buffer that is being unlocked.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 *
 */



// NvEncGetEncodeStats
/**
 * \brief Get encoding statistics.
 *
 * This function is used to retrieve the encoding statistics.
 * This API is not supported when encode device type is CUDA.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param encodeStats [in,out]
 *   Pointer to the ::_NV_ENC_STAT structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncGetSequenceParams
/**
 * \brief Get encoded sequence and picture header.
 *
 * This function can be used to retrieve the sequence and picture header out of 
 * band. The client must call this function only after the encoder has been 
 * initialized using ::NvEncInitializeEncoder() function. The client must 
 * allocate the memory where the NvEncodeAPI interface can copy the bitstream
 * header and pass the pointer to the memory in NV_ENC_SEQUENCE_PARAM_PAYLOAD::spsppsBuffer. 
 * The size of buffer is passed in the field  NV_ENC_SEQUENCE_PARAM_PAYLOAD::inBufferSize.
 * The NvEncodeAPI interface will copy the bitstream header payload and returns 
 * the actual size of the bitstream header in the field
 * NV_ENC_SEQUENCE_PARAM_PAYLOAD::outSPSPPSPayloadSize.
 * The client must call  ::NvEncGetSequenceParams() function from the same thread which is 
 * being used to call ::NvEncEncodePicture() function.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param sequenceParamPayload [in,out]
 *   Pointer to the ::_NV_ENC_SEQUENCE_PARAM_PAYLOAD structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n 
 *
 */


// NvEncGetSequenceParamEx
/**
 * \brief Get sequence and picture header.
 *
 * This function can be used to retrieve the sequence and picture header out of band, even when
 * encoder has not been initialized using ::NvEncInitializeEncoder() function. 
 * The client must allocate the memory where the NvEncodeAPI interface can copy the bitstream
 * header and pass the pointer to the memory in NV_ENC_SEQUENCE_PARAM_PAYLOAD::spsppsBuffer. 
 * The size of buffer is passed in the field  NV_ENC_SEQUENCE_PARAM_PAYLOAD::inBufferSize. 
 * If encoder has not been initialized using ::NvEncInitializeEncoder() function, client must 
 * send NV_ENC_INITIALIZE_PARAMS as input. The NV_ENC_INITIALIZE_PARAMS passed must be same as the 
 * one which will be used for initializing encoder using ::NvEncInitializeEncoder() function later.
 * If encoder is already initialized using ::NvEncInitializeEncoder() function, the provided 
 * NV_ENC_INITIALIZE_PARAMS structure is ignored. The NvEncodeAPI interface will copy the bitstream 
 * header payload and returns the actual size of the bitstream header in the field
 * NV_ENC_SEQUENCE_PARAM_PAYLOAD::outSPSPPSPayloadSize. The client must call  ::NvEncGetSequenceParamsEx()
 * function from the same thread which is being used to call ::NvEncEncodePicture() function.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param encInitParams [in]
 *   Pointer to the _NV_ENC_INITIALIZE_PARAMS structure.
 * @param sequenceParamPayload [in,out]
 *   Pointer to the ::_NV_ENC_SEQUENCE_PARAM_PAYLOAD structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n 
 *
 */


// NvEncRegisterAsyncEvent
/**
 * \brief Register event for notification to encoding completion.
 *
 * This function is used to register the completion event with NvEncodeAPI 
 * interface. The event is required when the client has configured the encoder to 
 * work in asynchronous mode. In this mode the client needs to send a completion
 * event with every output buffer. The NvEncodeAPI interface will signal the 
 * completion of the encoding process using this event. Only after the event is 
 * signaled the client can get the encoded data using ::NvEncLockBitstream() function.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param eventParams [in]
 *   Pointer to the ::_NV_ENC_EVENT_PARAMS structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncUnregisterAsyncEvent
/**
 * \brief Unregister completion event.
 *
 * This function is used to unregister completion event which has been previously
 * registered using ::NvEncRegisterAsyncEvent() function. The client must unregister
 * all events before destroying the encoder using ::NvEncDestroyEncoder() function.
 *
  * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param eventParams [in]
 *   Pointer to the ::_NV_ENC_EVENT_PARAMS structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncMapInputResource 
/**
 * \brief Map an externally created input resource pointer for encoding.
 *
 * Maps an externally allocated input resource [using and returns a NV_ENC_INPUT_PTR
 * which can be used for encoding in the ::NvEncEncodePicture() function. The
 * mapped resource is returned in the field NV_ENC_MAP_INPUT_RESOURCE::outputResourcePtr.
 * The NvEncodeAPI interface also returns the buffer format of the mapped resource
 * in the field NV_ENC_MAP_INPUT_RESOURCE::outbufferFmt.
 * This function provides synchronization guarantee that any graphics work submitted
 * on the input buffer is completed before the buffer is used for encoding. This is
 * also true for compute (i.e. CUDA) work, provided that the previous workload using
 * the input resource was submitted to the default stream.
 * The client should not access any input buffer while they are mapped by the encoder.
 * For D3D12 interface type, this function does not provide synchronization guarantee.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param mapInputResParams [in,out]
 *   Pointer to the ::_NV_ENC_MAP_INPUT_RESOURCE structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_RESOURCE_NOT_REGISTERED \n
 * ::NV_ENC_ERR_MAP_FAILED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */



// NvEncUnmapInputResource 
/**
 * \brief  UnMaps a NV_ENC_INPUT_PTR  which was mapped for encoding
 *
 *
 * UnMaps an input buffer which was previously mapped using ::NvEncMapInputResource()
 * API. The mapping created using ::NvEncMapInputResource() should be invalidated
 * using this API before the external resource is destroyed by the client. The client
 * must unmap the buffer after ::NvEncLockBitstream() API returns successfully for encode
 * work submitted using the mapped input buffer.
 *
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param mappedInputBuffer [in]
 *   Pointer to the NV_ENC_INPUT_PTR
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_RESOURCE_NOT_REGISTERED \n
 * ::NV_ENC_ERR_RESOURCE_NOT_MAPPED \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncDestroyEncoder
/**
 * \brief Destroy Encoding Session
 *
 * Destroys the encoder session previously created using ::NvEncOpenEncodeSession()
 * function. The client must flush the encoder before freeing any resources. In order 
 * to flush the encoder the client must pass a NULL encode picture packet and either 
 * wait for the ::NvEncEncodePicture() function to return in synchronous mode or wait 
 * for the flush event to be signaled by the encoder in asynchronous mode.
 * The client must free all the input and output resources created using the
 * NvEncodeAPI interface before destroying the encoder. If the client is operating
 * in asynchronous mode, it must also unregister the completion events previously
 * registered. 
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncInvalidateRefFrames
/**
 * \brief Invalidate reference frames 
 *
 * Invalidates reference frame based on the time stamp provided by the client. 
 * The encoder marks any reference frames or any frames which have been reconstructed
 * using the corrupt frame as invalid for motion estimation and uses older reference
 * frames for motion estimation. The encoded forces the current frame to be encoded
 * as an intra frame if no reference frames are left after invalidation process.
 * This is useful for low latency application for error resiliency. The client 
 * is recommended to set NV_ENC_CONFIG_H264::maxNumRefFrames to a large value so 
 * that encoder can keep a backup of older reference frames in the DPB and can use them
 * for motion estimation when the newer reference frames have been invalidated.
 * This API can be called multiple times.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param invalidRefFrameTimeStamp [in]
 *   Timestamp of the invalid reference frames which needs to be invalidated.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncOpenEncodeSessionEx
/**
 * \brief Opens an encoding session.
 * 
 * Opens an encoding session and returns a pointer to the encoder interface in
 * the \p **encoder parameter. The client should start encoding process by calling
 * this API first. 
 * The client must pass a pointer to IDirect3DDevice9 device or CUDA context in the \p *device parameter.
 * For the OpenGL interface, \p device must be NULL. An OpenGL context must be current when
 * calling all NvEncodeAPI functions.
 * If the creation of encoder session fails, the client must call ::NvEncDestroyEncoder API 
 * before exiting.
 *
 * @param openSessionExParams [in]
 *    Pointer to a ::NV_ENC_OPEN_ENCODE_SESSION_EX_PARAMS structure.
 * @param encoder [out]
 *    Encode Session pointer to the NvEncodeAPI interface.
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_NO_ENCODE_DEVICE \n
 * ::NV_ENC_ERR_UNSUPPORTED_DEVICE \n
 * ::NV_ENC_ERR_INVALID_DEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */


// NvEncRegisterResource
/**
 * \brief Registers a resource with the Nvidia Video Encoder Interface.
 * 
 * Registers a resource with the Nvidia Video Encoder Interface for book keeping.
 * The client is expected to pass the registered resource handle as well, while calling ::NvEncMapInputResource API.
 *
 * @param encoder [in]
 *   Pointer to the NVEncodeAPI interface.
 *
 * @param registerResParams [in]
 *   Pointer to a ::_NV_ENC_REGISTER_RESOURCE structure
 * 
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_RESOURCE_REGISTER_FAILED \n
 * ::NV_ENC_ERR_GENERIC \n
 * ::NV_ENC_ERR_UNIMPLEMENTED \n
 *
 */


// NvEncUnregisterResource
/**
 * \brief Unregisters a resource previously registered with the Nvidia Video Encoder Interface.
 * 
 * Unregisters a resource previously registered with the Nvidia Video Encoder Interface.
 * The client is expected to unregister any resource that it has registered with the 
 * Nvidia Video Encoder Interface before destroying the resource.
 *
 * @param encoder [in]
 *   Pointer to the NVEncodeAPI interface.
 *
 * @param registeredResource [in]
 *   The registered resource pointer that was returned in ::NvEncRegisterResource.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_RESOURCE_NOT_REGISTERED \n
 * ::NV_ENC_ERR_GENERIC \n
 * ::NV_ENC_ERR_UNIMPLEMENTED \n
 *
 */


// NvEncReconfigureEncoder
/**
 * \brief Reconfigure an existing encoding session.
 * 
 * Reconfigure an existing encoding session.
 * The client should call this API to change/reconfigure the parameter passed during 
 * NvEncInitializeEncoder API call.
 * Currently Reconfiguration of following are not supported.
 * Change in GOP structure.
 * Change in sync-Async mode.
 * Change in MaxWidth & MaxHeight.
 * Change in PTD mode.
 * 
 * Resolution change is possible only if maxEncodeWidth & maxEncodeHeight of NV_ENC_INITIALIZE_PARAMS
 * is set while creating encoder session.
 *
 * @param encoder [in]
 *   Pointer to the NVEncodeAPI interface.
 *
 * @param reInitEncodeParams [in]
 *    Pointer to a ::NV_ENC_RECONFIGURE_PARAMS structure.
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_NO_ENCODE_DEVICE \n
 * ::NV_ENC_ERR_UNSUPPORTED_DEVICE \n
 * ::NV_ENC_ERR_INVALID_DEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_GENERIC \n
 *
 */




// NvEncCreateMVBuffer
/**
 * \brief Allocates output MV buffer for ME only mode.
 *
 * This function is used to allocate an output MV buffer. The size of the mvBuffer is
 * dependent on the frame height and width of the last ::NvEncCreateInputBuffer() call.
 * The NV_ENC_OUTPUT_PTR returned by the NvEncodeAPI interface in the
 * ::NV_ENC_CREATE_MV_BUFFER::mvBuffer field should be used in
 * ::NvEncRunMotionEstimationOnly() API.
 * Client must lock ::NV_ENC_CREATE_MV_BUFFER::mvBuffer using ::NvEncLockBitstream() API to get the motion vector data.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param createMVBufferParams [in,out]
 *  Pointer to the ::NV_ENC_CREATE_MV_BUFFER structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_GENERIC \n
 */



// NvEncDestroyMVBuffer
/**
 * \brief Release an output MV buffer for ME only mode.
 *
 * This function is used to release the output MV buffer allocated using
 * the ::NvEncCreateMVBuffer() function. The client must release the output
 * mvBuffer using this function before destroying the encoder session.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param mvBuffer [in]
 *   Pointer to the mvBuffer being released.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 */



// NvEncRunMotionEstimationOnly
/**
 * \brief Submit an input picture and reference frame for motion estimation in ME only mode.
 *
 * This function is used to submit the input frame and reference frame for motion
 * estimation. The ME parameters are passed using *meOnlyParams which is a pointer
 * to ::_NV_ENC_MEONLY_PARAMS structure.
 * Client must lock ::NV_ENC_CREATE_MV_BUFFER::mvBuffer using ::NvEncLockBitstream() API to get the motion vector data.
 * to get motion vector data.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 * @param meOnlyParams [in]
 *   Pointer to the ::_NV_ENC_MEONLY_PARAMS structure.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 * ::NV_ENC_ERR_INVALID_ENCODERDEVICE \n
 * ::NV_ENC_ERR_DEVICE_NOT_EXIST \n
 * ::NV_ENC_ERR_UNSUPPORTED_PARAM \n
 * ::NV_ENC_ERR_OUT_OF_MEMORY \n
 * ::NV_ENC_ERR_INVALID_PARAM \n
 * ::NV_ENC_ERR_INVALID_VERSION \n
 * ::NV_ENC_ERR_NEED_MORE_INPUT \n
 * ::NV_ENC_ERR_ENCODER_NOT_INITIALIZED \n
 * ::NV_ENC_ERR_GENERIC \n
 */


// NvEncodeAPIGetMaxSupportedVersion
/**
 * \brief Get the largest NvEncodeAPI version supported by the driver.
 *
 * This function can be used by clients to determine if the driver supports
 * the NvEncodeAPI header the application was compiled with.
 *
 * @param version [out]
 *   Pointer to the requested value. The 4 least significant bits in the returned
 *   indicate the minor version and the rest of the bits indicate the major
 *   version of the largest supported version.
 *
 * @return
 * ::NV_ENC_SUCCESS \n
 * ::NV_ENC_ERR_INVALID_PTR \n
 */
public static native @Cast("NVENCSTATUS") int NvEncodeAPIGetMaxSupportedVersion(@Cast("uint32_t*") IntPointer version);
public static native @Cast("NVENCSTATUS") int NvEncodeAPIGetMaxSupportedVersion(@Cast("uint32_t*") IntBuffer version);
public static native @Cast("NVENCSTATUS") int NvEncodeAPIGetMaxSupportedVersion(@Cast("uint32_t*") int[] version);


// NvEncGetLastErrorString
/**
 * \brief Get the description of the last error reported by the API.
 *
 * This function returns a null-terminated string that can be used by clients to better understand the reason
 * for failure of a previous API call.
 *
 * @param encoder [in]
 *   Pointer to the NvEncodeAPI interface.
 *
 * @return
 *   Pointer to buffer containing the details of the last error encountered by the API.
 */

// Targeting ..\nvencodeapi\PNVENCOPENENCODESESSION.java


// Targeting ..\nvencodeapi\PNVENCGETENCODEGUIDCOUNT.java


// Targeting ..\nvencodeapi\PNVENCGETENCODEGUIDS.java


// Targeting ..\nvencodeapi\PNVENCGETENCODEPROFILEGUIDCOUNT.java


// Targeting ..\nvencodeapi\PNVENCGETENCODEPROFILEGUIDS.java


// Targeting ..\nvencodeapi\PNVENCGETINPUTFORMATCOUNT.java


// Targeting ..\nvencodeapi\PNVENCGETINPUTFORMATS.java


// Targeting ..\nvencodeapi\PNVENCGETENCODECAPS.java


// Targeting ..\nvencodeapi\PNVENCGETENCODEPRESETCOUNT.java


// Targeting ..\nvencodeapi\PNVENCGETENCODEPRESETGUIDS.java


// Targeting ..\nvencodeapi\PNVENCGETENCODEPRESETCONFIG.java


// Targeting ..\nvencodeapi\PNVENCGETENCODEPRESETCONFIGEX.java


// Targeting ..\nvencodeapi\PNVENCINITIALIZEENCODER.java


// Targeting ..\nvencodeapi\PNVENCCREATEINPUTBUFFER.java


// Targeting ..\nvencodeapi\PNVENCDESTROYINPUTBUFFER.java


// Targeting ..\nvencodeapi\PNVENCCREATEBITSTREAMBUFFER.java


// Targeting ..\nvencodeapi\PNVENCDESTROYBITSTREAMBUFFER.java


// Targeting ..\nvencodeapi\PNVENCENCODEPICTURE.java


// Targeting ..\nvencodeapi\PNVENCLOCKBITSTREAM.java


// Targeting ..\nvencodeapi\PNVENCUNLOCKBITSTREAM.java


// Targeting ..\nvencodeapi\PNVENCLOCKINPUTBUFFER.java


// Targeting ..\nvencodeapi\PNVENCUNLOCKINPUTBUFFER.java


// Targeting ..\nvencodeapi\PNVENCGETENCODESTATS.java


// Targeting ..\nvencodeapi\PNVENCGETSEQUENCEPARAMS.java


// Targeting ..\nvencodeapi\PNVENCREGISTERASYNCEVENT.java


// Targeting ..\nvencodeapi\PNVENCUNREGISTERASYNCEVENT.java


// Targeting ..\nvencodeapi\PNVENCMAPINPUTRESOURCE.java


// Targeting ..\nvencodeapi\PNVENCUNMAPINPUTRESOURCE.java


// Targeting ..\nvencodeapi\PNVENCDESTROYENCODER.java


// Targeting ..\nvencodeapi\PNVENCINVALIDATEREFFRAMES.java


// Targeting ..\nvencodeapi\PNVENCOPENENCODESESSIONEX.java


// Targeting ..\nvencodeapi\PNVENCREGISTERRESOURCE.java


// Targeting ..\nvencodeapi\PNVENCUNREGISTERRESOURCE.java


// Targeting ..\nvencodeapi\PNVENCRECONFIGUREENCODER.java


// Targeting ..\nvencodeapi\PNVENCCREATEMVBUFFER.java


// Targeting ..\nvencodeapi\PNVENCDESTROYMVBUFFER.java


// Targeting ..\nvencodeapi\PNVENCRUNMOTIONESTIMATIONONLY.java


// Targeting ..\nvencodeapi\PNVENCGETLASTERROR.java


// Targeting ..\nvencodeapi\PNVENCSETIOCUDASTREAMS.java


// Targeting ..\nvencodeapi\PNVENCGETSEQUENCEPARAMEX.java


// Targeting ..\nvencodeapi\NV_ENCODE_API_FUNCTION_LIST.java



/** Macro for constructing the version field of ::_NV_ENCODEAPI_FUNCTION_LIST. */
public static native @MemberGetter int NV_ENCODE_API_FUNCTION_LIST_VER();
public static final int NV_ENCODE_API_FUNCTION_LIST_VER = NV_ENCODE_API_FUNCTION_LIST_VER();

// NvEncodeAPICreateInstance
/**
 * \ingroup ENCODE_FUNC
 * Entry Point to the NvEncodeAPI interface.
 * 
 * Creates an instance of the NvEncodeAPI interface, and populates the
 * pFunctionList with function pointers to the API routines implemented by the
 * NvEncodeAPI interface.
 *
 * @param functionList [out]
 *
 * @return
 * ::NV_ENC_SUCCESS
 * ::NV_ENC_ERR_INVALID_PTR
 */
public static native @Cast("NVENCSTATUS") int NvEncodeAPICreateInstance(NV_ENCODE_API_FUNCTION_LIST functionList);

// #ifdef __cplusplus
// #endif


// #endif



}
