// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.dnnl;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;

import static org.bytedeco.dnnl.global.dnnl.*;


/** \} dnnl_api_resampling
 <p>
 *  \addtogroup dnnl_api_reduction
 *  \{
 <p>
 *  A descriptor of reduction operation. */
@Properties(inherit = org.bytedeco.dnnl.presets.dnnl.class)
public class dnnl_reduction_desc_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public dnnl_reduction_desc_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public dnnl_reduction_desc_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public dnnl_reduction_desc_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public dnnl_reduction_desc_t position(long position) {
        return (dnnl_reduction_desc_t)super.position(position);
    }
    @Override public dnnl_reduction_desc_t getPointer(long i) {
        return new dnnl_reduction_desc_t((Pointer)this).offsetAddress(i);
    }

    /** The kind of primitive. Used for self-identifying the primitive
     *  descriptor. Must be #dnnl_reduction. */
    public native @Cast("dnnl_primitive_kind_t") int primitive_kind(); public native dnnl_reduction_desc_t primitive_kind(int setter);
    /** The kind of reduction algorithm. Possible values:
     *  #dnnl_reduction_max, #dnnl_reduction_min, #dnnl_reduction_sum,
     *  #dnnl_reduction_mul, #dnnl_reduction_mean, #dnnl_reduction_norm_lp_max,
     *  #dnnl_reduction_norm_lp_sum, #dnnl_reduction_norm_lp_power_p_max,
     *  #dnnl_reduction_norm_lp_power_p_sum. */
    public native @Cast("dnnl_alg_kind_t") int alg_kind(); public native dnnl_reduction_desc_t alg_kind(int setter);
    /** Source memory descriptor. */
    public native @ByRef dnnl_memory_desc_t src_desc(); public native dnnl_reduction_desc_t src_desc(dnnl_memory_desc_t setter);
    /** Destination memory descriptor. */
    public native @ByRef dnnl_memory_desc_t dst_desc(); public native dnnl_reduction_desc_t dst_desc(dnnl_memory_desc_t setter);
    /** Algorithm specific parameters.
     *  Accordance table:
     *  #dnnl_reduction_max: \p p and \p eps are ignored
     *  #dnnl_reduction_min: \p p and \p eps are ignored
     *  #dnnl_reduction_norm_lp_max: \p p -- power, \p eps -- epsilon
     *  #dnnl_reduction_norm_lp_sum: \p p -- power, \p eps -- epsilon
     *  #dnnl_reduction_norm_lp_power_p_max: \p p -- power, \p eps -- epsilon
     *  #dnnl_reduction_norm_lp_power_p_sum: \p p -- power, \p eps -- epsilon
     *  #dnnl_reduction_sum: \p p and \p eps are ignored
     *  #dnnl_reduction_mul: \p p and \p eps are ignored
     *  #dnnl_reduction_mean: \p p and \p eps are ignored */
    public native float p(); public native dnnl_reduction_desc_t p(float setter);
    public native float eps(); public native dnnl_reduction_desc_t eps(float setter);
}
