/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.MapCodedFont;
import org.apache.fop.render.afp.modca.MapPageOverlay;
import org.apache.fop.render.afp.modca.MaximumSizeExceededException;
import org.apache.fop.render.afp.modca.ObjectAreaDescriptor;
import org.apache.fop.render.afp.modca.ObjectAreaPosition;
import org.apache.fop.render.afp.modca.PageDescriptor;
import org.apache.fop.render.afp.modca.PresentationTextDescriptor;

public final class ActiveEnvironmentGroup
extends AbstractNamedAFPObject {
    private static final String DEFAULT_NAME = "AEG00001";
    private ArrayList _mapCodedFonts = new ArrayList();
    private ObjectAreaDescriptor _objectAreaDescriptor = null;
    private ObjectAreaPosition _objectAreaPosition = null;
    private PresentationTextDescriptor _presentationTextDataDescriptor = null;
    private PageDescriptor _pageDescriptor = null;
    private ArrayList _mapPageOverlays = new ArrayList();

    public ActiveEnvironmentGroup(int width, int height) {
        this(DEFAULT_NAME, width, height);
    }

    public ActiveEnvironmentGroup(String name, int width, int height) {
        super(name);
        this._pageDescriptor = new PageDescriptor(width, height);
        this._objectAreaDescriptor = new ObjectAreaDescriptor(width, height);
        this._presentationTextDataDescriptor = new PresentationTextDescriptor(width, height);
    }

    public void setPosition(int x, int y, int rotation) {
        this._objectAreaPosition = new ObjectAreaPosition(x, y, rotation);
    }

    public PageDescriptor getPageDescriptor() {
        return this._pageDescriptor;
    }

    public PresentationTextDescriptor getPresentationTextDataDescriptor() {
        return this._presentationTextDataDescriptor;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        this.writeObjectList(this._mapCodedFonts, os);
        this.writeObjectList(this._mapPageOverlays, os);
        this._pageDescriptor.writeDataStream(os);
        if (this._objectAreaDescriptor != null && this._objectAreaPosition != null) {
            this._objectAreaDescriptor.writeDataStream(os);
            this._objectAreaPosition.writeDataStream(os);
        }
        this._presentationTextDataDescriptor.writeDataStream(os);
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -55;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -55;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }

    public void createFont(byte fontReference, AFPFont font, int size, int orientation) {
        MapCodedFont mcf = this.getCurrentMapCodedFont();
        if (mcf == null) {
            mcf = new MapCodedFont();
            this._mapCodedFonts.add(mcf);
        }
        try {
            mcf.addFont(fontReference, font, size, orientation);
        }
        catch (MaximumSizeExceededException msee) {
            mcf = new MapCodedFont();
            this._mapCodedFonts.add(mcf);
            try {
                mcf.addFont(fontReference, font, size, orientation);
            }
            catch (MaximumSizeExceededException ex) {
                log.error((Object)"createFont():: resulted in a MaximumSizeExceededException");
            }
        }
    }

    public void createOverlay(String name) {
        MapPageOverlay mpo = this.getCurrentMapPageOverlay();
        if (mpo == null) {
            mpo = new MapPageOverlay();
            this._mapPageOverlays.add(mpo);
        }
        try {
            mpo.addOverlay(name);
        }
        catch (MaximumSizeExceededException msee) {
            mpo = new MapPageOverlay();
            this._mapPageOverlays.add(mpo);
            try {
                mpo.addOverlay(name);
            }
            catch (MaximumSizeExceededException ex) {
                log.error((Object)"createOverlay():: resulted in a MaximumSizeExceededException");
            }
        }
    }

    private MapCodedFont getCurrentMapCodedFont() {
        int size = this._mapCodedFonts.size();
        if (size > 0) {
            return (MapCodedFont)this._mapCodedFonts.get(this._mapCodedFonts.size() - 1);
        }
        return null;
    }

    private MapPageOverlay getCurrentMapPageOverlay() {
        int size = this._mapPageOverlays.size();
        if (size > 0) {
            return (MapPageOverlay)this._mapPageOverlays.get(this._mapPageOverlays.size() - 1);
        }
        return null;
    }
}

