/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.File;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.test.TestSslUtils;
import org.junit.Assert;
import org.junit.Test;

public class SslFactoryTest {
    @Test
    public void testSslFactoryConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertNotNull((Object)engine);
        Object[] expectedProtocols = new String[]{"TLSv1.2"};
        Assert.assertArrayEquals((Object[])expectedProtocols, (Object[])engine.getEnabledProtocols());
        Assert.assertEquals((Object)false, (Object)engine.getUseClientMode());
    }

    @Test
    public void testSslFactoryWithoutPasswordConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        serverSslConfig.remove("ssl.truststore.password");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        try {
            sslFactory.configure(serverSslConfig);
        }
        catch (Exception e) {
            Assert.fail((String)("An exception was thrown when configuring the truststore without a password: " + e));
        }
    }

    @Test
    public void testClientMode() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = TestSslUtils.createSslConfig(false, true, Mode.CLIENT, trustStoreFile, "client");
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertTrue((boolean)engine.getUseClientMode());
    }

    @Test
    public void testKeyStoreTrustStoreValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLContext sslContext = sslFactory.createSSLContext(this.sslKeyStore(serverSslConfig), null);
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext);
        SSLContext sslContext2 = sslFactory.createSSLContext(null, this.sslTrustStore(serverSslConfig));
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext2);
        SSLContext sslContext3 = sslFactory.createSSLContext(this.sslKeyStore(serverSslConfig), this.sslTrustStore(serverSslConfig));
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext3);
    }

    @Test
    public void testUntrustedKeyStoreValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        Map<String, Object> untrustedConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, File.createTempFile("truststore", ".jks"), "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        sslFactory.configure(serverSslConfig);
        try {
            sslFactory.createSSLContext(this.sslKeyStore(untrustedConfig), null);
            Assert.fail((String)"Validation did not fail with untrusted keystore");
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            // empty catch block
        }
        try {
            sslFactory.createSSLContext(null, this.sslTrustStore(untrustedConfig));
            Assert.fail((String)"Validation did not fail with untrusted truststore");
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            // empty catch block
        }
        try {
            sslFactory.createSSLContext(this.sslKeyStore(untrustedConfig), this.sslTrustStore(untrustedConfig));
            Assert.fail((String)"Validation did not fail with untrusted truststore");
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            // empty catch block
        }
    }

    @Test
    public void testCertificateEntriesValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        Map<String, Object> newCnConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, File.createTempFile("truststore", ".jks"), "server", "Another CN");
        KeyStore ks1 = this.sslKeyStore(serverSslConfig).load();
        KeyStore ks2 = this.sslKeyStore(serverSslConfig).load();
        Assert.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        ks2.setCertificateEntry("another", ks1.getCertificate("localhost"));
        Assert.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        KeyStore ks3 = this.sslKeyStore(newCnConfig).load();
        Assert.assertNotEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks3));
    }

    private SslFactory.SecurityStore sslKeyStore(Map<String, Object> sslConfig) {
        return new SslFactory.SecurityStore((String)sslConfig.get("ssl.keystore.type"), (String)sslConfig.get("ssl.keystore.location"), (Password)sslConfig.get("ssl.keystore.password"), (Password)sslConfig.get("ssl.key.password"));
    }

    private SslFactory.SecurityStore sslTrustStore(Map<String, Object> sslConfig) {
        return new SslFactory.SecurityStore((String)sslConfig.get("ssl.truststore.type"), (String)sslConfig.get("ssl.truststore.location"), (Password)sslConfig.get("ssl.truststore.password"), null);
    }
}

