/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LazyDownConversionRecords;
import org.apache.kafka.common.record.LazyDownConversionRecordsSend;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class LazyDownConversionRecordsTest {
    @Test
    public void testConversionOfCommitMarker() throws IOException {
        MemoryRecords recordsToConvert = MemoryRecords.withEndTransactionMarker((long)0L, (long)Time.SYSTEM.milliseconds(), (int)-1, (long)1L, (short)1, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 0));
        MemoryRecords convertedRecords = LazyDownConversionRecordsTest.convertRecords(recordsToConvert, (byte)1, recordsToConvert.sizeInBytes());
        ByteBuffer buffer = convertedRecords.buffer();
        buffer.getLong();
        int sizeOfConvertedRecords = buffer.getInt();
        Assert.assertTrue((sizeOfConvertedRecords > buffer.limit() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)convertedRecords.batchIterator().hasNext());
    }

    private static MemoryRecords convertRecords(MemoryRecords recordsToConvert, byte toMagic, int bytesToConvert) throws IOException {
        try (FileRecords inputRecords = FileRecords.open((File)TestUtils.tempFile());){
            inputRecords.append(recordsToConvert);
            inputRecords.flush();
            LazyDownConversionRecords lazyRecords = new LazyDownConversionRecords(new TopicPartition("test", 1), (Records)inputRecords, toMagic, 0L, Time.SYSTEM);
            LazyDownConversionRecordsSend lazySend = lazyRecords.toSend("foo");
            File outputFile = TestUtils.tempFile();
            FileChannel channel = new RandomAccessFile(outputFile, "rw").getChannel();
            int written = 0;
            while (written < bytesToConvert) {
                written = (int)((long)written + lazySend.writeTo((GatheringByteChannel)channel, (long)written, bytesToConvert - written));
            }
            FileRecords convertedRecords = FileRecords.open((File)outputFile, (boolean)true, (int)((int)channel.size()), (boolean)false);
            ByteBuffer convertedRecordsBuffer = ByteBuffer.allocate(convertedRecords.sizeInBytes());
            convertedRecords.readInto(convertedRecordsBuffer, 0);
            convertedRecords.close();
            channel.close();
            MemoryRecords memoryRecords = MemoryRecords.readableRecords((ByteBuffer)convertedRecordsBuffer);
            return memoryRecords;
        }
    }

    private static void verifyDownConvertedRecords(List<SimpleRecord> initialRecords, List<Long> initialOffsets, MemoryRecords downConvertedRecords, CompressionType compressionType, byte toMagic) {
        int i = 0;
        for (RecordBatch batch : downConvertedRecords.batches()) {
            Assert.assertTrue((String)("Magic byte should be lower than or equal to " + toMagic), (batch.magic() <= toMagic ? 1 : 0) != 0);
            if (batch.magic() == 0) {
                Assert.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)batch.timestampType());
            } else {
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
            }
            Assert.assertEquals((String)"Compression type should not be affected by conversion", (Object)compressionType, (Object)batch.compressionType());
            for (Record record : batch) {
                Assert.assertTrue((String)("Inner record should have magic " + toMagic), (boolean)record.hasMagic(batch.magic()));
                Assert.assertEquals((String)"Offset should not change", (long)initialOffsets.get(i), (long)record.offset());
                Assert.assertEquals((String)"Key should not change", (Object)Utils.utf8((ByteBuffer)initialRecords.get(i).key()), (Object)Utils.utf8((ByteBuffer)record.key()));
                Assert.assertEquals((String)"Value should not change", (Object)Utils.utf8((ByteBuffer)initialRecords.get(i).value()), (Object)Utils.utf8((ByteBuffer)record.value()));
                Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.LOG_APPEND_TIME));
                if (batch.magic() == 0) {
                    Assert.assertEquals((long)-1L, (long)record.timestamp());
                    Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                    Assert.assertTrue((boolean)record.hasTimestampType(TimestampType.NO_TIMESTAMP_TYPE));
                } else if (batch.magic() == 1) {
                    Assert.assertEquals((String)"Timestamp should not change", (long)initialRecords.get(i).timestamp(), (long)record.timestamp());
                    Assert.assertTrue((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                    Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.NO_TIMESTAMP_TYPE));
                } else {
                    Assert.assertEquals((String)"Timestamp should not change", (long)initialRecords.get(i).timestamp(), (long)record.timestamp());
                    Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                    Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.NO_TIMESTAMP_TYPE));
                    Assert.assertArrayEquals((String)"Headers should not change", (Object[])initialRecords.get(i).headers(), (Object[])record.headers());
                }
                ++i;
            }
        }
        Assert.assertEquals((long)initialOffsets.size(), (long)i);
    }

    @RunWith(value=Parameterized.class)
    public static class ParameterizedConversionTest {
        private final CompressionType compressionType;
        private final byte toMagic;

        public ParameterizedConversionTest(CompressionType compressionType, byte toMagic) {
            this.compressionType = compressionType;
            this.toMagic = toMagic;
        }

        @Parameterized.Parameters(name="compressionType={0}, toMagic={1}")
        public static Collection<Object[]> data() {
            ArrayList<Object[]> values = new ArrayList<Object[]>();
            for (byte toMagic = 0; toMagic <= 2; toMagic = (byte)(toMagic + 1)) {
                values.add(new Object[]{CompressionType.NONE, toMagic});
                values.add(new Object[]{CompressionType.GZIP, toMagic});
            }
            return values;
        }

        @Test
        public void testConversion() throws IOException {
            this.doTestConversion(false);
        }

        @Test
        public void testConversionWithOverflow() throws IOException {
            this.doTestConversion(true);
        }

        private void doTestConversion(boolean testConversionOverflow) throws IOException {
            int i;
            List<Long> offsets = Arrays.asList(0L, 2L, 3L, 9L, 11L, 15L, 16L, 17L, 22L, 24L);
            Header[] headers = new Header[]{new RecordHeader("headerKey1", "headerValue1".getBytes()), new RecordHeader("headerKey2", "headerValue2".getBytes()), new RecordHeader("headerKey3", "headerValue3".getBytes())};
            List<SimpleRecord> records = Arrays.asList(new SimpleRecord(1L, "k1".getBytes(), "hello".getBytes()), new SimpleRecord(2L, "k2".getBytes(), "goodbye".getBytes()), new SimpleRecord(3L, "k3".getBytes(), "hello again".getBytes()), new SimpleRecord(4L, "k4".getBytes(), "goodbye for now".getBytes()), new SimpleRecord(5L, "k5".getBytes(), "hello again".getBytes()), new SimpleRecord(6L, "k6".getBytes(), "I sense indecision".getBytes()), new SimpleRecord(7L, "k7".getBytes(), "what now".getBytes()), new SimpleRecord(8L, "k8".getBytes(), "running out".getBytes(), headers), new SimpleRecord(9L, "k9".getBytes(), "ok, almost done".getBytes()), new SimpleRecord(10L, "k10".getBytes(), "finally".getBytes(), headers));
            Assert.assertEquals((String)"incorrect test setup", (long)offsets.size(), (long)records.size());
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)this.compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            for (i = 0; i < 3; ++i) {
                builder.appendWithOffset(offsets.get(i).longValue(), records.get(i));
            }
            builder.close();
            builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)this.compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            for (i = 3; i < 6; ++i) {
                builder.appendWithOffset(offsets.get(i).longValue(), records.get(i));
            }
            builder.close();
            builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)this.compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            for (i = 6; i < 10; ++i) {
                builder.appendWithOffset(offsets.get(i).longValue(), records.get(i));
            }
            builder.close();
            buffer.flip();
            MemoryRecords recordsToConvert = MemoryRecords.readableRecords((ByteBuffer)buffer);
            int numBytesToConvert = recordsToConvert.sizeInBytes();
            if (testConversionOverflow) {
                numBytesToConvert *= 2;
            }
            MemoryRecords convertedRecords = LazyDownConversionRecordsTest.convertRecords(recordsToConvert, this.toMagic, numBytesToConvert);
            LazyDownConversionRecordsTest.verifyDownConvertedRecords(records, offsets, convertedRecords, this.compressionType, this.toMagic);
        }
    }
}

