/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.LinearExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MTableColumnStatistics;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;

class MetaStoreDirectSql {
    private static final int NO_BATCHING = -1;
    private static final int DETECT_BATCHING = 0;
    private static final Log LOG = LogFactory.getLog(MetaStoreDirectSql.class);
    private final PersistenceManager pm;
    private final DB dbType;
    private final int batchSize;
    private final boolean convertMapNullsToEmptyStrings;
    private final String defaultPartName;
    private final boolean isCompatibleDatastore;
    private static final String STATS_COLLIST = "\"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\" ";

    public MetaStoreDirectSql(PersistenceManager pm, Configuration conf) {
        this.pm = pm;
        this.dbType = this.determineDbType();
        int batchSize = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_DIRECT_SQL_PARTITION_BATCH_SIZE);
        if (batchSize == 0) {
            batchSize = this.dbType == DB.ORACLE || this.dbType == DB.MSSQL ? 1000 : -1;
        }
        this.batchSize = batchSize;
        this.convertMapNullsToEmptyStrings = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_ORM_RETRIEVE_MAPNULLS_AS_EMPTY_STRINGS);
        this.defaultPartName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        String jdoIdFactory = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_IDENTIFIER_FACTORY);
        if (!"datanucleus1".equalsIgnoreCase(jdoIdFactory)) {
            LOG.warn((Object)"Underlying metastore does not use 'datanuclues1' for its ORM naming scheme. Disabling directSQL as it uses hand-hardcoded SQL with that assumption.");
            this.isCompatibleDatastore = false;
        } else {
            boolean bl = this.isCompatibleDatastore = this.ensureDbInit() && this.runTestQuery();
            if (this.isCompatibleDatastore) {
                LOG.info((Object)("Using direct SQL, underlying DB is " + (Object)((Object)this.dbType)));
            }
        }
    }

    private DB determineDbType() {
        DB dbType = DB.OTHER;
        String productName = this.getProductName();
        if (productName != null) {
            if ((productName = productName.toLowerCase()).contains("mysql")) {
                dbType = DB.MYSQL;
            } else if (productName.contains("oracle")) {
                dbType = DB.ORACLE;
            } else if (productName.contains("microsoft sql server")) {
                dbType = DB.MSSQL;
            } else if (productName.contains("derby")) {
                dbType = DB.DERBY;
            }
        }
        return dbType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProductName() {
        try (JDOConnection jdoConn = this.pm.getDataStoreConnection();){
            String string = ((Connection)jdoConn.getNativeConnection()).getMetaData().getDatabaseProductName();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureDbInit() {
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        if (!tx.isActive()) {
            tx.begin();
            doCommit = true;
        }
        Query dbQuery = null;
        Query tblColumnQuery = null;
        Query partColumnQuery = null;
        try {
            dbQuery = this.pm.newQuery(MDatabase.class, "name == ''");
            dbQuery.execute();
            tblColumnQuery = this.pm.newQuery(MTableColumnStatistics.class, "dbName == ''");
            tblColumnQuery.execute();
            partColumnQuery = this.pm.newQuery(MPartitionColumnStatistics.class, "dbName == ''");
            partColumnQuery.execute();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            doCommit = false;
            LOG.warn((Object)"Database initialization failed; direct SQL is disabled", (Throwable)ex);
            tx.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            if (doCommit) {
                tx.commit();
            }
            if (dbQuery != null) {
                dbQuery.closeAll();
            }
            if (tblColumnQuery != null) {
                tblColumnQuery.closeAll();
            }
            if (partColumnQuery != null) {
                partColumnQuery.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTestQuery() {
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        if (!tx.isActive()) {
            tx.begin();
            doCommit = true;
        }
        Query query = null;
        String selfTestQuery = "select \"DB_ID\" from \"DBS\"";
        try {
            this.doDbSpecificInitializationsBeforeQuery();
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)selfTestQuery);
            query.execute();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            doCommit = false;
            LOG.warn((Object)("Self-test query [" + selfTestQuery + "] failed; direct SQL is disabled"), t);
            tx.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            if (doCommit) {
                tx.commit();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    public boolean isCompatibleDatastore() {
        return this.isCompatibleDatastore;
    }

    private void doDbSpecificInitializationsBeforeQuery() throws MetaException {
        if (this.dbType != DB.MYSQL) {
            return;
        }
        try {
            assert (this.pm.currentTransaction().isActive());
            this.executeNoResult("SET @@session.sql_mode=ANSI_QUOTES");
        }
        catch (SQLException sqlEx) {
            throw new MetaException("Error setting ansi quotes: " + sqlEx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNoResult(String queryText) throws SQLException {
        boolean doTrace = LOG.isDebugEnabled();
        try (JDOConnection jdoConn = this.pm.getDataStoreConnection();){
            long start = doTrace ? System.nanoTime() : 0L;
            ((Connection)jdoConn.getNativeConnection()).createStatement().execute(queryText);
            this.timingTrace(doTrace, queryText, start, doTrace ? System.nanoTime() : 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getDatabase(String dbName) throws MetaException {
        Query queryDbSelector = null;
        Query queryDbParams = null;
        try {
            List sqlResult;
            dbName = dbName.toLowerCase();
            this.doDbSpecificInitializationsBeforeQuery();
            String queryTextDbSelector = "select \"DB_ID\", \"NAME\", \"DB_LOCATION_URI\", \"DESC\", \"OWNER_NAME\", \"OWNER_TYPE\" FROM \"DBS\" where \"NAME\" = ? ";
            Object[] params = new Object[]{dbName};
            queryDbSelector = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryTextDbSelector);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("getDatabase:query instantiated : " + queryTextDbSelector + " with param [" + params[0] + "]"));
            }
            if ((sqlResult = (List)this.executeWithArray(queryDbSelector, params, queryTextDbSelector)) == null || sqlResult.isEmpty()) {
                Database database = null;
                return database;
            }
            assert (sqlResult.size() == 1);
            if (sqlResult.get(0) == null) {
                Database database = null;
                return database;
            }
            Object[] dbline = (Object[])sqlResult.get(0);
            Long dbid = MetaStoreDirectSql.extractSqlLong(dbline[0]);
            String queryTextDbParams = "select \"PARAM_KEY\", \"PARAM_VALUE\"  FROM \"DATABASE_PARAMS\"  WHERE \"DB_ID\" = ?  AND \"PARAM_KEY\" IS NOT NULL";
            params[0] = dbid;
            queryDbParams = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryTextDbParams);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("getDatabase:query2 instantiated : " + queryTextDbParams + " with param [" + params[0] + "]"));
            }
            HashMap<String, String> dbParams = new HashMap<String, String>();
            List<Object[]> sqlResult2 = this.ensureList(this.executeWithArray(queryDbParams, params, queryTextDbParams));
            if (!sqlResult2.isEmpty()) {
                for (Object[] line : sqlResult2) {
                    dbParams.put(this.extractSqlString(line[0]), this.extractSqlString(line[1]));
                }
            }
            Database db = new Database();
            db.setName(this.extractSqlString(dbline[1]));
            db.setLocationUri(this.extractSqlString(dbline[2]));
            db.setDescription(this.extractSqlString(dbline[3]));
            db.setOwnerName(this.extractSqlString(dbline[4]));
            String type = this.extractSqlString(dbline[5]);
            db.setOwnerType(null == type || type.trim().isEmpty() ? null : PrincipalType.valueOf(type));
            db.setParameters(MetaStoreUtils.trimMapNulls(dbParams, this.convertMapNullsToEmptyStrings));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getDatabase: directsql returning db " + db.getName() + " locn[" + db.getLocationUri() + "] desc [" + db.getDescription() + "] owner [" + db.getOwnerName() + "] ownertype [" + (Object)((Object)db.getOwnerType()) + "]"));
            }
            Database database = db;
            return database;
        }
        finally {
            if (queryDbSelector != null) {
                queryDbSelector.closeAll();
            }
            if (queryDbParams != null) {
                queryDbParams.closeAll();
            }
        }
    }

    public List<Partition> getPartitionsViaSqlFilter(String dbName, String tblName, List<String> partNames) throws MetaException {
        if (partNames.isEmpty()) {
            return new ArrayList<Partition>();
        }
        return this.getPartitionsViaSqlFilterInternal(dbName, tblName, null, "\"PARTITIONS\".\"PART_NAME\" in (" + this.makeParams(partNames.size()) + ")", partNames, new ArrayList<String>(), null);
    }

    public List<Partition> getPartitionsViaSqlFilter(Table table, ExpressionTree tree, Integer max) throws MetaException {
        assert (tree != null);
        ArrayList params = new ArrayList();
        ArrayList<String> joins = new ArrayList<String>();
        boolean dbHasJoinCastBug = this.dbType == DB.DERBY || this.dbType == DB.ORACLE;
        String sqlFilter = PartitionFilterGenerator.generateSqlFilter(table, tree, params, joins, dbHasJoinCastBug, this.defaultPartName);
        if (sqlFilter == null) {
            return null;
        }
        Boolean isViewTable = MetaStoreDirectSql.isViewTable(table);
        return this.getPartitionsViaSqlFilterInternal(table.getDbName(), table.getTableName(), isViewTable, sqlFilter, params, joins, max);
    }

    public List<Partition> getPartitions(String dbName, String tblName, Integer max) throws MetaException {
        return this.getPartitionsViaSqlFilterInternal(dbName, tblName, null, null, new ArrayList(), new ArrayList<String>(), max);
    }

    private static Boolean isViewTable(Table t) {
        return t.isSetTableType() ? Boolean.valueOf(t.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isViewTable(String dbName, String tblName) throws MetaException {
        Query query = null;
        try {
            String queryText = "select \"TBL_TYPE\" from \"TBLS\" inner join \"DBS\" on \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"  where \"TBLS\".\"TBL_NAME\" = ? and \"DBS\".\"NAME\" = ?";
            Object[] params = new Object[]{tblName, dbName};
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            query.setUnique(true);
            Object result = this.executeWithArray(query, params, queryText);
            boolean bl = result != null && result.toString().equals(TableType.VIRTUAL_VIEW.toString());
            return bl;
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private List<Partition> getPartitionsViaSqlFilterInternal(String dbName, String tblName, Boolean isView, String sqlFilter, List<? extends Object> paramsForFilter, List<String> joinsForFilter, Integer max) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        dbName = dbName.toLowerCase();
        tblName = tblName.toLowerCase();
        String orderForFilter = max != null ? " order by \"PART_NAME\" asc" : "";
        this.doDbSpecificInitializationsBeforeQuery();
        String queryText = "select \"PARTITIONS\".\"PART_ID\" from \"PARTITIONS\"  inner join \"TBLS\" on \"PARTITIONS\".\"TBL_ID\" = \"TBLS\".\"TBL_ID\"     and \"TBLS\".\"TBL_NAME\" = ?   inner join \"DBS\" on \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"      and \"DBS\".\"NAME\" = ? " + StringUtils.join(joinsForFilter, (char)' ') + (StringUtils.isBlank((String)sqlFilter) ? "" : " where " + sqlFilter) + orderForFilter;
        Object[] params = new Object[paramsForFilter.size() + 2];
        params[0] = tblName;
        params[1] = dbName;
        for (int i = 0; i < paramsForFilter.size(); ++i) {
            params[i + 2] = paramsForFilter.get(i);
        }
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        if (max != null) {
            query.setRange(0L, (long)max.shortValue());
        }
        List sqlResult = (List)this.executeWithArray(query, params, queryText);
        long queryTime = doTrace ? System.nanoTime() : 0L;
        this.timingTrace(doTrace, queryText, start, queryTime);
        if (sqlResult.isEmpty()) {
            return new ArrayList<Partition>();
        }
        List<Partition> result = null;
        if (this.batchSize != -1 && this.batchSize < sqlResult.size()) {
            result = new ArrayList<Partition>(sqlResult.size());
            while (result.size() < sqlResult.size()) {
                int toIndex = Math.min(result.size() + this.batchSize, sqlResult.size());
                List<Object> batchedSqlResult = sqlResult.subList(result.size(), toIndex);
                result.addAll(this.getPartitionsFromPartitionIds(dbName, tblName, isView, batchedSqlResult));
            }
        } else {
            result = this.getPartitionsFromPartitionIds(dbName, tblName, isView, sqlResult);
        }
        query.closeAll();
        return result;
    }

    private List<Partition> getPartitionsFromPartitionIds(String dbName, String tblName, Boolean isView, List<Object> partIdList) throws MetaException {
        boolean hasSkewedColumns;
        boolean doTrace = LOG.isDebugEnabled();
        int idStringWidth = (int)Math.ceil(Math.log10(partIdList.size())) + 1;
        int sbCapacity = partIdList.size() * idStringWidth;
        StringBuilder partSb = new StringBuilder(sbCapacity);
        for (Object partitionId : partIdList) {
            partSb.append(MetaStoreDirectSql.extractSqlLong(partitionId)).append(",");
        }
        String partIds = MetaStoreDirectSql.trimCommaList(partSb);
        String queryText = "select \"PARTITIONS\".\"PART_ID\", \"SDS\".\"SD_ID\", \"SDS\".\"CD_ID\", \"SERDES\".\"SERDE_ID\", \"PARTITIONS\".\"CREATE_TIME\", \"PARTITIONS\".\"LAST_ACCESS_TIME\", \"SDS\".\"INPUT_FORMAT\", \"SDS\".\"IS_COMPRESSED\", \"SDS\".\"IS_STOREDASSUBDIRECTORIES\", \"SDS\".\"LOCATION\", \"SDS\".\"NUM_BUCKETS\", \"SDS\".\"OUTPUT_FORMAT\", \"SERDES\".\"NAME\", \"SERDES\".\"SLIB\" from \"PARTITIONS\"  left outer join \"SDS\" on \"PARTITIONS\".\"SD_ID\" = \"SDS\".\"SD_ID\"   left outer join \"SERDES\" on \"SDS\".\"SERDE_ID\" = \"SERDES\".\"SERDE_ID\" where \"PART_ID\" in (" + partIds + ") order by \"PART_NAME\" asc";
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List sqlResult = (List)this.executeWithArray(query, null, queryText);
        long queryTime = doTrace ? System.nanoTime() : 0L;
        Deadline.checkTimeout();
        TreeMap<Long, Partition> partitions = new TreeMap<Long, Partition>();
        TreeMap<Long, StorageDescriptor> sds = new TreeMap<Long, StorageDescriptor>();
        TreeMap<Long, SerDeInfo> serdes = new TreeMap<Long, SerDeInfo>();
        TreeMap colss = new TreeMap();
        ArrayList<Partition> orderedResult = new ArrayList<Partition>(partIdList.size());
        StringBuilder sdSb = new StringBuilder(sbCapacity);
        StringBuilder serdeSb = new StringBuilder(sbCapacity);
        StringBuilder colsSb = new StringBuilder(7);
        tblName = tblName.toLowerCase();
        dbName = dbName.toLowerCase();
        for (Object[] fields : sqlResult) {
            long partitionId = MetaStoreDirectSql.extractSqlLong(fields[0]);
            Long sdId = MetaStoreDirectSql.extractSqlLong(fields[1]);
            Long colId = MetaStoreDirectSql.extractSqlLong(fields[2]);
            Long serdeId = MetaStoreDirectSql.extractSqlLong(fields[3]);
            if (sdId == null || colId == null || serdeId == null) {
                if (isView == null) {
                    isView = this.isViewTable(dbName, tblName);
                }
                if (sdId != null || colId != null || serdeId != null || !isView.booleanValue()) {
                    throw new MetaException("Unexpected null for one of the IDs, SD " + sdId + ", column " + colId + ", serde " + serdeId + " for a " + (isView != false ? "" : "non-") + " view");
                }
            }
            Partition part = new Partition();
            orderedResult.add(part);
            part.setParameters(new HashMap<String, String>());
            part.setValues(new ArrayList<String>());
            part.setDbName(dbName);
            part.setTableName(tblName);
            if (fields[4] != null) {
                part.setCreateTime(this.extractSqlInt(fields[4]));
            }
            if (fields[5] != null) {
                part.setLastAccessTime(this.extractSqlInt(fields[5]));
            }
            partitions.put(partitionId, part);
            if (sdId == null) continue;
            assert (colId != null && serdeId != null);
            StorageDescriptor sd = new StorageDescriptor();
            StorageDescriptor oldSd = sds.put(sdId, sd);
            if (oldSd != null) {
                throw new MetaException("Partitions reuse SDs; we don't expect that");
            }
            sd.setSortCols(new ArrayList<Order>());
            sd.setBucketCols(new ArrayList<String>());
            sd.setParameters(new HashMap<String, String>());
            sd.setSkewedInfo(new SkewedInfo(new ArrayList<String>(), new ArrayList<List<String>>(), new HashMap<List<String>, String>()));
            sd.setInputFormat((String)fields[6]);
            Boolean tmpBoolean = MetaStoreDirectSql.extractSqlBoolean(fields[7]);
            if (tmpBoolean != null) {
                sd.setCompressed(tmpBoolean);
            }
            if ((tmpBoolean = MetaStoreDirectSql.extractSqlBoolean(fields[8])) != null) {
                sd.setStoredAsSubDirectories(tmpBoolean);
            }
            sd.setLocation((String)fields[9]);
            if (fields[10] != null) {
                sd.setNumBuckets(this.extractSqlInt(fields[10]));
            }
            sd.setOutputFormat((String)fields[11]);
            sdSb.append(sdId).append(",");
            part.setSd(sd);
            ArrayList cols = (ArrayList)colss.get(colId);
            if (cols == null) {
                cols = new ArrayList();
                colss.put(colId, cols);
                colsSb.append(colId).append(",");
            }
            sd.setCols(cols);
            SerDeInfo serde = new SerDeInfo();
            SerDeInfo oldSerde = serdes.put(serdeId, serde);
            if (oldSerde != null) {
                throw new MetaException("SDs reuse serdes; we don't expect that");
            }
            serde.setParameters(new HashMap<String, String>());
            serde.setName((String)fields[12]);
            serde.setSerializationLib((String)fields[13]);
            serdeSb.append(serdeId).append(",");
            sd.setSerdeInfo(serde);
            Deadline.checkTimeout();
        }
        query.closeAll();
        this.timingTrace(doTrace, queryText, start, queryTime);
        queryText = "select \"PART_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"PARTITION_PARAMS\" where \"PART_ID\" in (" + partIds + ") and \"PARAM_KEY\" is not null" + " order by \"PART_ID\" asc";
        this.loopJoinOrderedResult(partitions, queryText, 0, new ApplyFunc<Partition>(){

            @Override
            public void apply(Partition t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        queryText = "select \"PART_ID\", \"PART_KEY_VAL\" from \"PARTITION_KEY_VALS\" where \"PART_ID\" in (" + partIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"PART_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(partitions, queryText, 0, new ApplyFunc<Partition>(){

            @Override
            public void apply(Partition t, Object[] fields) {
                t.addToValues((String)fields[1]);
            }
        });
        if (sdSb.length() == 0) {
            assert (serdeSb.length() == 0 && colsSb.length() == 0);
            return orderedResult;
        }
        String sdIds = MetaStoreDirectSql.trimCommaList(sdSb);
        String serdeIds = MetaStoreDirectSql.trimCommaList(serdeSb);
        String colIds = MetaStoreDirectSql.trimCommaList(colsSb);
        queryText = "select \"SD_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"SD_PARAMS\" where \"SD_ID\" in (" + sdIds + ") and \"PARAM_KEY\" is not null" + " order by \"SD_ID\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        queryText = "select \"SD_ID\", \"COLUMN_NAME\", \"SORT_COLS\".\"ORDER\" from \"SORT_COLS\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                if (fields[2] == null) {
                    return;
                }
                t.addToSortCols(new Order((String)fields[1], MetaStoreDirectSql.this.extractSqlInt(fields[2])));
            }
        });
        queryText = "select \"SD_ID\", \"BUCKET_COL_NAME\" from \"BUCKETING_COLS\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                t.addToBucketCols((String)fields[1]);
            }
        });
        queryText = "select \"SD_ID\", \"SKEWED_COL_NAME\" from \"SKEWED_COL_NAMES\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        boolean bl = hasSkewedColumns = this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                if (!t.isSetSkewedInfo()) {
                    t.setSkewedInfo(new SkewedInfo());
                }
                t.getSkewedInfo().addToSkewedColNames((String)fields[1]);
            }
        }) > 0;
        if (hasSkewedColumns) {
            queryText = "select \"SKEWED_VALUES\".\"SD_ID_OID\",  \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\",  \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_VALUE\" from \"SKEWED_VALUES\"   left outer join \"SKEWED_STRING_LIST_VALUES\" on \"SKEWED_VALUES\".\"STRING_LIST_ID_EID\" = \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\" where \"SKEWED_VALUES\".\"SD_ID_OID\" in (" + sdIds + ") " + "  and \"SKEWED_VALUES\".\"STRING_LIST_ID_EID\" is not null " + "  and \"SKEWED_VALUES\".\"INTEGER_IDX\" >= 0 " + "order by \"SKEWED_VALUES\".\"SD_ID_OID\" asc, \"SKEWED_VALUES\".\"INTEGER_IDX\" asc," + "  \"SKEWED_STRING_LIST_VALUES\".\"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){
                private Long currentListId;
                private List<String> currentList;

                @Override
                public void apply(StorageDescriptor t, Object[] fields) throws MetaException {
                    if (!t.isSetSkewedInfo()) {
                        t.setSkewedInfo(new SkewedInfo());
                    }
                    if (fields[1] == null) {
                        this.currentList = null;
                        this.currentListId = null;
                        t.getSkewedInfo().addToSkewedColValues(new ArrayList<String>());
                    } else {
                        long fieldsListId = MetaStoreDirectSql.extractSqlLong(fields[1]);
                        if (this.currentListId == null || fieldsListId != this.currentListId) {
                            this.currentList = new ArrayList<String>();
                            this.currentListId = fieldsListId;
                            t.getSkewedInfo().addToSkewedColValues(this.currentList);
                        }
                        this.currentList.add((String)fields[2]);
                    }
                }
            });
            queryText = "select \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\", \"SKEWED_STRING_LIST_VALUES\".STRING_LIST_ID, \"SKEWED_COL_VALUE_LOC_MAP\".\"LOCATION\", \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_VALUE\" from \"SKEWED_COL_VALUE_LOC_MAP\"  left outer join \"SKEWED_STRING_LIST_VALUES\" on \"SKEWED_COL_VALUE_LOC_MAP\".\"STRING_LIST_ID_KID\" = \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\" where \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\" in (" + sdIds + ")" + "  and \"SKEWED_COL_VALUE_LOC_MAP\".\"STRING_LIST_ID_KID\" is not null " + "order by \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\" asc," + "  \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\" asc," + "  \"SKEWED_STRING_LIST_VALUES\".\"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){
                private Long currentListId;
                private List<String> currentList;

                @Override
                public void apply(StorageDescriptor t, Object[] fields) throws MetaException {
                    if (!t.isSetSkewedInfo()) {
                        SkewedInfo skewedInfo = new SkewedInfo();
                        skewedInfo.setSkewedColValueLocationMaps(new HashMap<List<String>, String>());
                        t.setSkewedInfo(skewedInfo);
                    }
                    Map<List<String>, String> skewMap = t.getSkewedInfo().getSkewedColValueLocationMaps();
                    if (fields[1] == null) {
                        this.currentList = new ArrayList<String>();
                        this.currentListId = null;
                    } else {
                        long fieldsListId = MetaStoreDirectSql.extractSqlLong(fields[1]);
                        if (this.currentListId == null || fieldsListId != this.currentListId) {
                            this.currentList = new ArrayList<String>();
                            this.currentListId = fieldsListId;
                        } else {
                            skewMap.remove(this.currentList);
                        }
                        this.currentList.add((String)fields[3]);
                    }
                    skewMap.put(this.currentList, (String)fields[2]);
                }
            });
        }
        if (!colss.isEmpty()) {
            queryText = "select \"CD_ID\", \"COMMENT\", \"COLUMN_NAME\", \"TYPE_NAME\" from \"COLUMNS_V2\" where \"CD_ID\" in (" + colIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"CD_ID\" asc, \"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(colss, queryText, 0, new ApplyFunc<List<FieldSchema>>(){

                @Override
                public void apply(List<FieldSchema> t, Object[] fields) {
                    t.add(new FieldSchema((String)fields[2], (String)fields[3], (String)fields[1]));
                }
            });
        }
        queryText = "select \"SERDE_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"SERDE_PARAMS\" where \"SERDE_ID\" in (" + serdeIds + ") and \"PARAM_KEY\" is not null" + " order by \"SERDE_ID\" asc";
        this.loopJoinOrderedResult(serdes, queryText, 0, new ApplyFunc<SerDeInfo>(){

            @Override
            public void apply(SerDeInfo t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        return orderedResult;
    }

    private void timingTrace(boolean doTrace, String queryText, long start, long queryTime) {
        if (!doTrace) {
            return;
        }
        LOG.debug((Object)("Direct SQL query in " + (double)(queryTime - start) / 1000000.0 + "ms + " + (double)(System.nanoTime() - queryTime) / 1000000.0 + "ms, the query is [" + queryText + "]"));
    }

    static Long extractSqlLong(Object obj) throws MetaException {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Number)) {
            throw new MetaException("Expected numeric type but got " + obj.getClass().getName());
        }
        return ((Number)obj).longValue();
    }

    private static Boolean extractSqlBoolean(Object value) throws MetaException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        Character c = null;
        if (value instanceof String && ((String)value).length() == 1) {
            c = Character.valueOf(((String)value).charAt(0));
        }
        if (c == null) {
            return null;
        }
        if (c.charValue() == 'Y') {
            return true;
        }
        if (c.charValue() == 'N') {
            return false;
        }
        throw new MetaException("Cannot extract boolean from column value " + value);
    }

    private int extractSqlInt(Object field) {
        return ((Number)field).intValue();
    }

    private String extractSqlString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private static String trimCommaList(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private <T> int loopJoinOrderedResult(TreeMap<Long, T> tree, String queryText, int keyIndex, ApplyFunc<T> func) throws MetaException {
        long queryTime;
        boolean doTrace = LOG.isDebugEnabled();
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        Object result = query.execute();
        long l = queryTime = doTrace ? System.nanoTime() : 0L;
        if (result == null) {
            query.closeAll();
            return 0;
        }
        List<Object[]> list = this.ensureList(result);
        Iterator<Object[]> iter = list.iterator();
        Object[] fields = null;
        for (Map.Entry<Long, T> entry : tree.entrySet()) {
            if (fields == null && !iter.hasNext()) break;
            long id = entry.getKey();
            while (fields != null || iter.hasNext()) {
                long nestedId;
                if (fields == null) {
                    fields = iter.next();
                }
                if ((nestedId = MetaStoreDirectSql.extractSqlLong(fields[keyIndex]).longValue()) < id) {
                    throw new MetaException("Found entries for unknown ID " + nestedId);
                }
                if (nestedId > id) break;
                func.apply(entry.getValue(), fields);
                fields = null;
            }
            Deadline.checkTimeout();
        }
        int rv = list.size();
        query.closeAll();
        this.timingTrace(doTrace, queryText, start, queryTime);
        return rv;
    }

    public ColumnStatistics getTableStats(String dbName, String tableName, List<String> colNames) throws MetaException {
        long queryTime;
        if (colNames.isEmpty()) {
            return null;
        }
        this.doDbSpecificInitializationsBeforeQuery();
        boolean doTrace = LOG.isDebugEnabled();
        long start = doTrace ? System.nanoTime() : 0L;
        String queryText = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\"  from \"TAB_COL_STATS\"  where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ")";
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        Object[] params = new Object[colNames.size() + 2];
        params[0] = dbName;
        params[1] = tableName;
        for (int i = 0; i < colNames.size(); ++i) {
            params[i + 2] = colNames.get(i);
        }
        Object qResult = this.executeWithArray(query, params, queryText);
        long l = queryTime = doTrace ? System.nanoTime() : 0L;
        if (qResult == null) {
            query.closeAll();
            return null;
        }
        List<Object[]> list = this.ensureList(qResult);
        if (list.isEmpty()) {
            return null;
        }
        ColumnStatisticsDesc csd = new ColumnStatisticsDesc(true, dbName, tableName);
        ColumnStatistics result = this.makeColumnStats(list, csd, 0);
        this.timingTrace(doTrace, queryText, start, queryTime);
        query.closeAll();
        return result;
    }

    public AggrStats aggrColStatsForPartitions(String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException {
        long partsFound = this.partsFoundForPartitions(dbName, tableName, partNames, colNames);
        List<ColumnStatisticsObj> stats = this.columnStatisticsObjForPartitions(dbName, tableName, partNames, colNames, partsFound);
        return new AggrStats(stats, partsFound);
    }

    private long partsFoundForPartitions(String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException {
        long partsFound = 0L;
        boolean doTrace = LOG.isDebugEnabled();
        String queryText = "select count(\"COLUMN_NAME\") from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ")" + " and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ")" + " group by \"PARTITION_NAME\"";
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        Object qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, colNames), queryText);
        long end = doTrace ? System.nanoTime() : 0L;
        this.timingTrace(doTrace, queryText, start, end);
        ForwardQueryResult fqr = (ForwardQueryResult)qResult;
        Iterator iter = fqr.iterator();
        while (iter.hasNext()) {
            if (MetaStoreDirectSql.extractSqlLong(iter.next()) != (long)colNames.size()) continue;
            ++partsFound;
        }
        query.closeAll();
        return partsFound;
    }

    private List<ColumnStatisticsObj> columnStatisticsObjForPartitions(String dbName, String tableName, List<String> partNames, List<String> colNames, long partsFound) throws MetaException {
        this.doDbSpecificInitializationsBeforeQuery();
        String commonPrefix = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", min(\"LONG_LOW_VALUE\"), max(\"LONG_HIGH_VALUE\"), min(\"DOUBLE_LOW_VALUE\"), max(\"DOUBLE_HIGH_VALUE\"), min(\"BIG_DECIMAL_LOW_VALUE\"), max(\"BIG_DECIMAL_HIGH_VALUE\"), sum(\"NUM_NULLS\"), max(\"NUM_DISTINCTS\"), max(\"AVG_COL_LEN\"), max(\"MAX_COL_LEN\"), sum(\"NUM_TRUES\"), sum(\"NUM_FALSES\") from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? ";
        String queryText = null;
        long start = 0L;
        long end = 0L;
        Query query = null;
        boolean doTrace = LOG.isDebugEnabled();
        Object qResult = null;
        ForwardQueryResult fqr = null;
        if (partsFound == (long)partNames.size()) {
            queryText = commonPrefix + " and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ")" + " and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ")" + " group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, colNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Lists.newArrayList();
            }
            end = doTrace ? System.nanoTime() : 0L;
            this.timingTrace(doTrace, queryText, start, end);
            List<Object[]> list = this.ensureList(qResult);
            ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>(list.size());
            for (Object[] row : list) {
                colStats.add(this.prepareCSObj(row, 0));
                Deadline.checkTimeout();
            }
            query.closeAll();
            return colStats;
        }
        ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>(colNames.size());
        queryText = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", count(\"PARTITION_NAME\")  from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ")" + " and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ")" + " group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
        start = doTrace ? System.nanoTime() : 0L;
        query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, colNames), queryText);
        end = doTrace ? System.nanoTime() : 0L;
        this.timingTrace(doTrace, queryText, start, end);
        if (qResult == null) {
            query.closeAll();
            return Lists.newArrayList();
        }
        ArrayList<String> noExtraColumnNames = new ArrayList<String>();
        HashMap<String, String[]> extraColumnNameTypeParts = new HashMap<String, String[]>();
        List<Object[]> list = this.ensureList(qResult);
        for (Object[] row : list) {
            String colName = (String)row[0];
            String colType = (String)row[1];
            Long count = MetaStoreDirectSql.extractSqlLong(row[2]);
            if (count == (long)partNames.size() || count < 2L) {
                noExtraColumnNames.add(colName);
            } else {
                extraColumnNameTypeParts.put(colName, new String[]{colType, String.valueOf(count)});
            }
            Deadline.checkTimeout();
        }
        query.closeAll();
        if (noExtraColumnNames.size() != 0) {
            queryText = commonPrefix + " and \"COLUMN_NAME\" in (" + this.makeParams(noExtraColumnNames.size()) + ")" + " and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ")" + " group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, noExtraColumnNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Lists.newArrayList();
            }
            list = this.ensureList(qResult);
            for (Object[] row : list) {
                colStats.add(this.prepareCSObj(row, 0));
                Deadline.checkTimeout();
            }
            end = doTrace ? System.nanoTime() : 0L;
            this.timingTrace(doTrace, queryText, start, end);
            query.closeAll();
        }
        if (extraColumnNameTypeParts.size() != 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap sumMap = new HashMap();
            queryText = "select \"COLUMN_NAME\", sum(\"NUM_NULLS\"), sum(\"NUM_TRUES\"), sum(\"NUM_FALSES\") from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (" + this.makeParams(extraColumnNameTypeParts.size()) + ")" + " and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ")" + " group by \"COLUMN_NAME\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            ArrayList<String> extraColumnNames = new ArrayList<String>();
            extraColumnNames.addAll(extraColumnNameTypeParts.keySet());
            qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, extraColumnNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Lists.newArrayList();
            }
            list = this.ensureList(qResult);
            Integer[] sumIndex = new Integer[]{6, 10, 11};
            for (Object[] objectArray : list) {
                HashMap<Integer, Object> indexToObject = new HashMap<Integer, Object>();
                for (int ind = 1; ind < objectArray.length; ++ind) {
                    indexToObject.put(sumIndex[ind - 1], objectArray[ind]);
                }
                sumMap.put((String)objectArray[0], indexToObject);
                Deadline.checkTimeout();
            }
            end = doTrace ? System.nanoTime() : 0L;
            this.timingTrace(doTrace, queryText, start, end);
            query.closeAll();
            for (Map.Entry entry : extraColumnNameTypeParts.entrySet()) {
                Object[] row = new Object[IExtrapolatePartStatus.colStatNames.length + 2];
                String colName = (String)entry.getKey();
                String colType = ((String[])entry.getValue())[0];
                Long sumVal = Long.parseLong(((String[])entry.getValue())[1]);
                row[0] = colName;
                row[1] = colType;
                LinearExtrapolatePartStatus extrapolateMethod = new LinearExtrapolatePartStatus();
                Integer[] index = IExtrapolatePartStatus.indexMaps.get(colType.toLowerCase());
                if (index == null) {
                    index = IExtrapolatePartStatus.indexMaps.get("default");
                }
                Integer[] arr$ = index;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int colStatIndex = arr$[i$];
                    String colStatName = IExtrapolatePartStatus.colStatNames[colStatIndex];
                    if (IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Sum) {
                        Object o = ((Map)sumMap.get(colName)).get(colStatIndex);
                        if (o == null) {
                            row[2 + colStatIndex] = null;
                            continue;
                        }
                        Long val = MetaStoreDirectSql.extractSqlLong(o);
                        row[2 + colStatIndex] = val / sumVal * (long)partNames.size();
                        continue;
                    }
                    queryText = "select \"" + colStatName + "\",\"PARTITION_NAME\" from \"PART_COL_STATS\"" + " where \"DB_NAME\" = ? and \"TABLE_NAME\" = ?" + " and \"COLUMN_NAME\" = ?" + " and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ")" + " order by '" + colStatName + "'";
                    start = doTrace ? System.nanoTime() : 0L;
                    query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                    qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, Arrays.asList(colName)), queryText);
                    if (qResult == null) {
                        query.closeAll();
                        return Lists.newArrayList();
                    }
                    fqr = qResult;
                    Object[] min = (Object[])fqr.get(0);
                    Object[] max = (Object[])fqr.get(fqr.size() - 1);
                    end = doTrace ? System.nanoTime() : 0L;
                    this.timingTrace(doTrace, queryText, start, end);
                    query.closeAll();
                    row[2 + colStatIndex] = min[0] == null || max[0] == null ? null : extrapolateMethod.extrapolate(min, max, colStatIndex, indexMap);
                }
                colStats.add(this.prepareCSObj(row, 0));
                Deadline.checkTimeout();
            }
        }
        return colStats;
    }

    private ColumnStatisticsObj prepareCSObj(Object[] row, int i) throws MetaException {
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj cso = new ColumnStatisticsObj((String)row[i++], (String)row[i++], data);
        Object llow = row[i++];
        Object lhigh = row[i++];
        Object dlow = row[i++];
        Object dhigh = row[i++];
        Object declow = row[i++];
        Object dechigh = row[i++];
        Object nulls = row[i++];
        Object dist = row[i++];
        Object avglen = row[i++];
        Object maxlen = row[i++];
        Object trues = row[i++];
        Object falses = row[i++];
        StatObjectConverter.fillColumnStatisticsData(cso.getColType(), data, llow, lhigh, dlow, dhigh, declow, dechigh, nulls, dist, avglen, maxlen, trues, falses);
        return cso;
    }

    private Object[] prepareParams(String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException {
        Object[] params = new Object[colNames.size() + partNames.size() + 2];
        int paramI = 0;
        params[paramI++] = dbName;
        params[paramI++] = tableName;
        for (String colName : colNames) {
            params[paramI++] = colName;
        }
        for (String partName : partNames) {
            params[paramI++] = partName;
        }
        return params;
    }

    public List<ColumnStatistics> getPartitionStats(String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException {
        long queryTime;
        if (colNames.isEmpty() || partNames.isEmpty()) {
            return Lists.newArrayList();
        }
        boolean doTrace = LOG.isDebugEnabled();
        this.doDbSpecificInitializationsBeforeQuery();
        long start = doTrace ? System.nanoTime() : 0L;
        String queryText = "select \"PARTITION_NAME\", \"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\"  from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ") AND \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") order by \"PARTITION_NAME\"";
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        Object qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, colNames), queryText);
        long l = queryTime = doTrace ? System.nanoTime() : 0L;
        if (qResult == null) {
            query.closeAll();
            return Lists.newArrayList();
        }
        List<Object[]> list = this.ensureList(qResult);
        ArrayList<ColumnStatistics> result = new ArrayList<ColumnStatistics>(Math.min(list.size(), partNames.size()));
        String lastPartName = null;
        int from = 0;
        for (int i = 0; i <= list.size(); ++i) {
            String partName;
            boolean isLast = i == list.size();
            String string = partName = isLast ? null : (String)list.get(i)[0];
            if (!isLast && partName.equals(lastPartName)) continue;
            if (from != i) {
                ColumnStatisticsDesc csd = new ColumnStatisticsDesc(false, dbName, tableName);
                csd.setPartName(lastPartName);
                result.add(this.makeColumnStats(list.subList(from, i), csd, 1));
            }
            lastPartName = partName;
            from = i;
            Deadline.checkTimeout();
        }
        this.timingTrace(doTrace, queryText, start, queryTime);
        query.closeAll();
        return result;
    }

    private ColumnStatistics makeColumnStats(List<Object[]> list, ColumnStatisticsDesc csd, int offset) throws MetaException {
        ColumnStatistics result = new ColumnStatistics();
        result.setStatsDesc(csd);
        ArrayList<ColumnStatisticsObj> csos = new ArrayList<ColumnStatisticsObj>(list.size());
        for (Object[] row : list) {
            Object laObj = row[offset + 14];
            if (!(laObj == null || csd.isSetLastAnalyzed() && csd.getLastAnalyzed() <= MetaStoreDirectSql.extractSqlLong(laObj))) {
                csd.setLastAnalyzed(MetaStoreDirectSql.extractSqlLong(laObj));
            }
            csos.add(this.prepareCSObj(row, offset));
            Deadline.checkTimeout();
        }
        result.setStatsObj(csos);
        return result;
    }

    private List<Object[]> ensureList(Object result) throws MetaException {
        if (!(result instanceof List)) {
            throw new MetaException("Wrong result type " + result.getClass());
        }
        return (List)result;
    }

    private String makeParams(int size) {
        return size == 0 ? "" : StringUtils.repeat((String)",?", (int)size).substring(1);
    }

    private <T> T executeWithArray(Query query, Object[] params, String sql) throws MetaException {
        try {
            return (T)(params == null ? query.execute() : query.executeWithArray(params));
        }
        catch (Exception ex) {
            String error = "Failed to execute [" + sql + "] with parameters [";
            if (params != null) {
                boolean isFirst = true;
                for (Object param : params) {
                    error = error + (isFirst ? "" : ", ") + param;
                    isFirst = false;
                }
            }
            LOG.warn((Object)(error + "]"), (Throwable)ex);
            throw new MetaException("See previous errors; " + ex.getMessage());
        }
    }

    private static class PartitionFilterGenerator
    extends ExpressionTree.TreeVisitor {
        private final Table table;
        private final ExpressionTree.FilterBuilder filterBuffer;
        private final List<Object> params;
        private final List<String> joins;
        private final boolean dbHasJoinCastBug;
        private final String defaultPartName;

        private PartitionFilterGenerator(Table table, List<Object> params, List<String> joins, boolean dbHasJoinCastBug, String defaultPartName) {
            this.table = table;
            this.params = params;
            this.joins = joins;
            this.dbHasJoinCastBug = dbHasJoinCastBug;
            this.filterBuffer = new ExpressionTree.FilterBuilder(false);
            this.defaultPartName = defaultPartName;
        }

        private static String generateSqlFilter(Table table, ExpressionTree tree, List<Object> params, List<String> joins, boolean dbHasJoinCastBug, String defaultPartName) throws MetaException {
            assert (table != null);
            if (tree.getRoot() == null) {
                return "";
            }
            PartitionFilterGenerator visitor = new PartitionFilterGenerator(table, params, joins, dbHasJoinCastBug, defaultPartName);
            tree.accept(visitor);
            if (visitor.filterBuffer.hasError()) {
                LOG.info((Object)("Unable to push down SQL filter: " + visitor.filterBuffer.getErrorMessage()));
                return null;
            }
            for (int i = 0; i < joins.size(); ++i) {
                if (joins.get(i) != null) continue;
                joins.remove(i--);
            }
            return "(" + visitor.filterBuffer.getFilter() + ")";
        }

        @Override
        protected void beginTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(" (");
        }

        @Override
        protected void midTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(node.getAndOr() == ExpressionTree.LogicalOperator.AND ? " and " : " or ");
        }

        @Override
        protected void endTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(") ");
        }

        @Override
        protected boolean shouldStop() {
            return this.filterBuffer.hasError();
        }

        @Override
        public void visit(ExpressionTree.LeafNode node) throws MetaException {
            if (node.operator == ExpressionTree.Operator.LIKE) {
                this.filterBuffer.setError("LIKE is not supported for SQL filter pushdown");
                return;
            }
            int partColCount = this.table.getPartitionKeys().size();
            int partColIndex = node.getPartColIndexForFilter(this.table, this.filterBuffer);
            if (this.filterBuffer.hasError()) {
                return;
            }
            String colTypeStr = this.table.getPartitionKeys().get(partColIndex).getType();
            FilterType colType = FilterType.fromType(colTypeStr);
            if (colType == FilterType.Invalid) {
                this.filterBuffer.setError("Filter pushdown not supported for type " + colTypeStr);
                return;
            }
            FilterType valType = FilterType.fromClass(node.value);
            Object nodeValue = node.value;
            if (valType == FilterType.Invalid) {
                this.filterBuffer.setError("Filter pushdown not supported for value " + node.value.getClass());
                return;
            }
            if (colType == FilterType.Date && valType == FilterType.String) {
                try {
                    nodeValue = new Date(HiveMetaStore.PARTITION_DATE_FORMAT.get().parse((String)nodeValue).getTime());
                    valType = FilterType.Date;
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            if (colType != valType) {
                this.filterBuffer.setError("Cannot push down filter for " + colTypeStr + " column and value " + nodeValue.getClass());
                return;
            }
            if (this.joins.isEmpty()) {
                for (int i = 0; i < partColCount; ++i) {
                    this.joins.add(null);
                }
            }
            if (this.joins.get(partColIndex) == null) {
                this.joins.set(partColIndex, "inner join \"PARTITION_KEY_VALS\" \"FILTER" + partColIndex + "\" on \"FILTER" + partColIndex + "\".\"PART_ID\" = \"PARTITIONS\".\"PART_ID\"" + " and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex);
            }
            String tableValue = "\"FILTER" + partColIndex + "\".\"PART_KEY_VAL\"";
            if (node.isReverseOrder) {
                this.params.add(nodeValue);
            }
            String tableColumn = tableValue;
            if (colType != FilterType.String) {
                if (colType == FilterType.Integral) {
                    tableValue = "cast(" + tableValue + " as decimal(21,0))";
                } else if (colType == FilterType.Date) {
                    tableValue = "cast(" + tableValue + " as date)";
                }
                String tableValue0 = tableValue;
                tableValue = "(case when " + tableColumn + " <> ?";
                this.params.add(this.defaultPartName);
                if (this.dbHasJoinCastBug) {
                    tableValue = tableValue + " and \"TBLS\".\"TBL_NAME\" = ? and \"DBS\".\"NAME\" = ? and \"FILTER" + partColIndex + "\".\"PART_ID\" = \"PARTITIONS\".\"PART_ID\" and " + "\"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex;
                    this.params.add(this.table.getTableName().toLowerCase());
                    this.params.add(this.table.getDbName().toLowerCase());
                }
                tableValue = tableValue + " then " + tableValue0 + " else null end)";
            }
            if (!node.isReverseOrder) {
                this.params.add(nodeValue);
            }
            this.filterBuffer.append(node.isReverseOrder ? "(? " + node.operator.getSqlOp() + " " + tableValue + ")" : "(" + tableValue + " " + node.operator.getSqlOp() + " ?)");
        }

        private static enum FilterType {
            Integral,
            String,
            Date,
            Invalid;


            static FilterType fromType(String colTypeStr) {
                if (colTypeStr.equals("string")) {
                    return String;
                }
                if (colTypeStr.equals("date")) {
                    return Date;
                }
                if (serdeConstants.IntegralTypes.contains(colTypeStr)) {
                    return Integral;
                }
                return Invalid;
            }

            public static FilterType fromClass(Object value) {
                if (value instanceof String) {
                    return String;
                }
                if (value instanceof Long) {
                    return Integral;
                }
                if (value instanceof Date) {
                    return Date;
                }
                return Invalid;
            }
        }
    }

    private abstract class ApplyFunc<Target> {
        private ApplyFunc() {
        }

        public abstract void apply(Target var1, Object[] var2) throws MetaException;
    }

    private static enum DB {
        MYSQL,
        ORACLE,
        MSSQL,
        DERBY,
        OTHER;

    }
}

