/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.common.util.HiveStringUtils;

public class HiveAlterHandler
implements AlterHandler {
    protected Configuration hiveConf;
    private static final Log LOG = LogFactory.getLog((String)HiveAlterHandler.class.getName());

    public Configuration getConf() {
        return this.hiveConf;
    }

    public void setConf(Configuration conf) {
        this.hiveConf = conf;
    }

    @Override
    public void alterTable(RawStore msdb, Warehouse wh, String dbname, String name, Table newt) throws InvalidOperationException, MetaException {
        this.alterTable(msdb, wh, dbname, name, newt, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void alterTable(RawStore msdb, Warehouse wh, String dbname, String name, Table newt, boolean cascade) throws InvalidOperationException, MetaException {
        boolean success;
        block45: {
            if (newt == null) {
                throw new InvalidOperationException("New table is invalid: " + newt);
            }
            if (!MetaStoreUtils.validateName(newt.getTableName())) {
                throw new InvalidOperationException(newt.getTableName() + " is not a valid object name");
            }
            String validate = MetaStoreUtils.validateTblColumns(newt.getSd().getCols());
            if (validate != null) {
                throw new InvalidOperationException("Invalid column " + validate);
            }
            Path srcPath = null;
            FileSystem srcFs = null;
            Path destPath = null;
            FileSystem destFs = null;
            success = false;
            boolean moveData = false;
            boolean rename = false;
            Table oldt = null;
            ArrayList<ObjectPair> altps = new ArrayList<ObjectPair>();
            try {
                msdb.openTransaction();
                name = name.toLowerCase();
                dbname = dbname.toLowerCase();
                if (!newt.getTableName().equalsIgnoreCase(name) || !newt.getDbName().equalsIgnoreCase(dbname)) {
                    if (msdb.getTable(newt.getDbName(), newt.getTableName()) != null) {
                        throw new InvalidOperationException("new table " + newt.getDbName() + "." + newt.getTableName() + " already exists");
                    }
                    rename = true;
                }
                if ((oldt = msdb.getTable(dbname, name)) == null) {
                    throw new InvalidOperationException("table " + newt.getDbName() + "." + newt.getTableName() + " doesn't exist");
                }
                if (HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES, (boolean)false)) {
                    MetaStoreUtils.throwExceptionIfIncompatibleColTypeChange(oldt.getSd().getCols(), newt.getSd().getCols());
                }
                if (cascade) {
                    if (MetaStoreUtils.isCascadeNeededInAlterTable(oldt, newt)) {
                        List<Partition> parts = msdb.getPartitions(dbname, name, -1);
                        for (Partition part : parts) {
                            List<FieldSchema> oldCols = part.getSd().getCols();
                            part.getSd().setCols(newt.getSd().getCols());
                            String oldPartName = Warehouse.makePartName(oldt.getPartitionKeys(), part.getValues());
                            this.updatePartColumnStatsForAlterColumns(msdb, part, oldPartName, part.getValues(), oldCols, part);
                            msdb.alterPartition(dbname, name, part.getValues(), part);
                        }
                    } else {
                        LOG.warn((Object)"Alter table does not cascade changes to its partitions.");
                    }
                }
                boolean partKeysPartiallyEqual = this.checkPartialPartKeysEqual(oldt.getPartitionKeys(), newt.getPartitionKeys());
                if (!oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) {
                    if (oldt.getPartitionKeys().size() != newt.getPartitionKeys().size()) throw new InvalidOperationException("partition keys can not be changed.");
                    if (!partKeysPartiallyEqual) {
                        throw new InvalidOperationException("partition keys can not be changed.");
                    }
                }
                if (rename && !oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) && (oldt.getSd().getLocation().compareTo(newt.getSd().getLocation()) == 0 || StringUtils.isEmpty((String)newt.getSd().getLocation())) && !MetaStoreUtils.isExternalTable(oldt)) {
                    srcPath = new Path(oldt.getSd().getLocation());
                    srcFs = wh.getFs(srcPath);
                    Path databasePath = this.constructRenamedPath(wh.getDefaultDatabasePath(newt.getDbName()), srcPath);
                    destPath = new Path(databasePath, newt.getTableName());
                    destFs = wh.getFs(destPath);
                    newt.getSd().setLocation(destPath.toString());
                    moveData = true;
                    if (!FileUtils.equalsFileSystem((FileSystem)srcFs, (FileSystem)destFs)) {
                        throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
                    }
                    try {
                        srcFs.exists(srcPath);
                        if (destFs.exists(destPath)) {
                            throw new InvalidOperationException("New location for this table " + newt.getDbName() + "." + newt.getTableName() + " already exists : " + destPath);
                        }
                    }
                    catch (IOException e) {
                        Warehouse.closeFs(srcFs);
                        Warehouse.closeFs(destFs);
                        throw new InvalidOperationException("Unable to access new location " + destPath + " for table " + newt.getDbName() + "." + newt.getTableName());
                    }
                    String oldTblLocPath = srcPath.toUri().getPath();
                    String newTblLocPath = destPath.toUri().getPath();
                    List<Partition> parts = msdb.getPartitions(dbname, name, -1);
                    for (Partition part : parts) {
                        String oldPartLoc = part.getSd().getLocation();
                        if (!oldPartLoc.contains(oldTblLocPath)) continue;
                        URI oldUri = new Path(oldPartLoc).toUri();
                        String newPath = oldUri.getPath().replace(oldTblLocPath, newTblLocPath);
                        Path newPartLocPath = new Path(oldUri.getScheme(), oldUri.getAuthority(), newPath);
                        altps.add(ObjectPair.create((Object)part, (Object)part.getSd().getLocation()));
                        part.getSd().setLocation(newPartLocPath.toString());
                        String oldPartName = Warehouse.makePartName(oldt.getPartitionKeys(), part.getValues());
                        try {
                            msdb.deletePartitionColumnStatistics(dbname, name, oldPartName, part.getValues(), null);
                        }
                        catch (InvalidInputException iie) {
                            throw new InvalidOperationException("Unable to update partition stats in table rename." + iie);
                        }
                        msdb.alterPartition(dbname, name, part.getValues(), part);
                    }
                } else if (MetaStoreUtils.requireCalStats(this.hiveConf, null, null, newt) && newt.getPartitionKeysSize() == 0) {
                    Database db = msdb.getDatabase(newt.getDbName());
                    MetaStoreUtils.updateUnpartitionedTableStatsFast(db, newt, wh, false, true);
                }
                this.updateTableColumnStatsForAlterTable(msdb, oldt, newt);
                msdb.alterTable(dbname, name, newt);
                success = msdb.commitTransaction();
                if (!success) {
                    msdb.rollbackTransaction();
                }
                if (!success || !moveData) break block45;
            }
            catch (InvalidObjectException e) {
                try {
                    LOG.debug((Object)e);
                    throw new InvalidOperationException("Unable to change partition or table. Check metastore logs for detailed stack." + e.getMessage());
                    catch (NoSuchObjectException e2) {
                        LOG.debug((Object)e2);
                        throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist" + " Check metastore logs for detailed stack." + e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (!success) {
                        msdb.rollbackTransaction();
                    }
                    if (!success) throw throwable;
                    if (!moveData) throw throwable;
                    try {
                        if (!srcFs.exists(srcPath)) throw throwable;
                        if (srcFs.rename(srcPath, destPath)) throw throwable;
                        throw new IOException("Renaming " + srcPath + " to " + destPath + " is failed");
                    }
                    catch (IOException e3) {
                        boolean revertMetaDataTransaction = false;
                        try {
                            msdb.openTransaction();
                            msdb.alterTable(dbname, newt.getTableName(), oldt);
                            Iterator i$ = altps.iterator();
                            while (true) {
                                if (!i$.hasNext()) {
                                    revertMetaDataTransaction = msdb.commitTransaction();
                                    throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                                }
                                ObjectPair pair = (ObjectPair)i$.next();
                                Partition part = (Partition)pair.getFirst();
                                part.getSd().setLocation((String)pair.getSecond());
                                msdb.alterPartition(dbname, name, part.getValues(), part);
                            }
                        }
                        catch (Exception e1) {
                            LOG.error((Object)"Reverting metadata by HDFS operation failure failed During HDFS operation failed", (Throwable)e1);
                            LOG.error((Object)("Table " + Warehouse.getQualifiedName(newt) + " should be renamed to " + Warehouse.getQualifiedName(oldt)));
                            LOG.error((Object)("Table " + Warehouse.getQualifiedName(newt) + " should have path " + srcPath));
                            for (ObjectPair pair : altps) {
                                LOG.error((Object)("Partition " + Warehouse.getQualifiedName((Partition)pair.getFirst()) + " should have path " + (String)pair.getSecond()));
                            }
                            if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                            msdb.rollbackTransaction();
                        }
                        throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                    }
                }
            }
            try {
                if (srcFs.exists(srcPath) && !srcFs.rename(srcPath, destPath)) {
                    throw new IOException("Renaming " + srcPath + " to " + destPath + " is failed");
                }
            }
            catch (IOException e) {
                boolean revertMetaDataTransaction = false;
                try {
                    msdb.openTransaction();
                    msdb.alterTable(dbname, newt.getTableName(), oldt);
                    Iterator i$ = altps.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            revertMetaDataTransaction = msdb.commitTransaction();
                            throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                        }
                        ObjectPair pair = (ObjectPair)i$.next();
                        Partition part = (Partition)pair.getFirst();
                        part.getSd().setLocation((String)pair.getSecond());
                        msdb.alterPartition(dbname, name, part.getValues(), part);
                    }
                }
                catch (Exception e1) {
                    LOG.error((Object)"Reverting metadata by HDFS operation failure failed During HDFS operation failed", (Throwable)e1);
                    LOG.error((Object)("Table " + Warehouse.getQualifiedName(newt) + " should be renamed to " + Warehouse.getQualifiedName(oldt)));
                    LOG.error((Object)("Table " + Warehouse.getQualifiedName(newt) + " should have path " + srcPath));
                    for (ObjectPair pair : altps) {
                        LOG.error((Object)("Partition " + Warehouse.getQualifiedName((Partition)pair.getFirst()) + " should have path " + (String)pair.getSecond()));
                    }
                    if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                    msdb.rollbackTransaction();
                }
                throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
            }
        }
        if (success) return;
        throw new MetaException("Committing the alter table transaction was not successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Partition alterPartition(RawStore msdb, Warehouse wh, String dbname, String name, List<String> part_vals, Partition new_part) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        boolean success = false;
        Path srcPath = null;
        Path destPath = null;
        FileSystem srcFs = null;
        FileSystem destFs = null;
        Partition oldPart = null;
        String oldPartLoc = null;
        String newPartLoc = null;
        if (new_part.getParameters() == null || new_part.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(new_part.getParameters().get("transient_lastDdlTime")) == 0) {
            new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
        }
        Table tbl = msdb.getTable(dbname, name);
        if (part_vals == null || part_vals.size() == 0) {
            try {
                oldPart = msdb.getPartition(dbname, name, new_part.getValues());
                if (MetaStoreUtils.requireCalStats(this.hiveConf, oldPart, new_part, tbl)) {
                    MetaStoreUtils.updatePartitionStatsFast(new_part, wh, false, true);
                }
                this.updatePartColumnStats(msdb, dbname, name, new_part.getValues(), new_part);
                msdb.alterPartition(dbname, name, new_part.getValues(), new_part);
                return oldPart;
            }
            catch (InvalidObjectException e) {
                throw new InvalidOperationException("alter is not possible");
            }
            catch (NoSuchObjectException e) {
                throw new InvalidOperationException("alter is not possible");
            }
        }
        try {
            String oldPartName;
            msdb.openTransaction();
            try {
                oldPart = msdb.getPartition(dbname, name, part_vals);
            }
            catch (NoSuchObjectException e) {
                throw new InvalidObjectException("Unable to rename partition because old partition does not exist");
            }
            Partition check_part = null;
            try {
                check_part = msdb.getPartition(dbname, name, new_part.getValues());
            }
            catch (NoSuchObjectException e) {
                check_part = null;
            }
            if (check_part != null) {
                throw new AlreadyExistsException("Partition already exists:" + dbname + "." + name + "." + new_part.getValues());
            }
            if (tbl == null) {
                throw new InvalidObjectException("Unable to rename partition because table or database do not exist");
            }
            if (tbl.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                new_part.getSd().setLocation(oldPart.getSd().getLocation());
                oldPartName = Warehouse.makePartName(tbl.getPartitionKeys(), oldPart.getValues());
                try {
                    msdb.deletePartitionColumnStatistics(dbname, name, oldPartName, oldPart.getValues(), null);
                }
                catch (NoSuchObjectException nsoe) {
                }
                catch (InvalidInputException iie) {
                    throw new InvalidOperationException("Unable to update partition stats in table rename." + iie);
                }
                msdb.alterPartition(dbname, name, part_vals, new_part);
            } else {
                try {
                    destPath = new Path(wh.getTablePath(msdb.getDatabase(dbname), name), Warehouse.makePartName(tbl.getPartitionKeys(), new_part.getValues()));
                    destPath = this.constructRenamedPath(destPath, new Path(new_part.getSd().getLocation()));
                }
                catch (NoSuchObjectException e) {
                    LOG.debug((Object)e);
                    throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist" + " Check metastore logs for detailed stack." + e.getMessage());
                }
                if (destPath != null) {
                    newPartLoc = destPath.toString();
                    oldPartLoc = oldPart.getSd().getLocation();
                    srcPath = new Path(oldPartLoc);
                    LOG.info((Object)("srcPath:" + oldPartLoc));
                    LOG.info((Object)("descPath:" + newPartLoc));
                    srcFs = wh.getFs(srcPath);
                    destFs = wh.getFs(destPath);
                    if (!FileUtils.equalsFileSystem((FileSystem)srcFs, (FileSystem)destFs)) {
                        throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
                    }
                    try {
                        srcFs.exists(srcPath);
                        if (newPartLoc.compareTo(oldPartLoc) != 0 && destFs.exists(destPath)) {
                            throw new InvalidOperationException("New location for this table " + tbl.getDbName() + "." + tbl.getTableName() + " already exists : " + destPath);
                        }
                    }
                    catch (IOException e) {
                        Warehouse.closeFs(srcFs);
                        Warehouse.closeFs(destFs);
                        throw new InvalidOperationException("Unable to access new location " + destPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + new_part.getValues());
                    }
                    new_part.getSd().setLocation(newPartLoc);
                    if (MetaStoreUtils.requireCalStats(this.hiveConf, oldPart, new_part, tbl)) {
                        MetaStoreUtils.updatePartitionStatsFast(new_part, wh, false, true);
                    }
                    oldPartName = Warehouse.makePartName(tbl.getPartitionKeys(), oldPart.getValues());
                    try {
                        msdb.deletePartitionColumnStatistics(dbname, name, oldPartName, oldPart.getValues(), null);
                    }
                    catch (NoSuchObjectException nsoe) {
                    }
                    catch (InvalidInputException iie) {
                        throw new InvalidOperationException("Unable to update partition stats in table rename." + iie);
                    }
                    msdb.alterPartition(dbname, name, part_vals, new_part);
                }
            }
            success = msdb.commitTransaction();
            if (!success) {
                msdb.rollbackTransaction();
            }
            if (!success || newPartLoc == null || newPartLoc.compareTo(oldPartLoc) == 0) return oldPart;
        }
        catch (Throwable throwable) {
            if (!success) {
                msdb.rollbackTransaction();
            }
            if (!success || newPartLoc == null || newPartLoc.compareTo(oldPartLoc) == 0) throw throwable;
            try {
                if (!srcFs.exists(srcPath)) throw throwable;
                Path destParentPath = destPath.getParent();
                if (!wh.mkdirs(destParentPath, true)) {
                    throw new IOException("Unable to create path " + destParentPath);
                }
                wh.renameDir(srcPath, destPath, true);
                LOG.info((Object)"rename done!");
                throw throwable;
            }
            catch (IOException e) {
                boolean revertMetaDataTransaction = false;
                try {
                    msdb.openTransaction();
                    msdb.alterPartition(dbname, name, new_part.getValues(), oldPart);
                    revertMetaDataTransaction = msdb.commitTransaction();
                    throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                }
                catch (Exception e1) {
                    LOG.error((Object)"Reverting metadata opeation failed During HDFS operation failed", (Throwable)e1);
                    if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                    msdb.rollbackTransaction();
                }
                throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
            }
        }
        try {
            if (!srcFs.exists(srcPath)) return oldPart;
            Path destParentPath = destPath.getParent();
            if (!wh.mkdirs(destParentPath, true)) {
                throw new IOException("Unable to create path " + destParentPath);
            }
            wh.renameDir(srcPath, destPath, true);
            LOG.info((Object)"rename done!");
            return oldPart;
        }
        catch (IOException e) {
            boolean revertMetaDataTransaction = false;
            try {
                msdb.openTransaction();
                msdb.alterPartition(dbname, name, new_part.getValues(), oldPart);
                revertMetaDataTransaction = msdb.commitTransaction();
                throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
            }
            catch (Exception e1) {
                LOG.error((Object)"Reverting metadata opeation failed During HDFS operation failed", (Throwable)e1);
                if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                msdb.rollbackTransaction();
            }
            throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
        }
    }

    @Override
    public List<Partition> alterPartitions(RawStore msdb, Warehouse wh, String dbname, String name, List<Partition> new_parts) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        ArrayList<Partition> oldParts = new ArrayList<Partition>();
        ArrayList<List<String>> partValsList = new ArrayList<List<String>>();
        Table tbl = msdb.getTable(dbname, name);
        try {
            for (Partition tmpPart : new_parts) {
                if (tmpPart.getParameters() == null || tmpPart.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(tmpPart.getParameters().get("transient_lastDdlTime")) == 0) {
                    tmpPart.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                }
                Partition oldTmpPart = msdb.getPartition(dbname, name, tmpPart.getValues());
                oldParts.add(oldTmpPart);
                partValsList.add(tmpPart.getValues());
                if (MetaStoreUtils.requireCalStats(this.hiveConf, oldTmpPart, tmpPart, tbl)) {
                    MetaStoreUtils.updatePartitionStatsFast(tmpPart, wh, false, true);
                }
                this.updatePartColumnStats(msdb, dbname, name, oldTmpPart.getValues(), tmpPart);
            }
            msdb.alterPartitions(dbname, name, partValsList, new_parts);
        }
        catch (InvalidObjectException e) {
            throw new InvalidOperationException("alter is not possible");
        }
        catch (NoSuchObjectException e) {
            throw new InvalidOperationException("alter is not possible");
        }
        return oldParts;
    }

    private boolean checkPartialPartKeysEqual(List<FieldSchema> oldPartKeys, List<FieldSchema> newPartKeys) {
        if (newPartKeys == null || oldPartKeys == null) {
            return oldPartKeys == newPartKeys;
        }
        if (oldPartKeys.size() != newPartKeys.size()) {
            return false;
        }
        Iterator<FieldSchema> oldPartKeysIter = oldPartKeys.iterator();
        Iterator<FieldSchema> newPartKeysIter = newPartKeys.iterator();
        while (oldPartKeysIter.hasNext()) {
            FieldSchema oldFs = oldPartKeysIter.next();
            FieldSchema newFs = newPartKeysIter.next();
            if (oldFs.getName().equals(newFs.getName())) continue;
            return false;
        }
        return true;
    }

    private Path constructRenamedPath(Path defaultNewPath, Path currentPath) {
        URI currentUri = currentPath.toUri();
        return new Path(currentUri.getScheme(), currentUri.getAuthority(), defaultNewPath.toUri().getPath());
    }

    private void updatePartColumnStatsForAlterColumns(RawStore msdb, Partition oldPartition, String oldPartName, List<String> partVals, List<FieldSchema> oldCols, Partition newPart) throws MetaException, InvalidObjectException {
        String dbName = oldPartition.getDbName();
        String tableName = oldPartition.getTableName();
        try {
            ArrayList oldPartNames = Lists.newArrayList((Object[])new String[]{oldPartName});
            ArrayList<String> oldColNames = new ArrayList<String>(oldCols.size());
            for (FieldSchema oldCol : oldCols) {
                oldColNames.add(oldCol.getName());
            }
            List<FieldSchema> newCols = newPart.getSd().getCols();
            List<ColumnStatistics> partsColStats = msdb.getPartitionColumnStatistics(dbName, tableName, oldPartNames, oldColNames);
            assert (partsColStats.size() <= 1);
            for (ColumnStatistics partColStats : partsColStats) {
                List<ColumnStatisticsObj> statsObjs = partColStats.getStatsObj();
                for (ColumnStatisticsObj statsObj : statsObjs) {
                    boolean found = false;
                    for (FieldSchema newCol : newCols) {
                        if (!statsObj.getColName().equals(newCol.getName()) || !statsObj.getColType().equals(newCol.getType())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    msdb.deletePartitionColumnStatistics(dbName, tableName, oldPartName, partVals, statsObj.getColName());
                }
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug((Object)("Could not find db entry." + nsoe));
        }
        catch (InvalidInputException iie) {
            throw new InvalidObjectException("Invalid input to update partition column stats in alter table change columns" + iie);
        }
    }

    private void updatePartColumnStats(RawStore msdb, String dbName, String tableName, List<String> partVals, Partition newPart) throws MetaException, InvalidObjectException {
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        String newDbName = HiveStringUtils.normalizeIdentifier((String)newPart.getDbName());
        String newTableName = HiveStringUtils.normalizeIdentifier((String)newPart.getTableName());
        Table oldTable = msdb.getTable(dbName, tableName);
        if (oldTable == null) {
            return;
        }
        try {
            String oldPartName = Warehouse.makePartName(oldTable.getPartitionKeys(), partVals);
            String newPartName = Warehouse.makePartName(oldTable.getPartitionKeys(), newPart.getValues());
            if (!(dbName.equals(newDbName) && tableName.equals(newTableName) && oldPartName.equals(newPartName))) {
                msdb.deletePartitionColumnStatistics(dbName, tableName, oldPartName, partVals, null);
            } else {
                List<FieldSchema> oldCols;
                Partition oldPartition = msdb.getPartition(dbName, tableName, partVals);
                if (oldPartition == null) {
                    return;
                }
                if (oldPartition.getSd() != null && newPart.getSd() != null && !MetaStoreUtils.areSameColumns(oldCols = oldPartition.getSd().getCols(), newPart.getSd().getCols())) {
                    this.updatePartColumnStatsForAlterColumns(msdb, oldPartition, oldPartName, partVals, oldCols, newPart);
                }
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug((Object)("Could not find db entry." + nsoe));
        }
        catch (InvalidInputException iie) {
            throw new InvalidObjectException("Invalid input to update partition column stats." + iie);
        }
    }

    private void updateTableColumnStatsForAlterTable(RawStore msdb, Table oldTable, Table newTable) throws MetaException, InvalidObjectException {
        String dbName = oldTable.getDbName();
        String tableName = oldTable.getTableName();
        String newDbName = HiveStringUtils.normalizeIdentifier((String)newTable.getDbName());
        String newTableName = HiveStringUtils.normalizeIdentifier((String)newTable.getTableName());
        try {
            if (!dbName.equals(newDbName) || !tableName.equals(newTableName)) {
                msdb.deleteTableColumnStatistics(dbName, tableName, null);
            } else {
                List<FieldSchema> newCols;
                List<FieldSchema> oldCols = oldTable.getSd().getCols();
                if (!MetaStoreUtils.areSameColumns(oldCols, newCols = newTable.getSd().getCols())) {
                    ArrayList<String> oldColNames = new ArrayList<String>(oldCols.size());
                    for (FieldSchema oldCol : oldCols) {
                        oldColNames.add(oldCol.getName());
                    }
                    ColumnStatistics cs = msdb.getTableColumnStatistics(dbName, tableName, oldColNames);
                    if (cs == null) {
                        return;
                    }
                    List<ColumnStatisticsObj> statsObjs = cs.getStatsObj();
                    for (ColumnStatisticsObj statsObj : statsObjs) {
                        boolean found = false;
                        for (FieldSchema newCol : newCols) {
                            if (!statsObj.getColName().equalsIgnoreCase(newCol.getName()) || !statsObj.getColType().equals(newCol.getType())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        msdb.deleteTableColumnStatistics(dbName, tableName, statsObj.getColName());
                    }
                }
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug((Object)("Could not find db entry." + nsoe));
        }
        catch (InvalidInputException e) {
            throw new InvalidObjectException("Invalid inputs to update table column stats: " + e);
        }
    }
}

