/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.exec.CommonFunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hive.common.util.AnnotationUtils;

public class WindowFunctionInfo
implements CommonFunctionInfo {
    boolean supportsWindow = true;
    boolean pivotResult = false;
    boolean impliesOrder = false;
    FunctionInfo fInfo;

    WindowFunctionInfo(FunctionInfo fInfo) {
        assert (fInfo.isGenericUDAF());
        this.fInfo = fInfo;
        Class<?> wfnCls = fInfo.getGenericUDAFResolver().getClass();
        WindowFunctionDescription def = AnnotationUtils.getAnnotation(wfnCls, WindowFunctionDescription.class);
        if (def != null) {
            this.supportsWindow = def.supportsWindow();
            this.pivotResult = def.pivotResult();
            this.impliesOrder = def.impliesOrder();
        }
    }

    public boolean isSupportsWindow() {
        return this.supportsWindow;
    }

    public boolean isPivotResult() {
        return this.pivotResult;
    }

    public boolean isImpliesOrder() {
        return this.impliesOrder;
    }

    public FunctionInfo getfInfo() {
        return this.fInfo;
    }

    @Override
    public Class<?> getFunctionClass() {
        return this.getfInfo().getFunctionClass();
    }
}

