/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.WALLink;
import org.apache.hadoop.hbase.io.hadoopbackport.ThrottledInputStream;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ExportSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ExportSnapshot
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ExportSnapshot.class);
    private static final String MR_NUM_MAPS = "mapreduce.job.maps";
    private static final String CONF_NUM_SPLITS = "snapshot.export.format.splits";
    private static final String CONF_SNAPSHOT_NAME = "snapshot.export.format.snapshot.name";
    private static final String CONF_SNAPSHOT_DIR = "snapshot.export.format.snapshot.dir";
    private static final String CONF_FILES_USER = "snapshot.export.files.attributes.user";
    private static final String CONF_FILES_GROUP = "snapshot.export.files.attributes.group";
    private static final String CONF_FILES_MODE = "snapshot.export.files.attributes.mode";
    private static final String CONF_CHECKSUM_VERIFY = "snapshot.export.checksum.verify";
    private static final String CONF_OUTPUT_ROOT = "snapshot.export.output.root";
    private static final String CONF_INPUT_ROOT = "snapshot.export.input.root";
    private static final String CONF_BUFFER_SIZE = "snapshot.export.buffer.size";
    private static final String CONF_MAP_GROUP = "snapshot.export.default.map.group";
    private static final String CONF_BANDWIDTH_MB = "snapshot.export.map.bandwidth.mb";
    protected static final String CONF_SKIP_TMP = "snapshot.export.skip.tmp";
    static final String CONF_TEST_FAILURE = "test.snapshot.export.failure";
    static final String CONF_TEST_RETRY = "test.snapshot.export.failure.retry";
    private static final String INPUT_FOLDER_PREFIX = "export-files.";

    private static List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> getSnapshotFiles(final Configuration conf, final FileSystem fs, Path snapshotDir) throws IOException {
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        final ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>> files = new ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>>();
        final TableName table = TableName.valueOf((String)snapshotDesc.getTable());
        LOG.info((Object)("Loading Snapshot '" + snapshotDesc.getName() + "' hfile list"));
        SnapshotReferenceUtil.visitReferencedFiles(conf, fs, snapshotDir, snapshotDesc, new SnapshotReferenceUtil.SnapshotVisitor(){

            @Override
            public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                if (!storeFile.hasReference()) {
                    String region = regionInfo.getEncodedName();
                    String hfile = storeFile.getName();
                    Path path = HFileLink.createPath(table, region, family, hfile);
                    SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile(path.toString()).build();
                    long size = storeFile.hasFileSize() ? storeFile.getFileSize() : HFileLink.buildFromHFileLinkPattern(conf, path).getFileStatus(fs).getLen();
                    files.add(new Pair((Object)fileInfo, (Object)size));
                }
            }

            @Override
            public void logFile(String server, String logfile) throws IOException {
                SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.WAL).setWalServer(server).setWalName(logfile).build();
                long size = new WALLink(conf, server, logfile).getFileStatus(fs).getLen();
                files.add(new Pair((Object)fileInfo, (Object)size));
            }
        });
        return files;
    }

    static List<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> getBalancedSplits(List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> files, int ngroups) {
        Collections.sort(files, new Comparator<Pair<SnapshotProtos.SnapshotFileInfo, Long>>(){

            @Override
            public int compare(Pair<SnapshotProtos.SnapshotFileInfo, Long> a, Pair<SnapshotProtos.SnapshotFileInfo, Long> b) {
                long r = (Long)a.getSecond() - (Long)b.getSecond();
                return r < 0L ? -1 : (r > 0L ? 1 : 0);
            }
        });
        LinkedList<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> fileGroups = new LinkedList<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>>();
        long[] sizeGroups = new long[ngroups];
        int hi = files.size() - 1;
        int lo = 0;
        int dir = 1;
        int g = 0;
        while (hi >= lo) {
            List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> group;
            if (g == fileGroups.size()) {
                group = new LinkedList();
                fileGroups.add(group);
            } else {
                group = (List)fileGroups.get(g);
            }
            Pair<SnapshotProtos.SnapshotFileInfo, Long> fileInfo = files.get(hi--);
            int n = g;
            sizeGroups[n] = sizeGroups[n] + (Long)fileInfo.getSecond();
            group.add(fileInfo);
            if ((g += dir) == ngroups) {
                dir = -1;
                g = ngroups - 1;
                continue;
            }
            if (g >= 0) continue;
            dir = 1;
            g = 0;
        }
        if (LOG.isDebugEnabled()) {
            for (int i = 0; i < sizeGroups.length; ++i) {
                LOG.debug((Object)("export split=" + i + " size=" + StringUtils.humanReadableInt((long)sizeGroups[i])));
            }
        }
        return fileGroups;
    }

    private void runCopyJob(Path inputRoot, Path outputRoot, String snapshotName, Path snapshotDir, boolean verifyChecksum, String filesUser, String filesGroup, int filesMode, int mappers, int bandwidthMB) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = this.getConf();
        if (filesGroup != null) {
            conf.set(CONF_FILES_GROUP, filesGroup);
        }
        if (filesUser != null) {
            conf.set(CONF_FILES_USER, filesUser);
        }
        if (mappers > 0) {
            conf.setInt(CONF_NUM_SPLITS, mappers);
            conf.setInt(MR_NUM_MAPS, mappers);
        }
        conf.setInt(CONF_FILES_MODE, filesMode);
        conf.setBoolean(CONF_CHECKSUM_VERIFY, verifyChecksum);
        conf.set(CONF_OUTPUT_ROOT, outputRoot.toString());
        conf.set(CONF_INPUT_ROOT, inputRoot.toString());
        conf.setInt(CONF_BANDWIDTH_MB, bandwidthMB);
        conf.set(CONF_SNAPSHOT_NAME, snapshotName);
        conf.set(CONF_SNAPSHOT_DIR, snapshotDir.toString());
        Job job = new Job(conf);
        job.setJobName("ExportSnapshot-" + snapshotName);
        job.setJarByClass(ExportSnapshot.class);
        TableMapReduceUtil.addDependencyJars(job);
        job.setMapperClass(ExportMapper.class);
        job.setInputFormatClass(ExportSnapshotInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapSpeculativeExecution(false);
        job.setNumReduceTasks(0);
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])new Path[]{inputRoot, outputRoot}, (Configuration)conf);
        if (!job.waitForCompletion(true)) {
            throw new ExportSnapshotException("Copy Files Map-Reduce Job failed");
        }
    }

    private void verifySnapshot(Configuration baseConf, FileSystem fs, Path rootDir, Path snapshotDir) throws IOException {
        Configuration conf = new Configuration(baseConf);
        FSUtils.setRootDir(conf, rootDir);
        FSUtils.setFsDefault(conf, FSUtils.getRootDir(conf));
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        SnapshotReferenceUtil.verifySnapshot(conf, fs, snapshotDir, snapshotDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws IOException {
        Path initialOutputSnapshotDir;
        boolean verifyTarget = true;
        boolean verifyChecksum = true;
        String snapshotName = null;
        String targetName = null;
        boolean overwrite = false;
        String filesGroup = null;
        String filesUser = null;
        Path outputRoot = null;
        int bandwidthMB = Integer.MAX_VALUE;
        int filesMode = 0;
        int mappers = 0;
        Configuration conf = this.getConf();
        Path inputRoot = FSUtils.getRootDir(conf);
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equals("-snapshot")) {
                snapshotName = args[++i];
                continue;
            }
            if (cmd.equals("-target")) {
                targetName = args[++i];
                continue;
            }
            if (cmd.equals("-copy-to")) {
                outputRoot = new Path(args[++i]);
                continue;
            }
            if (cmd.equals("-copy-from")) {
                inputRoot = new Path(args[++i]);
                FSUtils.setRootDir(conf, inputRoot);
                continue;
            }
            if (cmd.equals("-no-checksum-verify")) {
                verifyChecksum = false;
                continue;
            }
            if (cmd.equals("-no-target-verify")) {
                verifyTarget = false;
                continue;
            }
            if (cmd.equals("-mappers")) {
                mappers = Integer.parseInt(args[++i]);
                continue;
            }
            if (cmd.equals("-chuser")) {
                filesUser = args[++i];
                continue;
            }
            if (cmd.equals("-chgroup")) {
                filesGroup = args[++i];
                continue;
            }
            if (cmd.equals("-bandwidth")) {
                bandwidthMB = Integer.parseInt(args[++i]);
                continue;
            }
            if (cmd.equals("-chmod")) {
                filesMode = Integer.parseInt(args[++i], 8);
                continue;
            }
            if (cmd.equals("-overwrite")) {
                overwrite = true;
                continue;
            }
            if (cmd.equals("-h") || cmd.equals("--help")) {
                this.printUsageAndExit();
                continue;
            }
            System.err.println("UNEXPECTED: " + cmd);
            this.printUsageAndExit();
        }
        if (snapshotName == null) {
            System.err.println("Snapshot name not provided.");
            this.printUsageAndExit();
        }
        if (outputRoot == null) {
            System.err.println("Destination file-system not provided.");
            this.printUsageAndExit();
        }
        if (targetName == null) {
            targetName = snapshotName;
        }
        conf.setBoolean("fs." + inputRoot.toUri().getScheme() + ".impl.disable.cache", true);
        FileSystem inputFs = FileSystem.get((URI)inputRoot.toUri(), (Configuration)conf);
        LOG.debug((Object)("inputFs=" + inputFs.getUri().toString() + " inputRoot=" + inputRoot));
        conf.setBoolean("fs." + outputRoot.toUri().getScheme() + ".impl.disable.cache", true);
        FileSystem outputFs = FileSystem.get((URI)outputRoot.toUri(), (Configuration)conf);
        LOG.debug((Object)("outputFs=" + outputFs.getUri().toString() + " outputRoot=" + outputRoot.toString()));
        boolean skipTmp = conf.getBoolean(CONF_SKIP_TMP, false);
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, inputRoot);
        Path snapshotTmpDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(targetName, outputRoot);
        Path outputSnapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(targetName, outputRoot);
        Path path = initialOutputSnapshotDir = skipTmp ? outputSnapshotDir : snapshotTmpDir;
        if (outputFs.exists(outputSnapshotDir)) {
            if (overwrite) {
                if (!outputFs.delete(outputSnapshotDir, true)) {
                    System.err.println("Unable to remove existing snapshot directory: " + outputSnapshotDir);
                    return 1;
                }
            } else {
                System.err.println("The snapshot '" + targetName + "' already exists in the destination: " + outputSnapshotDir);
                return 1;
            }
        }
        if (!skipTmp && outputFs.exists(snapshotTmpDir)) {
            if (overwrite) {
                if (!outputFs.delete(snapshotTmpDir, true)) {
                    System.err.println("Unable to remove existing snapshot tmp directory: " + snapshotTmpDir);
                    return 1;
                }
            } else {
                System.err.println("A snapshot with the same name '" + targetName + "' may be in-progress");
                System.err.println("Please check " + snapshotTmpDir + ". If the snapshot has completed, ");
                System.err.println("consider removing " + snapshotTmpDir + " by using the -overwrite option");
                return 1;
            }
        }
        try {
            LOG.info((Object)"Copy Snapshot Manifest");
            FileUtil.copy((FileSystem)inputFs, (Path)snapshotDir, (FileSystem)outputFs, (Path)initialOutputSnapshotDir, (boolean)false, (boolean)false, (Configuration)conf);
        }
        catch (IOException e) {
            throw new ExportSnapshotException("Failed to copy the snapshot directory: from=" + snapshotDir + " to=" + initialOutputSnapshotDir, (Exception)e);
        }
        if (!targetName.equals(snapshotName)) {
            HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(inputFs, snapshotDir).toBuilder().setName(targetName).build();
            SnapshotDescriptionUtils.writeSnapshotInfo(snapshotDesc, snapshotTmpDir, outputFs);
        }
        try {
            this.runCopyJob(inputRoot, outputRoot, snapshotName, snapshotDir, verifyChecksum, filesUser, filesGroup, filesMode, mappers, bandwidthMB);
            LOG.info((Object)"Finalize the Snapshot Export");
            if (!skipTmp && !outputFs.rename(snapshotTmpDir, outputSnapshotDir)) {
                throw new ExportSnapshotException("Unable to rename snapshot directory from=" + snapshotTmpDir + " to=" + outputSnapshotDir);
            }
            if (verifyTarget) {
                LOG.info((Object)"Verify snapshot integrity");
                this.verifySnapshot(conf, outputFs, outputRoot, outputSnapshotDir);
            }
            LOG.info((Object)("Export Completed: " + targetName));
            int snapshotDesc = 0;
            return snapshotDesc;
        }
        catch (Exception e) {
            LOG.error((Object)"Snapshot export failed", (Throwable)e);
            if (!skipTmp) {
                outputFs.delete(snapshotTmpDir, true);
            }
            outputFs.delete(outputSnapshotDir, true);
            int n = 1;
            return n;
        }
        finally {
            IOUtils.closeStream((Closeable)inputFs);
            IOUtils.closeStream((Closeable)outputFs);
        }
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [options]%n", ((Object)((Object)this)).getClass().getName());
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help                Show this help and exit.");
        System.err.println("  -snapshot NAME          Snapshot to restore.");
        System.err.println("  -copy-to NAME           Remote destination hdfs://");
        System.err.println("  -copy-from NAME         Input folder hdfs:// (default hbase.rootdir)");
        System.err.println("  -no-checksum-verify     Do not verify checksum, use name+length only.");
        System.err.println("  -no-target-verify       Do not verify the integrity of the \\exported snapshot.");
        System.err.println("  -overwrite              Rewrite the snapshot manifest if already exists");
        System.err.println("  -chuser USERNAME        Change the owner of the files to the specified one.");
        System.err.println("  -chgroup GROUP          Change the group of the files to the specified one.");
        System.err.println("  -chmod MODE             Change the permission of the files to the specified one.");
        System.err.println("  -mappers                Number of mappers to use during the copy (mapreduce.job.maps).");
        System.err.println("  -bandwidth              Limit bandwidth to this value in MB/second.");
        System.err.println();
        System.err.println("Examples:");
        System.err.println("  hbase " + ((Object)((Object)this)).getClass().getName() + " \\");
        System.err.println("    -snapshot MySnapshot -copy-to hdfs://srv2:8082/hbase \\");
        System.err.println("    -chuser MyUser -chgroup MyGroup -chmod 700 -mappers 16");
        System.err.println();
        System.err.println("  hbase " + ((Object)((Object)this)).getClass().getName() + " \\");
        System.err.println("    -snapshot MySnapshot -copy-from hdfs://srv2:8082/hbase \\");
        System.err.println("    -copy-to hdfs://srv1:50070/hbase \\");
        System.exit(1);
    }

    static int innerMain(Configuration conf, String[] args) throws Exception {
        return ToolRunner.run((Configuration)conf, (Tool)new ExportSnapshot(), (String[])args);
    }

    public static void main(String[] args) throws Exception {
        System.exit(ExportSnapshot.innerMain(HBaseConfiguration.create(), args));
    }

    private static class ExportSnapshotInputFormat
    extends InputFormat<BytesWritable, NullWritable> {
        private ExportSnapshotInputFormat() {
        }

        public RecordReader<BytesWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext tac) throws IOException, InterruptedException {
            return new ExportSnapshotRecordReader(((ExportSnapshotInputSplit)split).getSplitKeys());
        }

        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            String snapshotName = conf.get(ExportSnapshot.CONF_SNAPSHOT_NAME);
            Path snapshotDir = new Path(conf.get(ExportSnapshot.CONF_SNAPSHOT_DIR));
            FileSystem fs = FileSystem.get((URI)snapshotDir.toUri(), (Configuration)conf);
            List snapshotFiles = ExportSnapshot.getSnapshotFiles(conf, fs, snapshotDir);
            int mappers = conf.getInt(ExportSnapshot.CONF_NUM_SPLITS, 0);
            if (mappers == 0 && snapshotFiles.size() > 0) {
                mappers = 1 + snapshotFiles.size() / conf.getInt(ExportSnapshot.CONF_MAP_GROUP, 10);
                mappers = Math.min(mappers, snapshotFiles.size());
                conf.setInt(ExportSnapshot.CONF_NUM_SPLITS, mappers);
                conf.setInt(ExportSnapshot.MR_NUM_MAPS, mappers);
            }
            List<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> groups = ExportSnapshot.getBalancedSplits(snapshotFiles, mappers);
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(groups.size());
            for (List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> files : groups) {
                splits.add(new ExportSnapshotInputSplit(files));
            }
            return splits;
        }

        private static class ExportSnapshotRecordReader
        extends RecordReader<BytesWritable, NullWritable> {
            private final List<Pair<BytesWritable, Long>> files;
            private long totalSize = 0L;
            private long procSize = 0L;
            private int index = -1;

            ExportSnapshotRecordReader(List<Pair<BytesWritable, Long>> files) {
                this.files = files;
                for (Pair<BytesWritable, Long> fileInfo : files) {
                    this.totalSize += ((Long)fileInfo.getSecond()).longValue();
                }
            }

            public void close() {
            }

            public BytesWritable getCurrentKey() {
                return (BytesWritable)this.files.get(this.index).getFirst();
            }

            public NullWritable getCurrentValue() {
                return NullWritable.get();
            }

            public float getProgress() {
                return (float)this.procSize / (float)this.totalSize;
            }

            public void initialize(InputSplit split, TaskAttemptContext tac) {
            }

            public boolean nextKeyValue() {
                if (this.index >= 0) {
                    this.procSize += ((Long)this.files.get(this.index).getSecond()).longValue();
                }
                return ++this.index < this.files.size();
            }
        }

        private static class ExportSnapshotInputSplit
        extends InputSplit
        implements Writable {
            private List<Pair<BytesWritable, Long>> files;
            private long length;

            public ExportSnapshotInputSplit() {
                this.files = null;
            }

            public ExportSnapshotInputSplit(List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> snapshotFiles) {
                this.files = new ArrayList<Pair<BytesWritable, Long>>(snapshotFiles.size());
                for (Pair<SnapshotProtos.SnapshotFileInfo, Long> fileInfo : snapshotFiles) {
                    this.files.add((Pair<BytesWritable, Long>)new Pair((Object)new BytesWritable(((SnapshotProtos.SnapshotFileInfo)fileInfo.getFirst()).toByteArray()), fileInfo.getSecond()));
                    this.length += ((Long)fileInfo.getSecond()).longValue();
                }
            }

            private List<Pair<BytesWritable, Long>> getSplitKeys() {
                return this.files;
            }

            public long getLength() throws IOException, InterruptedException {
                return this.length;
            }

            public String[] getLocations() throws IOException, InterruptedException {
                return new String[0];
            }

            public void readFields(DataInput in) throws IOException {
                int count = in.readInt();
                this.files = new ArrayList<Pair<BytesWritable, Long>>(count);
                this.length = 0L;
                for (int i = 0; i < count; ++i) {
                    BytesWritable fileInfo = new BytesWritable();
                    fileInfo.readFields(in);
                    long size = in.readLong();
                    this.files.add((Pair<BytesWritable, Long>)new Pair((Object)fileInfo, (Object)size));
                    this.length += size;
                }
            }

            public void write(DataOutput out) throws IOException {
                out.writeInt(this.files.size());
                for (Pair<BytesWritable, Long> fileInfo : this.files) {
                    ((BytesWritable)fileInfo.getFirst()).write(out);
                    out.writeLong((Long)fileInfo.getSecond());
                }
            }
        }
    }

    private static class ExportMapper
    extends Mapper<BytesWritable, NullWritable, NullWritable, NullWritable> {
        static final int REPORT_SIZE = 0x100000;
        static final int BUFFER_SIZE = 65536;
        private boolean testFailures;
        private Random random;
        private boolean verifyChecksum;
        private String filesGroup;
        private String filesUser;
        private short filesMode;
        private int bufferSize;
        private FileSystem outputFs;
        private Path outputArchive;
        private Path outputRoot;
        private FileSystem inputFs;
        private Path inputArchive;
        private Path inputRoot;

        private ExportMapper() {
        }

        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            this.verifyChecksum = conf.getBoolean(ExportSnapshot.CONF_CHECKSUM_VERIFY, true);
            this.filesGroup = conf.get(ExportSnapshot.CONF_FILES_GROUP);
            this.filesUser = conf.get(ExportSnapshot.CONF_FILES_USER);
            this.filesMode = (short)conf.getInt(ExportSnapshot.CONF_FILES_MODE, 0);
            this.outputRoot = new Path(conf.get(ExportSnapshot.CONF_OUTPUT_ROOT));
            this.inputRoot = new Path(conf.get(ExportSnapshot.CONF_INPUT_ROOT));
            this.inputArchive = new Path(this.inputRoot, "archive");
            this.outputArchive = new Path(this.outputRoot, "archive");
            this.testFailures = conf.getBoolean(ExportSnapshot.CONF_TEST_FAILURE, false);
            try {
                conf.setBoolean("fs." + this.inputRoot.toUri().getScheme() + ".impl.disable.cache", true);
                this.inputFs = FileSystem.get((URI)this.inputRoot.toUri(), (Configuration)conf);
            }
            catch (IOException e) {
                throw new IOException("Could not get the input FileSystem with root=" + this.inputRoot, e);
            }
            try {
                conf.setBoolean("fs." + this.outputRoot.toUri().getScheme() + ".impl.disable.cache", true);
                this.outputFs = FileSystem.get((URI)this.outputRoot.toUri(), (Configuration)conf);
            }
            catch (IOException e) {
                throw new IOException("Could not get the output FileSystem with root=" + this.outputRoot, e);
            }
            int defaultBlockSize = Math.max((int)this.outputFs.getDefaultBlockSize(this.outputRoot), 65536);
            this.bufferSize = conf.getInt(ExportSnapshot.CONF_BUFFER_SIZE, defaultBlockSize);
            LOG.info((Object)("Using bufferSize=" + StringUtils.humanReadableInt((long)this.bufferSize)));
            for (Counter c : Counter.values()) {
                context.getCounter((Enum)c).increment(0L);
            }
        }

        protected void cleanup(Mapper.Context context) {
            IOUtils.closeStream((Closeable)this.inputFs);
            IOUtils.closeStream((Closeable)this.outputFs);
        }

        public void map(BytesWritable key, NullWritable value, Mapper.Context context) throws InterruptedException, IOException {
            SnapshotProtos.SnapshotFileInfo inputInfo = SnapshotProtos.SnapshotFileInfo.parseFrom((byte[])key.copyBytes());
            Path outputPath = this.getOutputPath(inputInfo);
            this.copyFile(context, inputInfo, outputPath);
        }

        private Path getOutputPath(SnapshotProtos.SnapshotFileInfo inputInfo) throws IOException {
            Path path = null;
            switch (inputInfo.getType()) {
                case HFILE: {
                    Path inputPath = new Path(inputInfo.getHfile());
                    String family = inputPath.getParent().getName();
                    TableName table = HFileLink.getReferencedTableName(inputPath.getName());
                    String region = HFileLink.getReferencedRegionName(inputPath.getName());
                    String hfile = HFileLink.getReferencedHFileName(inputPath.getName());
                    path = new Path(FSUtils.getTableDir(new Path("./"), table), new Path(region, new Path(family, hfile)));
                    break;
                }
                case WAL: {
                    Path oldLogsDir = new Path(this.outputRoot, "oldWALs");
                    path = new Path(oldLogsDir, inputInfo.getWalName());
                    break;
                }
                default: {
                    throw new IOException("Invalid File Type: " + inputInfo.getType().toString());
                }
            }
            return new Path(this.outputArchive, path);
        }

        private void injectTestFailure(Mapper.Context context, SnapshotProtos.SnapshotFileInfo inputInfo) throws IOException {
            if (this.testFailures) {
                if (context.getConfiguration().getBoolean(ExportSnapshot.CONF_TEST_RETRY, false)) {
                    if (this.random == null) {
                        this.random = new Random();
                    }
                    if ((double)this.random.nextFloat() < 0.03) {
                        throw new IOException("TEST RETRY FAILURE: Unable to copy input=" + inputInfo + " time=" + System.currentTimeMillis());
                    }
                } else {
                    context.getCounter((Enum)Counter.COPY_FAILED).increment(1L);
                    throw new IOException("TEST FAILURE: Unable to copy input=" + inputInfo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyFile(Mapper.Context context, SnapshotProtos.SnapshotFileInfo inputInfo, Path outputPath) throws IOException {
            FileStatus outputStat;
            this.injectTestFailure(context, inputInfo);
            FileStatus inputStat = this.getSourceFileStatus(context, inputInfo);
            if (this.outputFs.exists(outputPath) && (outputStat = this.outputFs.getFileStatus(outputPath)) != null && this.sameFile(inputStat, outputStat)) {
                LOG.info((Object)("Skip copy " + inputStat.getPath() + " to " + outputPath + ", same file."));
                context.getCounter((Enum)Counter.FILES_SKIPPED).increment(1L);
                context.getCounter((Enum)Counter.BYTES_SKIPPED).increment(inputStat.getLen());
                return;
            }
            FSDataInputStream in = this.openSourceFile(context, inputInfo);
            int bandwidthMB = context.getConfiguration().getInt(ExportSnapshot.CONF_BANDWIDTH_MB, 100);
            if (Integer.MAX_VALUE != bandwidthMB) {
                in = new ThrottledInputStream((InputStream)new BufferedInputStream((InputStream)in), (long)(bandwidthMB * 1024 * 1024));
            }
            try {
                context.getCounter((Enum)Counter.BYTES_EXPECTED).increment(inputStat.getLen());
                this.outputFs.mkdirs(outputPath.getParent());
                try (FSDataOutputStream out = this.outputFs.create(outputPath, true);){
                    this.copyData(context, inputStat.getPath(), (InputStream)in, outputPath, out, inputStat.getLen());
                }
                if (!this.preserveAttributes(outputPath, inputStat)) {
                    LOG.warn((Object)("You may have to run manually chown on: " + outputPath));
                }
            }
            finally {
                in.close();
            }
        }

        private boolean preserveAttributes(Path path, FileStatus refStat) {
            String group;
            FileStatus stat;
            try {
                stat = this.outputFs.getFileStatus(path);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to get the status for file=" + path));
                return false;
            }
            try {
                if (this.filesMode > 0 && stat.getPermission().toShort() != this.filesMode) {
                    this.outputFs.setPermission(path, new FsPermission(this.filesMode));
                } else if (refStat != null && !stat.getPermission().equals((Object)refStat.getPermission())) {
                    this.outputFs.setPermission(path, refStat.getPermission());
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to set the permission for file=" + stat.getPath() + ": " + e.getMessage()));
                return false;
            }
            boolean hasRefStat = refStat != null;
            String user = this.stringIsNotEmpty(this.filesUser) || !hasRefStat ? this.filesUser : refStat.getOwner();
            String string = group = this.stringIsNotEmpty(this.filesGroup) || !hasRefStat ? this.filesGroup : refStat.getGroup();
            if (this.stringIsNotEmpty(user) || this.stringIsNotEmpty(group)) {
                try {
                    if (!user.equals(stat.getOwner()) || !group.equals(stat.getGroup())) {
                        this.outputFs.setOwner(path, user, group);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unable to set the owner/group for file=" + stat.getPath() + ": " + e.getMessage()));
                    LOG.warn((Object)("The user/group may not exist on the destination cluster: user=" + user + " group=" + group));
                    return false;
                }
            }
            return true;
        }

        private boolean stringIsNotEmpty(String str) {
            return str != null && str.length() > 0;
        }

        private void copyData(Mapper.Context context, Path inputPath, InputStream in, Path outputPath, FSDataOutputStream out, long inputFileSize) throws IOException {
            String statusMessage = "copied %s/" + StringUtils.humanReadableInt((long)inputFileSize) + " (%.1f%%)";
            try {
                int bytesRead;
                byte[] buffer = new byte[this.bufferSize];
                long totalBytesWritten = 0L;
                int reportBytes = 0;
                long stime = System.currentTimeMillis();
                while ((bytesRead = in.read(buffer)) > 0) {
                    out.write(buffer, 0, bytesRead);
                    totalBytesWritten += (long)bytesRead;
                    if ((reportBytes += bytesRead) < 0x100000) continue;
                    context.getCounter((Enum)Counter.BYTES_COPIED).increment((long)reportBytes);
                    context.setStatus(String.format(statusMessage, StringUtils.humanReadableInt((long)totalBytesWritten), Float.valueOf((float)totalBytesWritten / (float)inputFileSize * 100.0f)) + " from " + inputPath + " to " + outputPath);
                    reportBytes = 0;
                }
                long etime = System.currentTimeMillis();
                context.getCounter((Enum)Counter.BYTES_COPIED).increment((long)reportBytes);
                context.setStatus(String.format(statusMessage, StringUtils.humanReadableInt((long)totalBytesWritten), Float.valueOf((float)totalBytesWritten / (float)inputFileSize * 100.0f)) + " from " + inputPath + " to " + outputPath);
                if (totalBytesWritten != inputFileSize) {
                    String msg = "number of bytes copied not matching copied=" + totalBytesWritten + " expected=" + inputFileSize + " for file=" + inputPath;
                    throw new IOException(msg);
                }
                LOG.info((Object)("copy completed for input=" + inputPath + " output=" + outputPath));
                LOG.info((Object)("size=" + totalBytesWritten + " (" + StringUtils.humanReadableInt((long)totalBytesWritten) + ")" + " time=" + StringUtils.formatTimeDiff((long)etime, (long)stime) + String.format(" %.3fM/sec", (double)totalBytesWritten / ((double)(etime - stime) / 1000.0) / 1048576.0)));
                context.getCounter((Enum)Counter.FILES_COPIED).increment(1L);
            }
            catch (IOException e) {
                LOG.error((Object)("Error copying " + inputPath + " to " + outputPath), (Throwable)e);
                context.getCounter((Enum)Counter.COPY_FAILED).increment(1L);
                throw e;
            }
        }

        private FSDataInputStream openSourceFile(Mapper.Context context, SnapshotProtos.SnapshotFileInfo fileInfo) throws IOException {
            try {
                Configuration conf = context.getConfiguration();
                FileLink link = null;
                switch (fileInfo.getType()) {
                    case HFILE: {
                        Path inputPath = new Path(fileInfo.getHfile());
                        link = this.getFileLink(inputPath, conf);
                        break;
                    }
                    case WAL: {
                        String serverName = fileInfo.getWalServer();
                        String logName = fileInfo.getWalName();
                        link = new WALLink(this.inputRoot, serverName, logName);
                        break;
                    }
                    default: {
                        throw new IOException("Invalid File Type: " + fileInfo.getType().toString());
                    }
                }
                return link.open(this.inputFs);
            }
            catch (IOException e) {
                context.getCounter((Enum)Counter.MISSING_FILES).increment(1L);
                LOG.error((Object)("Unable to open source file=" + fileInfo.toString()), (Throwable)e);
                throw e;
            }
        }

        private FileStatus getSourceFileStatus(Mapper.Context context, SnapshotProtos.SnapshotFileInfo fileInfo) throws IOException {
            try {
                Configuration conf = context.getConfiguration();
                FileLink link = null;
                switch (fileInfo.getType()) {
                    case HFILE: {
                        Path inputPath = new Path(fileInfo.getHfile());
                        link = this.getFileLink(inputPath, conf);
                        break;
                    }
                    case WAL: {
                        link = new WALLink(this.inputRoot, fileInfo.getWalServer(), fileInfo.getWalName());
                        break;
                    }
                    default: {
                        throw new IOException("Invalid File Type: " + fileInfo.getType().toString());
                    }
                }
                return link.getFileStatus(this.inputFs);
            }
            catch (FileNotFoundException e) {
                context.getCounter((Enum)Counter.MISSING_FILES).increment(1L);
                LOG.error((Object)("Unable to get the status for source file=" + fileInfo.toString()), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to get the status for source file=" + fileInfo.toString()), (Throwable)e);
                throw e;
            }
        }

        private FileLink getFileLink(Path path, Configuration conf) throws IOException {
            String regionName = HFileLink.getReferencedRegionName(path.getName());
            TableName tableName = HFileLink.getReferencedTableName(path.getName());
            if (MobUtils.getMobRegionInfo(tableName).getEncodedName().equals(regionName)) {
                return HFileLink.buildFromHFileLinkPattern(MobUtils.getQualifiedMobRootDir(conf), HFileArchiveUtil.getArchivePath(conf), path);
            }
            return HFileLink.buildFromHFileLinkPattern(this.inputRoot, this.inputArchive, path);
        }

        private FileChecksum getFileChecksum(FileSystem fs, Path path) {
            try {
                return fs.getFileChecksum(path);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to get checksum for file=" + path), (Throwable)e);
                return null;
            }
        }

        private boolean sameFile(FileStatus inputStat, FileStatus outputStat) {
            if (inputStat.getLen() != outputStat.getLen()) {
                return false;
            }
            if (!this.verifyChecksum) {
                return true;
            }
            FileChecksum inChecksum = this.getFileChecksum(this.inputFs, inputStat.getPath());
            if (inChecksum == null) {
                return false;
            }
            FileChecksum outChecksum = this.getFileChecksum(this.outputFs, outputStat.getPath());
            if (outChecksum == null) {
                return false;
            }
            return inChecksum.equals((Object)outChecksum);
        }
    }

    public static enum Counter {
        MISSING_FILES,
        FILES_COPIED,
        FILES_SKIPPED,
        COPY_FAILED,
        BYTES_EXPECTED,
        BYTES_SKIPPED,
        BYTES_COPIED;

    }
}

